/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.IokeData;
import ioke.lang.IokeObject;
import ioke.lang.TypeCheckingArgumentsDefinition;
import ioke.lang.TypeCheckingNativeMethod;
import ioke.lang.exceptions.ControlFlow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Symbol
extends IokeData {
    private final String text;
    public static final Pattern BAD_CHARS = Pattern.compile("[!=\\.:\\-\\+&|\\{\\[]");

    public Symbol(String text) {
        this.text = text;
    }

    public void init(IokeObject obj) throws ControlFlow {
        obj.setKind("Symbol");
        obj.mimics(IokeObject.as(obj.runtime.mixins.getCell(null, null, "Comparing"), null), obj.runtime.nul, obj.runtime.nul);
        obj.registerMethod(obj.runtime.newNativeMethod("returns true if the left hand side symbol is equal to the right hand side symbol.", new TypeCheckingNativeMethod("=="){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(obj.runtime.symbol).withRequiredPositional("other").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject self, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                this.getArguments().getEvaluatedArguments(context, message, on, args, new HashMap<String, Object>());
                Object other = args.get(0);
                return on == other ? context.runtime._true : context.runtime._false;
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("Returns a text representation of the object", new TypeCheckingNativeMethod.WithNoArguments("asText", obj.runtime.symbol){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newText(Symbol.getText(on));
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("Returns a text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("inspect", obj.runtime.symbol){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newText(Symbol.getInspect(on));
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("Returns a brief text inspection of the object", new TypeCheckingNativeMethod.WithNoArguments("notice", obj.runtime.symbol){

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                return method.runtime.newText(Symbol.getInspect(on));
            }
        }));
        obj.registerMethod(obj.runtime.newNativeMethod("compares this symbol against the argument, returning -1, 0 or 1 based on which one is lexically larger", new TypeCheckingNativeMethod("<=>"){
            private final TypeCheckingArgumentsDefinition ARGUMENTS;
            {
                this.ARGUMENTS = TypeCheckingArgumentsDefinition.builder().receiverMustMimic(obj.runtime.symbol).withRequiredPositional("other").getArguments();
            }

            @Override
            public TypeCheckingArgumentsDefinition getArguments() {
                return this.ARGUMENTS;
            }

            @Override
            public Object activate(IokeObject method, Object on, List<Object> args, Map<String, Object> keywords, IokeObject context, IokeObject message) throws ControlFlow {
                Object arg = args.get(0);
                if (!(IokeObject.data(arg) instanceof Symbol) && !(IokeObject.data(arg = IokeObject.convertToSymbol(arg, message, context, false)) instanceof Symbol)) {
                    return context.runtime.nil;
                }
                return context.runtime.newNumber(Symbol.getText(on).compareTo(Symbol.getText(arg)));
            }
        }));
    }

    public void checkMimic(IokeObject obj, IokeObject m, IokeObject context) throws ControlFlow {
        IokeObject condition = IokeObject.as(IokeObject.getCellChain(context.runtime.condition, m, context, "Error", "CantMimicOddball"), context).mimic(m, context);
        condition.setCell("message", m);
        condition.setCell("context", context);
        condition.setCell("receiver", obj);
        context.runtime.errorCondition(condition);
    }

    public static String getText(Object on) {
        return ((Symbol)IokeObject.data(on)).getText();
    }

    public static String getInspect(Object on) {
        return ((Symbol)IokeObject.data(on)).inspect(on);
    }

    public String getText() {
        return this.text;
    }

    public boolean isSymbol() {
        return true;
    }

    public IokeObject convertToSymbol(IokeObject self, IokeObject m, IokeObject context, boolean signalCondition) {
        return self;
    }

    public IokeObject convertToText(IokeObject self, IokeObject m, IokeObject context, boolean signalCondition) {
        return self.runtime.newText(this.getText());
    }

    public IokeObject tryConvertToText(IokeObject self, IokeObject m, IokeObject context) {
        return self.runtime.newText(this.getText());
    }

    public String toString() {
        return this.text;
    }

    public String toString(IokeObject obj) {
        return this.text;
    }

    public static boolean onlyGoodChars(Object sym) {
        String text = Symbol.getText(sym);
        return text.length() != 0 && !BAD_CHARS.matcher(text).find();
    }

    public String inspect(Object obj) {
        if (!Symbol.onlyGoodChars(obj)) {
            return ":\"" + this.text + "\"";
        }
        return ":" + this.text;
    }
}

