/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.IokeObject;
import ioke.lang.exceptions.ControlFlow;

public interface TypeChecker {
    public static final TypeChecker None = new TypeChecker(){

        public Object convertToMimic(Object on, IokeObject message, IokeObject context, boolean signal) {
            return on;
        }
    };
    public static final TypeChecker Nil = new TypeChecker(){

        public Object convertToMimic(Object on, IokeObject message, IokeObject context, boolean signal) throws ControlFlow {
            if (on == context.runtime.nil) {
                return on;
            }
            if (signal) {
                return context.runtime.nil.convertToThis(on, message, context);
            }
            return context.runtime.nul;
        }
    };

    public Object convertToMimic(Object var1, IokeObject var2, IokeObject var3, boolean var4) throws ControlFlow;

    public static class Or
    implements TypeChecker {
        public final TypeChecker first;
        public final TypeChecker second;

        public Or(TypeChecker first, TypeChecker second) {
            this.first = first;
            this.second = second;
        }

        public Object convertToMimic(Object on, IokeObject message, IokeObject context, boolean signal) throws ControlFlow {
            Object firstResult = this.first.convertToMimic(on, message, context, false);
            if (firstResult == context.runtime.nul) {
                return this.second.convertToMimic(on, message, context, signal);
            }
            return firstResult;
        }
    }
}

