/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang;

import ioke.lang.DefaultArgumentsDefinition;
import ioke.lang.IokeObject;
import ioke.lang.TypeChecker;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCheckingArgumentsDefinition
extends DefaultArgumentsDefinition {
    private List<TypeChecker> mustMimic;
    private TypeChecker receiverMustMimic;
    private List<DefaultArgumentsDefinition.Argument> arguments;

    private TypeCheckingArgumentsDefinition(List<DefaultArgumentsDefinition.Argument> arguments, Collection<String> keywords, String rest, String krest, int min, int max, boolean restUneval, List<TypeChecker> mustMimic, TypeChecker receiverMustMimic) {
        super(arguments, keywords, rest, krest, min, max, restUneval);
        this.arguments = arguments;
        this.mustMimic = mustMimic;
        this.receiverMustMimic = receiverMustMimic;
    }

    public Object getValidatedArgumentsAndReceiver(IokeObject context, IokeObject message, Object on, List<Object> argumentsWithoutKeywords, Map<String, Object> givenKeywords) throws ControlFlow {
        this.getEvaluatedArguments(context, message, on, argumentsWithoutKeywords, givenKeywords);
        int ix = 0;
        int j = this.arguments.size();
        for (int i = 0; i < j; ++i) {
            DefaultArgumentsDefinition.Argument a = this.arguments.get(i);
            if (a instanceof DefaultArgumentsDefinition.KeywordArgument) {
                String name = a.getName() + ":";
                Object given = givenKeywords.get(name);
                if (given == null) continue;
                givenKeywords.put(name, this.mustMimic.get(0).convertToMimic(given, message, context, true));
                continue;
            }
            if (ix >= argumentsWithoutKeywords.size()) continue;
            argumentsWithoutKeywords.set(ix, this.mustMimic.get(i).convertToMimic(argumentsWithoutKeywords.get(ix), message, context, true));
            ++ix;
        }
        return this.receiverMustMimic.convertToMimic(on, message, context, true);
    }

    public static TypeCheckingArgumentsDefinition empty() {
        return new TypeCheckingArgumentsDefinition(new ArrayList<DefaultArgumentsDefinition.Argument>(), new ArrayList<String>(), null, null, 0, 0, false, new ArrayList<TypeChecker>(), TypeChecker.None);
    }

    public static TypeCheckingArgumentsDefinition emptyButReceiverMustMimic(Object mimic) {
        return new TypeCheckingArgumentsDefinition(new ArrayList<DefaultArgumentsDefinition.Argument>(), new ArrayList<String>(), null, null, 0, 0, false, new ArrayList<TypeChecker>(), (IokeObject)mimic);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DefaultArgumentsDefinition.Builder {
        private List<TypeChecker> mustMimic = new ArrayList<TypeChecker>();
        private TypeChecker receiverMustMimic = TypeChecker.None;
        private boolean setMimic = true;

        private void next() {
            if (!this.setMimic) {
                this.mustMimic.add(TypeChecker.None);
            }
            this.setMimic = false;
        }

        public Builder whichMustMimic(IokeObject mimic) {
            this.mustMimic.add(mimic);
            this.setMimic = true;
            return this;
        }

        public Builder or(IokeObject mimic) {
            int ix = this.mustMimic.size() - 1;
            this.mustMimic.set(ix, new TypeChecker.Or(this.mustMimic.get(ix), mimic));
            return this;
        }

        public Builder orBeNil() {
            int ix = this.mustMimic.size() - 1;
            this.mustMimic.set(ix, new TypeChecker.Or(this.mustMimic.get(ix), TypeChecker.Nil));
            return this;
        }

        public Builder receiverMustMimic(IokeObject mimic) {
            this.receiverMustMimic = mimic;
            return this;
        }

        public Builder withKeyword(String name) {
            this.next();
            super.withKeyword(name);
            return this;
        }

        public Builder withKeywordRest(String name) {
            this.next();
            super.withKeywordRest(name);
            return this;
        }

        public Builder withOptionalPositional(String name, String defaultValue) {
            this.next();
            super.withOptionalPositional(name, defaultValue);
            return this;
        }

        public Builder withOptionalPositionalUnevaluated(String name) {
            this.next();
            super.withOptionalPositionalUnevaluated(name);
            return this;
        }

        public Builder withRequiredPositional(String name) {
            this.next();
            super.withRequiredPositional(name);
            return this;
        }

        public Builder withRequiredPositionalUnevaluated(String name) {
            this.next();
            super.withRequiredPositionalUnevaluated(name);
            return this;
        }

        public Builder withRest(String name) {
            this.next();
            super.withRest(name);
            return this;
        }

        public Builder withRestUnevaluated(String name) {
            this.next();
            super.withRestUnevaluated(name);
            return this;
        }

        public TypeCheckingArgumentsDefinition getArguments() {
            this.next();
            return new TypeCheckingArgumentsDefinition(this.arguments, this.keywords, this.rest, this.krest, this.min, this.max, this.restUneval, this.mustMimic, this.receiverMustMimic);
        }

        public static class OrNil {
            public final Object realKind;

            public OrNil(Object realKind) {
                this.realKind = realKind;
            }
        }
    }
}

