/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang.exceptions;

import ioke.lang.IokeObject;
import ioke.lang.Runtime;
import java.util.List;

public class ControlFlow
extends Throwable {
    private Object value;

    public ControlFlow(Object value) {
        this.value = value;
    }

    public ControlFlow(Object value, String message) {
        super(message);
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Throwable fillInStackTrace() {
        return this;
    }

    public static class Rescue
    extends ControlFlow {
        private IokeObject condition;

        public Rescue(Runtime.RescueInfo value, IokeObject condition) {
            super(value);
            this.condition = condition;
        }

        public Runtime.RescueInfo getRescue() {
            return (Runtime.RescueInfo)this.getValue();
        }

        public IokeObject getCondition() {
            return this.condition;
        }

        public String toString() {
            return "rescue: " + this.getValue().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Restart
    extends ControlFlow {
        private List<Object> arguments;

        public Restart(Runtime.RestartInfo value, List<Object> arguments) {
            super(value);
            this.arguments = arguments;
        }

        public Runtime.RestartInfo getRestart() {
            return (Runtime.RestartInfo)this.getValue();
        }

        public List<Object> getArguments() {
            return this.arguments;
        }
    }

    public static class Return
    extends ControlFlow {
        public final Object context;

        public Return(Object value, Object context) {
            super(value);
            this.context = context;
        }
    }

    public static class Continue
    extends ControlFlow {
        public Continue() {
            super((Object)null);
        }
    }

    public static class Break
    extends ControlFlow {
        public Break(Object value) {
            super(value);
        }
    }

    public static class Exit
    extends ControlFlow {
        private int exitValue = 1;

        public Exit() {
            super((Object)null);
        }

        public Exit(Object reason) {
            super(reason, "OH NO, exit out of place, because of: " + reason);
        }

        public Exit(int value) {
            super((Object)null);
            this.exitValue = value;
        }

        public Exit(Object reason, int value) {
            super(reason, "OH NO, exit out of place, because of: " + reason);
            this.exitValue = value;
        }

        public int getExitValue() {
            return this.exitValue;
        }
    }
}

