/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang.java;

import ioke.lang.Runtime;
import ioke.lang.java.IokeClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassRegistry {
    final Runtime runtime;
    final IokeClassLoader classLoader;
    private final Map<String, String> NAMES = new ConcurrentHashMap<String, String>();

    public ClassRegistry(Runtime runtime) {
        this.runtime = runtime;
        this.classLoader = new IokeClassLoader(runtime.getClass().getClassLoader());
    }

    public void defineClass(String className, String realName, byte[] classData) {
        this.classLoader.defineClass(className, classData);
        this.NAMES.put(realName, className);
    }

    public boolean hasImplementation(String name) {
        return this.NAMES.containsKey(name);
    }

    public Class getImplementation(String name) {
        try {
            return Class.forName(this.NAMES.get(name), true, this.classLoader);
        }
        catch (Exception e) {
            return null;
        }
    }

    public IokeClassLoader getClassLoader() {
        return this.classLoader;
    }
}

