/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang.java;

import ioke.lang.java.ClassRegistry;
import ioke.lang.java.JavaInvocationHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JavaIntegration {
    private static final String P_JAVA_INVOCATION_HELPER = JavaIntegration.p(JavaInvocationHelper.class);
    private static final Map<String, String> NAMES = new ConcurrentHashMap<String, String>();

    public static Class getOrCreate(Class[] types, ClassRegistry registry) {
        JavaIntegration.sort(types);
        String name = JavaIntegration.createCompositeNameFor(types);
        if (!JavaIntegration.hasImplementation(name, registry)) {
            JavaIntegration.createImplementationFor(name, types, registry);
        }
        return JavaIntegration.getImplementationFor(name, registry);
    }

    private static void sort(Class[] types) {
        Arrays.sort(types, new Comparator<Class>(){

            @Override
            public int compare(Class one, Class two) {
                return one.getName().compareTo(two.getName());
            }
        });
    }

    private static String createCompositeNameFor(Class[] types) {
        StringBuilder sb = new StringBuilder(types.length * 15);
        String sep = "";
        for (Class type : types) {
            sb.append(sep).append(type.getName());
            sep = ",";
        }
        return sb.toString();
    }

    private static boolean hasImplementation(String name, ClassRegistry registry) {
        return registry.hasImplementation(name);
    }

    private static Class getImplementationFor(String name, ClassRegistry registry) {
        return registry.getImplementation(name);
    }

    private static void createImplementationFor(String name, Class[] types, ClassRegistry registry) {
        String className = JavaIntegration.findFirstUnusedNameFor(types);
        Class superClass = Object.class;
        LinkedList<Class> interfaces = new LinkedList<Class>();
        for (Class type : types) {
            if (!type.isInterface()) {
                superClass = type;
                continue;
            }
            interfaces.add(type);
        }
        ClassWriter cw = new ClassWriter(2);
        String[] ifs = new String[interfaces.size() + 1];
        int ix = 0;
        for (Class type : interfaces) {
            ifs[ix++] = JavaIntegration.p(type);
        }
        ifs[ix] = "ioke/lang/java/IokeJavaIntegrated";
        cw.visit(49, 1, JavaIntegration.p(className), null, JavaIntegration.p(superClass), ifs);
        cw.visitField(0, "__real_ioke_proxy", "Lioke/lang/IokeObject;", null, null);
        JavaIntegration.implementConstructor(cw, className, superClass);
        JavaIntegration.implementIntegrationMethods(cw, className, superClass);
        if (superClass != Object.class) {
            JavaIntegration.implementStubMethodsFor(cw, className, superClass);
        }
        for (Class iface : interfaces) {
            JavaIntegration.implementStubMethodsFor(cw, className, iface);
        }
        cw.visitEnd();
        byte[] b = cw.toByteArray();
        registry.defineClass(className, name, b);
    }

    private static void implementConstructor(ClassWriter cw, String className, Class superClass) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lioke/lang/IokeObject;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, JavaIntegration.p(superClass), "<init>", "()V");
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, JavaIntegration.p(className), "__real_ioke_proxy", "Lioke/lang/IokeObject;");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void implementIntegrationMethods(ClassWriter cw, String className, Class superClass) {
        MethodVisitor mv = cw.visitMethod(1, "__get_IokeProxy", "()Lioke/lang/IokeObject;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, JavaIntegration.p(className), "__real_ioke_proxy", "Lioke/lang/IokeObject;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "__get_IokeRuntime", "()Lioke/lang/Runtime;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, JavaIntegration.p(className), "__real_ioke_proxy", "Lioke/lang/IokeObject;");
        mv.visitFieldInsn(180, "ioke/lang/IokeObject", "runtime", "Lioke/lang/Runtime;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void implementStubMethodsFor(ClassWriter cw, String className, Class type) {
        for (Method m : type.getDeclaredMethods()) {
            int modifiers = m.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
            JavaIntegration.implementStubMethod(cw, className, type, m);
        }
    }

    private static void loadParameter(MethodVisitor mv, Class parameterType, int position) {
        if (parameterType == Byte.TYPE || parameterType == Integer.TYPE || parameterType == Short.TYPE || parameterType == Character.TYPE || parameterType == Boolean.TYPE) {
            mv.visitVarInsn(21, position);
        } else if (parameterType == Long.TYPE) {
            mv.visitVarInsn(22, position);
        } else if (parameterType == Float.TYPE) {
            mv.visitVarInsn(23, position);
        } else if (parameterType == Double.TYPE) {
            mv.visitVarInsn(24, position);
        } else {
            mv.visitVarInsn(25, position);
        }
    }

    private static void loadParameterWithConversion(MethodVisitor mv, Class parameterType, int position) {
        if (parameterType == Byte.TYPE) {
            mv.visitVarInsn(21, position);
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (parameterType == Integer.TYPE) {
            mv.visitVarInsn(21, position);
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (parameterType == Short.TYPE) {
            mv.visitVarInsn(21, position);
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (parameterType == Character.TYPE) {
            mv.visitVarInsn(21, position);
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (parameterType == Long.TYPE) {
            mv.visitVarInsn(22, position);
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (parameterType == Float.TYPE) {
            mv.visitVarInsn(23, position);
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (parameterType == Double.TYPE) {
            mv.visitVarInsn(24, position);
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else if (parameterType == Boolean.TYPE) {
            mv.visitVarInsn(21, position);
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else {
            mv.visitVarInsn(25, position);
        }
    }

    private static void implementStubMethod(ClassWriter cw, String className, Class type, Method m) {
        MethodVisitor mv = cw.visitMethod(1, m.getName(), JavaIntegration.sig(m), null, null);
        Class<?> retType = m.getReturnType();
        mv.visitCode();
        if (!type.isInterface()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(m.getName());
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "hasProxyMethod", "(Lioke/lang/java/IokeJavaIntegrated;Ljava/lang/String;)Z");
            mv.visitInsn(3);
            Label els = new Label();
            mv.visitJumpInsn(160, els);
            mv.visitVarInsn(25, 0);
            Class<?>[] params = m.getParameterTypes();
            int i = 1;
            for (Class<?> pType : params) {
                JavaIntegration.loadParameter(mv, pType, i++);
            }
            mv.visitMethodInsn(183, JavaIntegration.p(type), m.getName(), JavaIntegration.sig(m));
            if (retType == Void.TYPE) {
                mv.visitInsn(177);
            } else if (retType == Byte.TYPE || retType == Integer.TYPE || retType == Short.TYPE || retType == Character.TYPE || retType == Boolean.TYPE) {
                mv.visitInsn(172);
            } else if (retType == Long.TYPE) {
                mv.visitInsn(173);
            } else if (retType == Float.TYPE) {
                mv.visitInsn(174);
            } else if (retType == Double.TYPE) {
                mv.visitInsn(175);
            } else {
                mv.visitInsn(176);
            }
            mv.visitLabel(els);
        }
        mv.visitVarInsn(25, 0);
        Class<?>[] params = m.getParameterTypes();
        int i = 1;
        mv.visitIntInsn(16, params.length);
        mv.visitTypeInsn(189, "java/lang/Object");
        for (Class<?> pType : params) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i - 1);
            JavaIntegration.loadParameterWithConversion(mv, pType, i++);
            mv.visitInsn(83);
        }
        mv.visitLdcInsn(m.getName());
        if (retType == Void.TYPE) {
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "voidInvocation", "(Lioke/lang/java/IokeJavaIntegrated;[Ljava/lang/Object;Ljava/lang/String;)V");
            mv.visitInsn(177);
        } else if (retType == Byte.TYPE) {
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "byteInvocation", "(Lioke/lang/java/IokeJavaIntegrated;[Ljava/lang/Object;Ljava/lang/String;)B");
            mv.visitInsn(172);
        } else if (retType == Integer.TYPE) {
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "intInvocation", "(Lioke/lang/java/IokeJavaIntegrated;[Ljava/lang/Object;Ljava/lang/String;)I");
            mv.visitInsn(172);
        } else if (retType == Short.TYPE) {
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "shortInvocation", "(Lioke/lang/java/IokeJavaIntegrated;[Ljava/lang/Object;Ljava/lang/String;)S");
            mv.visitInsn(172);
        } else if (retType == Character.TYPE) {
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "charInvocation", "(Lioke/lang/java/IokeJavaIntegrated;[Ljava/lang/Object;Ljava/lang/String;)C");
            mv.visitInsn(172);
        } else if (retType == Boolean.TYPE) {
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "booleanInvocation", "(Lioke/lang/java/IokeJavaIntegrated;[Ljava/lang/Object;Ljava/lang/String;)Z");
            mv.visitInsn(172);
        } else if (retType == Long.TYPE) {
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "longInvocation", "(Lioke/lang/java/IokeJavaIntegrated;[Ljava/lang/Object;Ljava/lang/String;)J");
            mv.visitInsn(173);
        } else if (retType == Float.TYPE) {
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "floatInvocation", "(Lioke/lang/java/IokeJavaIntegrated;[Ljava/lang/Object;Ljava/lang/String;)F");
            mv.visitInsn(174);
        } else if (retType == Double.TYPE) {
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "doubleInvocation", "(Lioke/lang/java/IokeJavaIntegrated;[Ljava/lang/Object;Ljava/lang/String;)D");
            mv.visitInsn(175);
        } else {
            mv.visitLdcInsn(retType.getName());
            mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            mv.visitMethodInsn(184, P_JAVA_INVOCATION_HELPER, "objectInvocation", "(Lioke/lang/java/IokeJavaIntegrated;[Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;");
            mv.visitTypeInsn(192, JavaIntegration.p(retType));
            mv.visitInsn(176);
        }
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static String sig(Method m) {
        return Type.getMethodDescriptor(m);
    }

    private static String p(String name) {
        return name.replaceAll("\\.", "/");
    }

    private static String p(Class type) {
        return type.getName().replaceAll("\\.", "/");
    }

    private static synchronized String findFirstUnusedNameFor(Class[] types) {
        Class mainType = null;
        for (Class type : types) {
            if (type.isInterface()) continue;
            mainType = type;
            break;
        }
        if (mainType == null) {
            mainType = types[0];
        }
        int number = 0;
        String baseName = "ioke.syn." + mainType.getName() + "$ioke$";
        String current = baseName + number++;
        while (NAMES.containsKey(current)) {
            current = baseName + number++;
        }
        NAMES.put(current, "dummy");
        return current;
    }
}

