/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang.java;

import ioke.lang.Decimal;
import ioke.lang.IokeObject;
import ioke.lang.JavaWrapper;
import ioke.lang.Message;
import ioke.lang.NativeImplementedMethod;
import ioke.lang.Number;
import ioke.lang.Runtime;
import ioke.lang.Symbol;
import ioke.lang.Text;
import ioke.lang.exceptions.ControlFlow;
import ioke.lang.java.IokeJavaIntegrated;

public class JavaInvocationHelper {
    public static boolean hasProxyMethod(IokeJavaIntegrated object, String name) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Object cell = IokeObject.findCell(pr, null, null, name);
        if (cell != null && cell != runtime.nul && cell instanceof IokeObject) {
            return !(IokeObject.data(cell) instanceof NativeImplementedMethod);
        }
        return false;
    }

    public static void voidInvocation(IokeJavaIntegrated object, Object[] args, String name) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Message newMessage = new Message(runtime, name);
        for (Object arg : args) {
            newMessage.getArguments(null).add(runtime.createMessage(Message.wrap(arg, runtime)));
        }
        try {
            IokeObject msg = runtime.createMessage(newMessage);
            ((Message)IokeObject.data(msg)).sendTo(msg, runtime.ground, pr);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static byte byteInvocation(IokeJavaIntegrated object, Object[] args, String name) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Message newMessage = new Message(runtime, name);
        for (Object arg : args) {
            newMessage.getArguments(null).add(runtime.createMessage(Message.wrap(arg, runtime)));
        }
        try {
            IokeObject msg = runtime.createMessage(newMessage);
            Object result = ((Message)IokeObject.data(msg)).sendTo(msg, runtime.ground, pr);
            if (result instanceof Byte) {
                return (Byte)result;
            }
            if (result instanceof IokeObject && IokeObject.data(result) instanceof JavaWrapper && JavaWrapper.getObject(result) instanceof Byte) {
                return (Byte)JavaWrapper.getObject(result);
            }
            if (!(result instanceof IokeObject)) break block7;
            if (IokeObject.data(result) instanceof Number) {
                return (byte)Number.intValue(result).intValue();
            }
        }
        finally {
            return 0;
        }
        {
            block7: {
            }
        }
    }

    public static int intInvocation(IokeJavaIntegrated object, Object[] args, String name) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Message newMessage = new Message(runtime, name);
        for (Object arg : args) {
            newMessage.getArguments(null).add(runtime.createMessage(Message.wrap(arg, runtime)));
        }
        try {
            IokeObject msg = runtime.createMessage(newMessage);
            Object result = ((Message)IokeObject.data(msg)).sendTo(msg, runtime.ground, pr);
            if (result instanceof Integer) {
                return (Integer)result;
            }
            if (result instanceof IokeObject && IokeObject.data(result) instanceof JavaWrapper && JavaWrapper.getObject(result) instanceof Integer) {
                return (Integer)JavaWrapper.getObject(result);
            }
            if (!(result instanceof IokeObject)) break block7;
            if (IokeObject.data(result) instanceof Number) {
                return Number.intValue(result).intValue();
            }
        }
        finally {
            return 0;
        }
        {
            block7: {
            }
        }
    }

    public static short shortInvocation(IokeJavaIntegrated object, Object[] args, String name) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Message newMessage = new Message(runtime, name);
        for (Object arg : args) {
            newMessage.getArguments(null).add(runtime.createMessage(Message.wrap(arg, runtime)));
        }
        try {
            IokeObject msg = runtime.createMessage(newMessage);
            Object result = ((Message)IokeObject.data(msg)).sendTo(msg, runtime.ground, pr);
            if (result instanceof Short) {
                return (Short)result;
            }
            if (result instanceof IokeObject && IokeObject.data(result) instanceof JavaWrapper && JavaWrapper.getObject(result) instanceof Short) {
                return (Short)JavaWrapper.getObject(result);
            }
            if (!(result instanceof IokeObject)) break block7;
            if (IokeObject.data(result) instanceof Number) {
                return (short)Number.intValue(result).intValue();
            }
        }
        finally {
            return 0;
        }
        {
            block7: {
            }
        }
    }

    public static char charInvocation(IokeJavaIntegrated object, Object[] args, String name) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Message newMessage = new Message(runtime, name);
        for (Object arg : args) {
            newMessage.getArguments(null).add(runtime.createMessage(Message.wrap(arg, runtime)));
        }
        try {
            IokeObject msg = runtime.createMessage(newMessage);
            Object result = ((Message)IokeObject.data(msg)).sendTo(msg, runtime.ground, pr);
            if (result instanceof Character) {
                return Character.valueOf(((Character)result).charValue()).charValue();
            }
            if (result instanceof IokeObject && IokeObject.data(result) instanceof JavaWrapper && JavaWrapper.getObject(result) instanceof Character) {
                return Character.valueOf(((Character)JavaWrapper.getObject(result)).charValue()).charValue();
            }
            if (!(result instanceof IokeObject)) break block7;
            if (IokeObject.data(result) instanceof Number) {
                return Character.valueOf((char)Number.intValue(result).intValue()).charValue();
            }
        }
        finally {
            return '\u0000';
        }
        {
            block7: {
            }
        }
    }

    public static boolean booleanInvocation(IokeJavaIntegrated object, Object[] args, String name) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Message newMessage = new Message(runtime, name);
        for (Object arg : args) {
            newMessage.getArguments(null).add(runtime.createMessage(Message.wrap(arg, runtime)));
        }
        try {
            IokeObject msg = runtime.createMessage(newMessage);
            Object result = ((Message)IokeObject.data(msg)).sendTo(msg, runtime.ground, pr);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof IokeObject && IokeObject.data(result) instanceof JavaWrapper && JavaWrapper.getObject(result) instanceof Boolean) {
                return (Boolean)JavaWrapper.getObject(result);
            }
            if (result == runtime._true) {
                return true;
            }
            if (result == runtime._false) {
                return false;
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    public static long longInvocation(IokeJavaIntegrated object, Object[] args, String name) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Message newMessage = new Message(runtime, name);
        for (Object arg : args) {
            newMessage.getArguments(null).add(runtime.createMessage(Message.wrap(arg, runtime)));
        }
        try {
            IokeObject msg = runtime.createMessage(newMessage);
            Object result = ((Message)IokeObject.data(msg)).sendTo(msg, runtime.ground, pr);
            if (result instanceof Long) {
                return (Long)result;
            }
            if (result instanceof IokeObject && IokeObject.data(result) instanceof JavaWrapper && JavaWrapper.getObject(result) instanceof Long) {
                return ((Integer)JavaWrapper.getObject(result)).intValue();
            }
            if (!(result instanceof IokeObject)) break block7;
            if (IokeObject.data(result) instanceof Number) {
                return Number.value(result).longValue();
            }
        }
        finally {
            return 0L;
        }
        {
            block7: {
            }
        }
    }

    public static float floatInvocation(IokeJavaIntegrated object, Object[] args, String name) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Message newMessage = new Message(runtime, name);
        for (Object arg : args) {
            newMessage.getArguments(null).add(runtime.createMessage(Message.wrap(arg, runtime)));
        }
        try {
            IokeObject msg = runtime.createMessage(newMessage);
            Object result = ((Message)IokeObject.data(msg)).sendTo(msg, runtime.ground, pr);
            if (result instanceof Float) {
                return Float.valueOf(((Float)result).floatValue()).floatValue();
            }
            if (result instanceof IokeObject && IokeObject.data(result) instanceof JavaWrapper && JavaWrapper.getObject(result) instanceof Float) {
                return Float.valueOf(((Float)JavaWrapper.getObject(result)).floatValue()).floatValue();
            }
            if (!(result instanceof IokeObject)) break block7;
            if (IokeObject.data(result) instanceof Decimal) {
                return Float.valueOf(Decimal.value(result).floatValue()).floatValue();
            }
        }
        finally {
            return 0.0f;
        }
        {
            block7: {
            }
        }
    }

    public static double doubleInvocation(IokeJavaIntegrated object, Object[] args, String name) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Message newMessage = new Message(runtime, name);
        for (Object arg : args) {
            newMessage.getArguments(null).add(runtime.createMessage(Message.wrap(arg, runtime)));
        }
        try {
            IokeObject msg = runtime.createMessage(newMessage);
            Object result = ((Message)IokeObject.data(msg)).sendTo(msg, runtime.ground, pr);
            if (result instanceof Double) {
                return (Double)result;
            }
            if (result instanceof IokeObject && IokeObject.data(result) instanceof JavaWrapper && JavaWrapper.getObject(result) instanceof Double) {
                return (Double)JavaWrapper.getObject(result);
            }
            if (!(result instanceof IokeObject)) break block7;
            if (IokeObject.data(result) instanceof Decimal) {
                return Decimal.value(result).doubleValue();
            }
        }
        finally {
            return 0.0;
        }
        {
            block7: {
            }
        }
    }

    public static Object objectInvocation(IokeJavaIntegrated object, Object[] args, String name, Class expectedType) {
        IokeObject pr = object.__get_IokeProxy();
        Runtime runtime = object.__get_IokeRuntime();
        Message newMessage = new Message(runtime, name);
        for (Object arg : args) {
            newMessage.getArguments(null).add(runtime.createMessage(Message.wrap(arg, runtime)));
        }
        try {
            IokeObject msg = runtime.createMessage(newMessage);
            return JavaInvocationHelper.tryConvertTo(((Message)IokeObject.data(msg)).sendTo(msg, runtime.ground, pr), expectedType, runtime);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Object tryConvertTo(Object obj, Class expectedType, Runtime runtime) throws ControlFlow {
        boolean isWrapper;
        Class clz = expectedType;
        boolean isIokeObject = obj instanceof IokeObject;
        boolean bl = isWrapper = isIokeObject && IokeObject.data(obj) instanceof JavaWrapper;
        if (obj == runtime.nil) {
            return null;
        }
        if (clz == String.class) {
            if (obj instanceof String) {
                return obj;
            }
            if (isWrapper && JavaWrapper.getObject(obj) instanceof String) {
                return JavaWrapper.getObject(obj);
            }
            if (isIokeObject && IokeObject.data(obj) instanceof Text) {
                return Text.getText(obj);
            }
            if (isIokeObject && IokeObject.data(obj) instanceof Symbol) {
                return Symbol.getText(obj);
            }
        } else if (clz == Character.class) {
            if (obj instanceof Character) {
                return obj;
            }
            if (isWrapper && JavaWrapper.getObject(obj) instanceof Character) {
                return JavaWrapper.getObject(obj);
            }
            if (isIokeObject && IokeObject.data(obj) instanceof Number) {
                return new Character((char)Number.intValue(obj).intValue());
            }
        } else if (clz == Integer.class) {
            if (obj instanceof Integer) {
                return obj;
            }
            if (isWrapper && JavaWrapper.getObject(obj) instanceof Integer) {
                return JavaWrapper.getObject(obj);
            }
            if (isIokeObject && IokeObject.data(obj) instanceof Number) {
                return Number.intValue(obj).intValue();
            }
        } else if (clz == Short.class) {
            if (obj instanceof Short) {
                return obj;
            }
            if (isWrapper && JavaWrapper.getObject(obj) instanceof Short) {
                return JavaWrapper.getObject(obj);
            }
            if (isIokeObject && IokeObject.data(obj) instanceof Number) {
                return (short)Number.intValue(obj).intValue();
            }
        } else if (clz == Long.class) {
            if (obj instanceof Long) {
                return obj;
            }
            if (isWrapper && JavaWrapper.getObject(obj) instanceof Long) {
                return JavaWrapper.getObject(obj);
            }
            if (isIokeObject && IokeObject.data(obj) instanceof Number) {
                return Number.value(obj).longValue();
            }
        } else if (clz == Float.class) {
            if (obj instanceof Float) {
                return obj;
            }
            if (isWrapper && JavaWrapper.getObject(obj) instanceof Float) {
                return JavaWrapper.getObject(obj);
            }
            if (isIokeObject && IokeObject.data(obj) instanceof Decimal) {
                return Float.valueOf(Decimal.value(obj).floatValue());
            }
        } else if (clz == Double.class) {
            if (obj instanceof Double) {
                return obj;
            }
            if (isWrapper && JavaWrapper.getObject(obj) instanceof Double) {
                return JavaWrapper.getObject(obj);
            }
            if (isIokeObject && IokeObject.data(obj) instanceof Decimal) {
                return Decimal.value(obj).doubleValue();
            }
        } else if (clz == Boolean.class) {
            if (obj instanceof Boolean) {
                return obj;
            }
            if (isWrapper && JavaWrapper.getObject(obj) instanceof Boolean) {
                return JavaWrapper.getObject(obj);
            }
            if (obj == runtime._true) {
                return Boolean.TRUE;
            }
            if (obj == runtime._false) {
                return Boolean.FALSE;
            }
        } else {
            if (clz == Object.class) {
                if (isWrapper) {
                    return JavaWrapper.getObject(obj);
                }
                return obj;
            }
            if (!isIokeObject) {
                return obj;
            }
            if (isWrapper) {
                return JavaWrapper.getObject(obj);
            }
        }
        return obj;
    }
}

