/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang.parser;

import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.exceptions.ControlFlow;
import ioke.lang.parser.BufferedChain;
import ioke.lang.parser.Level;

final class ChainContext {
    final ChainContext parent;
    BufferedChain chains = new BufferedChain(null, null, null);
    IokeObject last = null;
    IokeObject head = null;
    Level currentLevel = new Level(-1, null, null, Level.Type.REGULAR);

    ChainContext(ChainContext parent) {
        this.parent = parent;
    }

    IokeObject prepareAssignmentMessage() throws ControlFlow {
        if (this.chains.last != null && this.chains.last == this.currentLevel.operatorMessage) {
            if (this.currentLevel.type == Level.Type.ASSIGNMENT && this.head == null) {
                IokeObject assgn = this.currentLevel.operatorMessage;
                IokeObject prev = (IokeObject)assgn.getArguments().get(0);
                assgn.getArguments().clear();
                this.pop();
                this.currentLevel = this.currentLevel.parent;
                IokeObject realPrev = Message.prev(assgn);
                if (realPrev != null) {
                    Message.setNext(realPrev, prev);
                    if (prev != null) {
                        Message.setPrev(prev, realPrev);
                    }
                    Message.setPrev(assgn, null);
                }
                if (this.head == this.last) {
                    this.head = prev;
                }
                this.last = prev;
                return assgn;
            }
            if (this.last == null && this.currentLevel.type != Level.Type.ASSIGNMENT) {
                this.pop();
                this.currentLevel = this.currentLevel.parent;
            }
        }
        if (this.last == null) {
            return null;
        }
        IokeObject l = this.last;
        if (this.head == l) {
            this.last = null;
            this.head = null;
        } else {
            this.last = Message.prev(l);
            Message.setNext(this.last, null);
        }
        Message.setPrev(l, null);
        Message.setNext(l, null);
        return l;
    }

    void add(IokeObject msg) throws ControlFlow {
        if (this.head == null) {
            this.head = this.last = msg;
        } else {
            Message.setNext(this.last, msg);
            Message.setPrev(msg, this.last);
            this.last = msg;
        }
        if (this.currentLevel.type == Level.Type.UNARY) {
            this.currentLevel.operatorMessage.getArguments().add(this.pop());
            this.currentLevel = this.currentLevel.parent;
        }
    }

    void push(int precedence, IokeObject op, Level.Type type) {
        this.currentLevel = new Level(precedence, op, this.currentLevel, type);
        this.chains = new BufferedChain(this.chains, this.last, this.head);
        this.head = null;
        this.last = null;
    }

    IokeObject pop() throws ControlFlow {
        if (this.head != null) {
            while (Message.isTerminator(this.head) && Message.next(this.head) != null) {
                this.head = Message.next(this.head);
                Message.setPrev(this.head, null);
            }
        }
        IokeObject headToReturn = this.head;
        this.head = this.chains.head;
        this.last = this.chains.last;
        this.chains = this.chains.parent;
        return headToReturn;
    }

    void popOperatorsTo(int precedence) throws ControlFlow {
        while ((this.currentLevel.precedence != -1 || this.currentLevel.type == Level.Type.UNARY) && this.currentLevel.precedence <= precedence) {
            IokeObject arg = this.pop();
            if (arg != null && Message.isTerminator(arg) && Message.next(arg) == null) {
                arg = null;
            }
            IokeObject op = this.currentLevel.operatorMessage;
            if (this.currentLevel.type == Level.Type.INVERTED && Message.prev(op) != null) {
                Message.setNext(Message.prev(op), null);
                op.getArguments().add(this.head);
                this.head = arg;
                Message.setNextOfLast(this.head, op);
                this.last = op;
            } else if (arg != null) {
                op.getArguments().add(arg);
            }
            this.currentLevel = this.currentLevel.parent;
        }
    }
}

