/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang.parser;

import ioke.lang.IokeObject;
import ioke.lang.IokeSystem;
import ioke.lang.Message;
import ioke.lang.Runtime;
import ioke.lang.exceptions.ControlFlow;
import ioke.lang.parser.ChainContext;
import ioke.lang.parser.Level;
import ioke.lang.parser.Operators;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IokeParser {
    final Runtime runtime;
    final Reader reader;
    final IokeObject context;
    final IokeObject message;
    ChainContext top = new ChainContext(null);
    final Map<String, Operators.OpEntry> operatorTable = new HashMap<String, Operators.OpEntry>();
    final Map<String, Operators.OpArity> trinaryOperatorTable = new HashMap<String, Operators.OpArity>();
    final Map<String, Operators.OpEntry> invertedOperatorTable = new HashMap<String, Operators.OpEntry>();
    final Set<String> unaryOperators = Operators.DEFAULT_UNARY_OPERATORS;
    final Set<String> onlyUnaryOperators = Operators.DEFAULT_ONLY_UNARY_OPERATORS;
    private int lineNumber = 1;
    private int currentCharacter = -1;
    private boolean skipLF = false;
    private int saved2 = -2;
    private int saved = -2;
    private static final String[] RANGES = new String[]{"", ".", "..", "...", "....", ".....", "......", ".......", "........", ".........", "..........", "...........", "............"};

    public IokeParser(Runtime runtime, Reader reader, IokeObject context, IokeObject message) throws ControlFlow {
        this.runtime = runtime;
        this.reader = reader;
        this.context = context;
        this.message = message;
        Operators.createOrGetOpTables(this);
    }

    public IokeObject parseFully() throws IOException, ControlFlow {
        IokeObject result = this.parseMessageChain();
        return result;
    }

    private IokeObject parseMessageChain() throws IOException, ControlFlow {
        this.top = new ChainContext(this.top);
        while (this.parseMessage()) {
        }
        this.top.popOperatorsTo(999999);
        IokeObject ret = this.top.pop();
        this.top = this.top.parent;
        return ret;
    }

    private List<Object> parseCommaSeparatedMessageChains() throws IOException, ControlFlow {
        ArrayList<Object> chain = new ArrayList<Object>();
        IokeObject curr = this.parseMessageChain();
        while (curr != null) {
            chain.add(curr);
            this.readWhiteSpace();
            int rr = this.peek();
            if (rr == 44) {
                this.read();
                curr = this.parseMessageChain();
                if (curr != null) continue;
                this.fail("Expected expression following comma");
                continue;
            }
            if (curr != null && Message.isTerminator(curr) && Message.next(curr) == null) {
                chain.remove(chain.size() - 1);
            }
            curr = null;
        }
        return chain;
    }

    private int read() throws IOException {
        if (this.saved > -2) {
            int x = this.saved;
            this.saved = this.saved2;
            this.saved2 = -2;
            if (this.skipLF) {
                this.skipLF = false;
                if (x == 10) {
                    return x;
                }
            }
            ++this.currentCharacter;
            switch (x) {
                case 13: {
                    this.skipLF = true;
                }
                case 10: {
                    ++this.lineNumber;
                    this.currentCharacter = 0;
                }
            }
            return x;
        }
        int xx = this.reader.read();
        if (this.skipLF) {
            this.skipLF = false;
            if (xx == 10) {
                return xx;
            }
        }
        ++this.currentCharacter;
        switch (xx) {
            case 13: {
                this.skipLF = true;
            }
            case 10: {
                ++this.lineNumber;
                this.currentCharacter = 0;
            }
        }
        return xx;
    }

    private int peek() throws IOException {
        if (this.saved == -2) {
            if (this.saved2 != -2) {
                this.saved = this.saved2;
                this.saved2 = -2;
            } else {
                this.saved = this.reader.read();
            }
        }
        return this.saved;
    }

    private int peek2() throws IOException {
        if (this.saved == -2) {
            this.saved = this.reader.read();
        }
        if (this.saved2 == -2) {
            this.saved2 = this.reader.read();
        }
        return this.saved2;
    }

    private boolean parseMessage() throws IOException, ControlFlow {
        int rr;
        block24: while (true) {
            rr = this.peek();
            switch (rr) {
                case -1: {
                    this.read();
                    return false;
                }
                case 41: 
                case 44: 
                case 93: 
                case 125: {
                    return false;
                }
                case 40: {
                    this.read();
                    this.parseEmptyMessageSend();
                    return true;
                }
                case 91: {
                    this.read();
                    this.parseOpenCloseMessageSend(']', "[]");
                    return true;
                }
                case 123: {
                    this.read();
                    this.parseOpenCloseMessageSend('}', "{}");
                    return true;
                }
                case 35: {
                    this.read();
                    switch (this.peek()) {
                        case 123: {
                            this.parseSimpleOpenCloseMessageSend('}', "set");
                            return true;
                        }
                        case 47: {
                            this.parseRegexpLiteral(47);
                            return true;
                        }
                        case 91: {
                            this.parseText(91);
                            return true;
                        }
                        case 114: {
                            this.parseRegexpLiteral(114);
                            return true;
                        }
                        case 33: {
                            this.parseComment();
                            continue block24;
                        }
                    }
                    this.parseOperatorChars(35);
                    return true;
                }
                case 34: {
                    this.read();
                    this.parseText(34);
                    return true;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.read();
                    this.parseNumber(rr);
                    return true;
                }
                case 46: {
                    this.read();
                    rr = this.peek();
                    if (rr == 46) {
                        this.parseRange();
                    } else {
                        this.parseTerminator(46);
                    }
                    return true;
                }
                case 59: {
                    this.read();
                    this.parseComment();
                    continue block24;
                }
                case 9: 
                case 11: 
                case 12: 
                case 32: {
                    this.read();
                    this.readWhiteSpace();
                    continue block24;
                }
                case 92: {
                    this.read();
                    rr = this.peek();
                    if (rr == 10) {
                        this.read();
                        continue block24;
                    }
                    this.fail("Expected newline after free-floating escape character");
                }
                case 10: 
                case 13: {
                    this.read();
                    this.parseTerminator(rr);
                    return true;
                }
                case 33: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 42: 
                case 43: 
                case 45: 
                case 47: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 94: 
                case 96: 
                case 124: 
                case 126: {
                    this.read();
                    this.parseOperatorChars(rr);
                    return true;
                }
                case 58: {
                    this.read();
                    rr = this.peek();
                    if (this.isLetter(rr) || this.isIDDigit(rr)) {
                        this.parseRegularMessageSend(58);
                    } else {
                        this.parseOperatorChars(58);
                    }
                    return true;
                }
            }
            break;
        }
        this.read();
        this.parseRegularMessageSend(rr);
        return true;
    }

    private void fail(int l, int c, String message, String expected, String got) throws ControlFlow {
        String file = ((IokeSystem)IokeObject.data(this.runtime.system)).currentFile();
        IokeObject condition = IokeObject.as(IokeObject.getCellChain(this.runtime.condition, this.message, this.context, "Error", "Parser", "Syntax"), this.context).mimic(this.message, this.context);
        condition.setCell("message", this.message);
        condition.setCell("context", this.context);
        condition.setCell("receiver", this.context);
        if (expected != null) {
            condition.setCell("expected", this.runtime.newText(expected));
        }
        if (got != null) {
            condition.setCell("got", this.runtime.newText(got));
        }
        condition.setCell("file", this.runtime.newText(file));
        condition.setCell("line", this.runtime.newNumber(l));
        condition.setCell("character", this.runtime.newNumber(c));
        condition.setCell("text", this.runtime.newText(file + ":" + l + ":" + c + ": " + message));
        this.runtime.errorCondition(condition);
    }

    private void fail(String message) throws ControlFlow {
        this.fail(this.lineNumber, this.currentCharacter, message, null, null);
    }

    private void parseCharacter(int c) throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter;
        this.readWhiteSpace();
        int rr = this.read();
        if (rr != c) {
            this.fail(l, cc, "Expected: '" + (char)c + "' got: " + IokeParser.charDesc(rr), "" + (char)c, IokeParser.charDesc(rr));
        }
    }

    private boolean isUnary(String name) {
        return this.unaryOperators.contains(name) && (this.top.head == null || Message.isTerminator(this.top.last));
    }

    private static int possibleOperatorPrecedence(String name) {
        if (name.length() > 0) {
            char first = name.charAt(0);
            switch (first) {
                case '|': {
                    return 9;
                }
                case '^': {
                    return 8;
                }
                case '&': {
                    return 7;
                }
                case '<': 
                case '>': {
                    return 5;
                }
                case '!': 
                case '$': 
                case '=': 
                case '?': 
                case '~': {
                    return 6;
                }
                case '+': 
                case '-': {
                    return 3;
                }
                case '%': 
                case '*': 
                case '/': {
                    return 2;
                }
            }
        }
        return -1;
    }

    private void possibleOperator(IokeObject mx) throws ControlFlow {
        String name = Message.name(mx);
        if (this.isUnary(name) || this.onlyUnaryOperators.contains(name)) {
            this.top.add(mx);
            this.top.push(-1, mx, Level.Type.UNARY);
            return;
        }
        Operators.OpEntry op = this.operatorTable.get(name);
        if (op != null) {
            this.top.popOperatorsTo(op.precedence);
            this.top.add(mx);
            this.top.push(op.precedence, mx, Level.Type.REGULAR);
        } else {
            Operators.OpArity opa = this.trinaryOperatorTable.get(name);
            if (opa != null) {
                if (opa.arity == 2) {
                    IokeObject last = this.top.prepareAssignmentMessage();
                    mx.getArguments().add(last);
                    this.top.add(mx);
                    this.top.push(13, mx, Level.Type.ASSIGNMENT);
                } else {
                    IokeObject last = this.top.prepareAssignmentMessage();
                    mx.getArguments().add(last);
                    this.top.add(mx);
                }
            } else {
                op = this.invertedOperatorTable.get(name);
                if (op != null) {
                    this.top.popOperatorsTo(op.precedence);
                    this.top.add(mx);
                    this.top.push(op.precedence, mx, Level.Type.INVERTED);
                } else {
                    int possible = IokeParser.possibleOperatorPrecedence(name);
                    if (possible != -1) {
                        this.top.popOperatorsTo(possible);
                        this.top.add(mx);
                        this.top.push(possible, mx, Level.Type.REGULAR);
                    } else {
                        this.top.add(mx);
                    }
                }
            }
        }
    }

    private void parseEmptyMessageSend() throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        List<Object> args = this.parseCommaSeparatedMessageChains();
        this.parseCharacter(41);
        Message m = new Message(this.runtime, "");
        m.setLine(l);
        m.setPosition(cc);
        IokeObject mx = this.runtime.createMessage(m);
        Message.setArguments(mx, args);
        this.top.add(mx);
    }

    private void parseOpenCloseMessageSend(char end, String name) throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        int rr = this.peek();
        int r2 = this.peek2();
        Message m = new Message(this.runtime, name);
        m.setLine(l);
        m.setPosition(cc);
        IokeObject mx = this.runtime.createMessage(m);
        if (rr == end && r2 == 40) {
            this.read();
            this.read();
            List<Object> args = this.parseCommaSeparatedMessageChains();
            this.parseCharacter(41);
            Message.setArguments(mx, args);
        } else {
            List<Object> args = this.parseCommaSeparatedMessageChains();
            this.parseCharacter(end);
            Message.setArguments(mx, args);
        }
        this.top.add(mx);
    }

    private void parseSimpleOpenCloseMessageSend(char end, String name) throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        this.read();
        List<Object> args = this.parseCommaSeparatedMessageChains();
        this.parseCharacter(end);
        Message m = new Message(this.runtime, name);
        m.setLine(l);
        m.setPosition(cc);
        IokeObject mx = this.runtime.createMessage(m);
        Message.setArguments(mx, args);
        this.top.add(mx);
    }

    private void parseComment() throws IOException {
        int rr;
        while ((rr = this.peek()) != 10 && rr != 13 && rr != -1) {
            this.read();
        }
    }

    private void parseRange() throws IOException, ControlFlow {
        int rr;
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        int count = 2;
        this.read();
        while ((rr = this.peek()) == 46) {
            ++count;
            this.read();
        }
        String result = null;
        if (count < 13) {
            result = RANGES[count];
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                sb.append('.');
            }
            result = sb.toString();
        }
        Message m = new Message(this.runtime, result);
        m.setLine(l);
        m.setPosition(cc);
        IokeObject mx = this.runtime.createMessage(m);
        if (rr == 40) {
            this.read();
            List<Object> args = this.parseCommaSeparatedMessageChains();
            this.parseCharacter(41);
            Message.setArguments(mx, args);
            this.top.add(mx);
        } else {
            this.possibleOperator(mx);
        }
    }

    private void parseTerminator(int indicator) throws IOException, ControlFlow {
        int rr;
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        if (indicator == 13 && (rr = this.peek()) == 10) {
            this.read();
        }
        while (true) {
            rr = this.peek();
            int rr2 = this.peek2();
            if (rr == 46 && rr2 != 46 || rr == 10) {
                this.read();
                continue;
            }
            if (rr != 13 || rr2 != 10) break;
            this.read();
            this.read();
        }
        if (this.top.last != null || this.top.currentLevel.operatorMessage == null) {
            this.top.popOperatorsTo(999999);
        }
        Message m = new Message(this.runtime, ".", null, true);
        m.setLine(l);
        m.setPosition(cc);
        this.top.add(this.runtime.createMessage(m));
    }

    private void readWhiteSpace() throws IOException {
        int rr;
        while ((rr = this.peek()) == 32 || rr == 9 || rr == 11 || rr == 12) {
            this.read();
        }
    }

    private void parseRegexpLiteral(int indicator) throws IOException, ControlFlow {
        StringBuilder sb = new StringBuilder();
        boolean slash = indicator == 47;
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        this.read();
        if (!slash) {
            this.parseCharacter(91);
        }
        String name = "internal:createRegexp";
        ArrayList<Object> args = new ArrayList<Object>();
        block13: while (true) {
            int rr = this.peek();
            switch (rr) {
                case -1: {
                    this.fail("Expected end of regular expression, found EOF");
                    continue block13;
                }
                case 47: {
                    this.read();
                    if (slash) {
                        args.add(sb.toString());
                        Message m = new Message(this.runtime, "internal:createRegexp");
                        m.setLine(l);
                        m.setPosition(cc);
                        IokeObject mm = this.runtime.createMessage(m);
                        if (!name.equals("internal:createRegexp")) {
                            Message.setName(mm, name);
                        }
                        Message.setArguments(mm, args);
                        sb = new StringBuilder();
                        block14: while (true) {
                            rr = this.peek();
                            switch (rr) {
                                case 105: 
                                case 109: 
                                case 115: 
                                case 117: 
                                case 120: {
                                    this.read();
                                    sb.append((char)rr);
                                    continue block14;
                                }
                            }
                            break;
                        }
                        args.add(sb.toString());
                        this.top.add(mm);
                        return;
                    }
                    sb.append((char)rr);
                    continue block13;
                }
                case 93: {
                    this.read();
                    if (!slash) {
                        args.add(sb.toString());
                        Message m = new Message(this.runtime, "internal:createRegexp");
                        m.setLine(l);
                        m.setPosition(cc);
                        IokeObject mm = this.runtime.createMessage(m);
                        if (!name.equals("internal:createRegexp")) {
                            Message.setName(mm, name);
                        }
                        Message.setArguments(mm, args);
                        sb = new StringBuilder();
                        block15: while (true) {
                            rr = this.peek();
                            switch (rr) {
                                case 105: 
                                case 109: 
                                case 115: 
                                case 117: 
                                case 120: {
                                    this.read();
                                    sb.append((char)rr);
                                    continue block15;
                                }
                            }
                            break;
                        }
                        args.add(sb.toString());
                        this.top.add(mm);
                        return;
                    }
                    sb.append((char)rr);
                    continue block13;
                }
                case 35: {
                    this.read();
                    rr = this.peek();
                    if (rr == 123) {
                        this.read();
                        args.add(sb.toString());
                        sb = new StringBuilder();
                        name = "internal:compositeRegexp";
                        args.add(this.parseMessageChain());
                        this.readWhiteSpace();
                        this.parseCharacter(125);
                        continue block13;
                    }
                    sb.append('#');
                    continue block13;
                }
                case 92: {
                    this.read();
                    this.parseRegexpEscape(sb);
                    continue block13;
                }
            }
            this.read();
            sb.append((char)rr);
        }
    }

    private void parseText(int indicator) throws IOException, ControlFlow {
        StringBuilder sb = new StringBuilder();
        boolean dquote = indicator == 34;
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        if (!dquote) {
            this.read();
        }
        String name = "internal:createText";
        ArrayList<Object> args = new ArrayList<Object>();
        block7: while (true) {
            int rr = this.peek();
            switch (rr) {
                case -1: {
                    this.fail("Expected end of text, found EOF");
                    continue block7;
                }
                case 34: {
                    this.read();
                    if (dquote) {
                        args.add(sb.toString());
                        Message m = new Message(this.runtime, "internal:createText");
                        m.setLine(l);
                        m.setPosition(cc);
                        IokeObject mm = this.runtime.createMessage(m);
                        if (!name.equals("internal:createText")) {
                            for (int i = 0; i < args.size(); ++i) {
                                Object o = args.get(i);
                                if (!(o instanceof String)) continue;
                                Message mx = new Message(this.runtime, "internal:createText", o);
                                mx.setLine(l);
                                mx.setPosition(cc);
                                IokeObject mmx = this.runtime.createMessage(mx);
                                args.set(i, mmx);
                            }
                            Message.setName(mm, name);
                        }
                        Message.setArguments(mm, args);
                        this.top.add(mm);
                        return;
                    }
                    sb.append((char)rr);
                    continue block7;
                }
                case 93: {
                    this.read();
                    if (!dquote) {
                        args.add(sb.toString());
                        Message m = new Message(this.runtime, "internal:createText");
                        m.setLine(l);
                        m.setPosition(cc);
                        IokeObject mm = this.runtime.createMessage(m);
                        if (!name.equals("internal:createText")) {
                            for (int i = 0; i < args.size(); ++i) {
                                Object o = args.get(i);
                                if (!(o instanceof String)) continue;
                                Message mx = new Message(this.runtime, "internal:createText", o);
                                mx.setLine(l);
                                mx.setPosition(cc);
                                IokeObject mmx = this.runtime.createMessage(mx);
                                args.set(i, mmx);
                            }
                            Message.setName(mm, name);
                        }
                        Message.setArguments(mm, args);
                        this.top.add(mm);
                        return;
                    }
                    sb.append((char)rr);
                    continue block7;
                }
                case 35: {
                    this.read();
                    rr = this.peek();
                    if (rr == 123) {
                        this.read();
                        args.add(sb.toString());
                        sb = new StringBuilder();
                        name = "internal:concatenateText";
                        args.add(this.parseMessageChain());
                        this.readWhiteSpace();
                        this.parseCharacter(125);
                        continue block7;
                    }
                    sb.append('#');
                    continue block7;
                }
                case 92: {
                    this.read();
                    this.parseDoubleQuoteEscape(sb);
                    continue block7;
                }
            }
            this.read();
            sb.append((char)rr);
        }
    }

    private void parseRegexpEscape(StringBuilder sb) throws IOException, ControlFlow {
        sb.append('\\');
        int rr = this.peek();
        switch (rr) {
            case 117: {
                this.read();
                sb.append((char)rr);
                for (int i = 0; i < 4; ++i) {
                    rr = this.peek();
                    if (rr >= 48 && rr <= 57 || rr >= 97 && rr <= 102 || rr >= 65 && rr <= 70) {
                        this.read();
                        sb.append((char)rr);
                        continue;
                    }
                    this.fail("Expected four hexadecimal characters in unicode escape - got: " + IokeParser.charDesc(rr));
                }
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.read();
                sb.append((char)rr);
                if (rr <= 51) {
                    rr = this.peek();
                    if (rr < 48 || rr > 55) break;
                    this.read();
                    sb.append((char)rr);
                    rr = this.peek();
                    if (rr < 48 || rr > 55) break;
                    this.read();
                    sb.append((char)rr);
                    break;
                }
                rr = this.peek();
                if (rr < 48 || rr > 55) break;
                this.read();
                sb.append((char)rr);
                break;
            }
            case 10: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 71: 
            case 80: 
            case 83: 
            case 87: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 98: 
            case 100: 
            case 102: 
            case 110: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 119: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                this.read();
                sb.append((char)rr);
                break;
            }
            case 13: {
                this.read();
                sb.append((char)rr);
                rr = this.peek();
                if (rr != 10) break;
                this.read();
                sb.append((char)rr);
                break;
            }
            default: {
                this.fail("Undefined regular expression escape character: " + IokeParser.charDesc(rr));
            }
        }
    }

    private void parseDoubleQuoteEscape(StringBuilder sb) throws IOException, ControlFlow {
        sb.append('\\');
        int rr = this.peek();
        switch (rr) {
            case 117: {
                this.read();
                sb.append((char)rr);
                for (int i = 0; i < 4; ++i) {
                    rr = this.peek();
                    if (rr >= 48 && rr <= 57 || rr >= 97 && rr <= 102 || rr >= 65 && rr <= 70) {
                        this.read();
                        sb.append((char)rr);
                        continue;
                    }
                    this.fail("Expected four hexadecimal characters in unicode escape - got: " + IokeParser.charDesc(rr));
                }
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.read();
                sb.append((char)rr);
                if (rr <= 51) {
                    rr = this.peek();
                    if (rr < 48 || rr > 55) break;
                    this.read();
                    sb.append((char)rr);
                    rr = this.peek();
                    if (rr < 48 || rr > 55) break;
                    this.read();
                    sb.append((char)rr);
                    break;
                }
                rr = this.peek();
                if (rr < 48 || rr > 55) break;
                this.read();
                sb.append((char)rr);
                break;
            }
            case 10: 
            case 34: 
            case 35: 
            case 92: 
            case 93: 
            case 98: 
            case 101: 
            case 102: 
            case 110: 
            case 114: 
            case 116: {
                this.read();
                sb.append((char)rr);
                break;
            }
            case 13: {
                this.read();
                sb.append((char)rr);
                rr = this.peek();
                if (rr != 10) break;
                this.read();
                sb.append((char)rr);
                break;
            }
            default: {
                this.fail("Undefined text escape character: " + IokeParser.charDesc(rr));
            }
        }
    }

    private void parseOperatorChars(int indicator) throws IOException, ControlFlow {
        int rr;
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        StringBuilder sb = new StringBuilder();
        sb.append((char)indicator);
        block4: while (true) {
            rr = this.peek();
            switch (rr) {
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 42: 
                case 43: 
                case 45: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 94: 
                case 96: 
                case 124: 
                case 126: {
                    this.read();
                    sb.append((char)rr);
                    continue block4;
                }
                case 47: {
                    if (indicator == 35) break block4;
                    this.read();
                    sb.append((char)rr);
                    continue block4;
                }
            }
            break;
        }
        Message m = new Message(this.runtime, sb.toString());
        m.setLine(l);
        m.setPosition(cc);
        IokeObject mx = this.runtime.createMessage(m);
        if (rr == 40) {
            this.read();
            List<Object> args = this.parseCommaSeparatedMessageChains();
            this.parseCharacter(41);
            Message.setArguments(mx, args);
            this.top.add(mx);
        } else {
            this.possibleOperator(mx);
        }
    }

    private void parseNumber(int indicator) throws IOException, ControlFlow {
        int r2;
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        boolean decimal = false;
        StringBuilder sb = new StringBuilder();
        sb.append((char)indicator);
        int rr = -1;
        if (indicator == 48) {
            rr = this.peek();
            if (rr == 120 || rr == 88) {
                this.read();
                sb.append((char)rr);
                rr = this.peek();
                if (rr >= 48 && rr <= 57 || rr >= 97 && rr <= 102 || rr >= 65 && rr <= 70) {
                    this.read();
                    sb.append((char)rr);
                    rr = this.peek();
                    while (rr >= 48 && rr <= 57 || rr >= 97 && rr <= 102 || rr >= 65 && rr <= 70) {
                        this.read();
                        sb.append((char)rr);
                        rr = this.peek();
                    }
                } else {
                    this.fail("Expected at least one hexadecimal characters in hexadecimal number literal - got: " + IokeParser.charDesc(rr));
                }
            } else {
                r2 = this.peek2();
                if (rr == 46 && r2 >= 48 && r2 <= 57) {
                    decimal = true;
                    sb.append((char)rr);
                    sb.append((char)r2);
                    this.read();
                    this.read();
                    while ((rr = this.peek()) >= 48 && rr <= 57) {
                        this.read();
                        sb.append((char)rr);
                    }
                    if (rr == 101 || rr == 69) {
                        this.read();
                        sb.append((char)rr);
                        rr = this.peek();
                        if (rr == 45 || rr == 43) {
                            this.read();
                            sb.append((char)rr);
                            rr = this.peek();
                        }
                        if (rr >= 48 && rr <= 57) {
                            this.read();
                            sb.append((char)rr);
                            while ((rr = this.peek()) >= 48 && rr <= 57) {
                                this.read();
                                sb.append((char)rr);
                            }
                        } else {
                            this.fail("Expected at least one decimal character following exponent specifier in number literal - got: " + IokeParser.charDesc(rr));
                        }
                    }
                }
            }
        } else {
            while ((rr = this.peek()) >= 48 && rr <= 57) {
                this.read();
                sb.append((char)rr);
            }
            r2 = this.peek2();
            if (rr == 46 && r2 >= 48 && r2 <= 57) {
                decimal = true;
                sb.append((char)rr);
                sb.append((char)r2);
                this.read();
                this.read();
                while ((rr = this.peek()) >= 48 && rr <= 57) {
                    this.read();
                    sb.append((char)rr);
                }
                if (rr == 101 || rr == 69) {
                    this.read();
                    sb.append((char)rr);
                    rr = this.peek();
                    if (rr == 45 || rr == 43) {
                        this.read();
                        sb.append((char)rr);
                        rr = this.peek();
                    }
                    if (rr >= 48 && rr <= 57) {
                        this.read();
                        sb.append((char)rr);
                        while ((rr = this.peek()) >= 48 && rr <= 57) {
                            this.read();
                            sb.append((char)rr);
                        }
                    } else {
                        this.fail("Expected at least one decimal character following exponent specifier in number literal - got: " + IokeParser.charDesc(rr));
                    }
                }
            } else if (rr == 101 || rr == 69) {
                decimal = true;
                this.read();
                sb.append((char)rr);
                rr = this.peek();
                if (rr == 45 || rr == 43) {
                    this.read();
                    sb.append((char)rr);
                    rr = this.peek();
                }
                if (rr >= 48 && rr <= 57) {
                    this.read();
                    sb.append((char)rr);
                    while ((rr = this.peek()) >= 48 && rr <= 57) {
                        this.read();
                        sb.append((char)rr);
                    }
                } else {
                    this.fail("Expected at least one decimal character following exponent specifier in number literal - got: " + IokeParser.charDesc(rr));
                }
            }
        }
        Message m = decimal ? new Message(this.runtime, "internal:createDecimal", sb.toString()) : new Message(this.runtime, "internal:createNumber", sb.toString());
        m.setLine(l);
        m.setPosition(cc);
        this.top.add(this.runtime.createMessage(m));
    }

    private void parseRegularMessageSend(int indicator) throws IOException, ControlFlow {
        int l = this.lineNumber;
        int cc = this.currentCharacter - 1;
        StringBuilder sb = new StringBuilder();
        sb.append((char)indicator);
        int rr = -1;
        while (this.isLetter(rr = this.peek()) || this.isIDDigit(rr) || rr == 58 || rr == 33 || rr == 63 || rr == 36) {
            this.read();
            sb.append((char)rr);
        }
        Message m = new Message(this.runtime, sb.toString());
        m.setLine(l);
        m.setPosition(cc);
        IokeObject mx = this.runtime.createMessage(m);
        if (rr == 40) {
            this.read();
            List<Object> args = this.parseCommaSeparatedMessageChains();
            this.parseCharacter(41);
            Message.setArguments(mx, args);
            this.top.add(mx);
        } else {
            this.possibleOperator(mx);
        }
    }

    private boolean isLetter(int c) {
        return c >= 65 && c <= 90 || c == 95 || c >= 97 && c <= 122 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 8191 || c >= 8704 && c <= 8959 || c >= 10176 && c <= 10223 || c >= 10624 && c <= 11007 || c >= 12352 && c <= 12687 || c >= 13056 && c <= 13183 || c >= 13312 && c <= 15661 || c >= 19968 && c <= 40959 || c >= 63744 && c <= 64255;
    }

    private boolean isIDDigit(int c) {
        return c >= 48 && c <= 57 || c >= 1632 && c <= 1641 || c >= 1776 && c <= 1785 || c >= 2406 && c <= 2415 || c >= 2534 && c <= 2543 || c >= 2662 && c <= 2671 || c >= 2790 && c <= 2799 || c >= 2918 && c <= 2927 || c >= 3047 && c <= 3055 || c >= 3174 && c <= 3183 || c >= 3302 && c <= 3311 || c >= 3430 && c <= 3439 || c >= 3664 && c <= 3673 || c >= 3792 && c <= 3801 || c >= 4160 && c <= 4169;
    }

    private static String charDesc(int c) {
        if (c == -1) {
            return "EOF";
        }
        if (c == 9) {
            return "TAB";
        }
        if (c == 10 || c == 13) {
            return "EOL";
        }
        return "'" + (char)c + "'";
    }
}

