/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang.parser;

import ioke.lang.Dict;
import ioke.lang.IokeObject;
import ioke.lang.Number;
import ioke.lang.Runtime;
import ioke.lang.Symbol;
import ioke.lang.exceptions.ControlFlow;
import ioke.lang.parser.IokeParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operators {
    public static final Map<String, OpEntry> DEFAULT_OPERATORS;
    public static final Map<String, OpArity> DEFAULT_ASSIGNMENT_OPERATORS;
    public static final Map<String, OpEntry> DEFAULT_INVERTED_OPERATORS;
    public static final Set<String> DEFAULT_UNARY_OPERATORS;
    public static final Set<String> DEFAULT_ONLY_UNARY_OPERATORS;

    private static final void addOpEntry(String name, int precedence, Map<String, OpEntry> current) {
        current.put(name, new OpEntry(name, precedence));
    }

    private static final void addOpArity(String name, int arity, Map<String, OpArity> current) {
        current.put(name, new OpArity(name, arity));
    }

    private static final Map<Object, Object> getOpTable(IokeParser parser, IokeObject opTable, String name, OpTableCreator creator) throws ControlFlow {
        IokeObject operators = IokeObject.as(opTable.findCell(parser.message, parser.context, name), null);
        if (operators != parser.runtime.nul && IokeObject.data(operators) instanceof Dict) {
            return Dict.getMap(operators);
        }
        Map<Object, Object> result = creator.create(parser.runtime);
        opTable.setCell(name, parser.runtime.newDict(result));
        return result;
    }

    public static final void createOrGetOpTables(IokeParser parser) throws ControlFlow {
        Runtime runtime = parser.runtime;
        IokeObject opTable = IokeObject.as(runtime.message.findCell(parser.message, parser.context, "OperatorTable"), null);
        if (opTable == runtime.nul) {
            opTable = runtime.newFromOrigin();
            opTable.setKind("Message OperatorTable");
            runtime.message.setCell("OperatorTable", opTable);
        }
        Map<Object, Object> tmpOperatorTable = Operators.getOpTable(parser, opTable, "operators", new OpTableCreator(){

            @Override
            public Map<Object, Object> create(Runtime runtime) {
                HashMap<Object, Object> table = new HashMap<Object, Object>();
                for (OpEntry ot : DEFAULT_OPERATORS.values()) {
                    table.put(runtime.getSymbol(ot.name), runtime.newNumber(ot.precedence));
                }
                return table;
            }
        });
        Map<Object, Object> tmpTrinaryOperatorTable = Operators.getOpTable(parser, opTable, "trinaryOperators", new OpTableCreator(){

            @Override
            public Map<Object, Object> create(Runtime runtime) {
                HashMap<Object, Object> table = new HashMap<Object, Object>();
                for (OpArity ot : DEFAULT_ASSIGNMENT_OPERATORS.values()) {
                    table.put(runtime.getSymbol(ot.name), runtime.newNumber(ot.arity));
                }
                return table;
            }
        });
        Map<Object, Object> tmpInvertedOperatorTable = Operators.getOpTable(parser, opTable, "invertedOperators", new OpTableCreator(){

            @Override
            public Map<Object, Object> create(Runtime runtime) {
                HashMap<Object, Object> table = new HashMap<Object, Object>();
                for (OpEntry ot : DEFAULT_INVERTED_OPERATORS.values()) {
                    table.put(runtime.getSymbol(ot.name), runtime.newNumber(ot.precedence));
                }
                return table;
            }
        });
        for (Map.Entry<Object, Object> entry : tmpOperatorTable.entrySet()) {
            Operators.addOpEntry(Symbol.getText(entry.getKey()), Number.intValue(entry.getValue()).intValue(), parser.operatorTable);
        }
        for (Map.Entry<Object, Object> entry : tmpTrinaryOperatorTable.entrySet()) {
            Operators.addOpArity(Symbol.getText(entry.getKey()), Number.intValue(entry.getValue()).intValue(), parser.trinaryOperatorTable);
        }
        for (Map.Entry<Object, Object> entry : tmpInvertedOperatorTable.entrySet()) {
            Operators.addOpEntry(Symbol.getText(entry.getKey()), Number.intValue(entry.getValue()).intValue(), parser.invertedOperatorTable);
        }
    }

    static {
        DEFAULT_UNARY_OPERATORS = new HashSet<String>(Arrays.asList("-", "~", "$"));
        DEFAULT_ONLY_UNARY_OPERATORS = new HashSet<String>(Arrays.asList("'", "''", "`", ":"));
        HashMap<String, OpEntry> operators = new HashMap<String, OpEntry>();
        Operators.addOpEntry("!", 0, operators);
        Operators.addOpEntry("?", 0, operators);
        Operators.addOpEntry("$", 0, operators);
        Operators.addOpEntry("~", 0, operators);
        Operators.addOpEntry("#", 0, operators);
        Operators.addOpEntry("**", 1, operators);
        Operators.addOpEntry("*", 2, operators);
        Operators.addOpEntry("/", 2, operators);
        Operators.addOpEntry("%", 2, operators);
        Operators.addOpEntry("+", 3, operators);
        Operators.addOpEntry("-", 3, operators);
        Operators.addOpEntry("\u2229", 3, operators);
        Operators.addOpEntry("\u222a", 3, operators);
        Operators.addOpEntry("<<", 4, operators);
        Operators.addOpEntry(">>", 4, operators);
        Operators.addOpEntry("<=>", 5, operators);
        Operators.addOpEntry(">", 5, operators);
        Operators.addOpEntry("<", 5, operators);
        Operators.addOpEntry("<=", 5, operators);
        Operators.addOpEntry("\u2264", 5, operators);
        Operators.addOpEntry(">=", 5, operators);
        Operators.addOpEntry("\u2265", 5, operators);
        Operators.addOpEntry("<>", 5, operators);
        Operators.addOpEntry("<>>", 5, operators);
        Operators.addOpEntry("\u2282", 5, operators);
        Operators.addOpEntry("\u2283", 5, operators);
        Operators.addOpEntry("\u2286", 5, operators);
        Operators.addOpEntry("\u2287", 5, operators);
        Operators.addOpEntry("==", 6, operators);
        Operators.addOpEntry("!=", 6, operators);
        Operators.addOpEntry("\u2260", 6, operators);
        Operators.addOpEntry("===", 6, operators);
        Operators.addOpEntry("=~", 6, operators);
        Operators.addOpEntry("!~", 6, operators);
        Operators.addOpEntry("&", 7, operators);
        Operators.addOpEntry("^", 8, operators);
        Operators.addOpEntry("|", 9, operators);
        Operators.addOpEntry("&&", 10, operators);
        Operators.addOpEntry("?&", 10, operators);
        Operators.addOpEntry("||", 11, operators);
        Operators.addOpEntry("?|", 11, operators);
        Operators.addOpEntry("..", 12, operators);
        Operators.addOpEntry("...", 12, operators);
        Operators.addOpEntry("=>", 12, operators);
        Operators.addOpEntry("<->", 12, operators);
        Operators.addOpEntry("->", 12, operators);
        Operators.addOpEntry("\u2218", 12, operators);
        Operators.addOpEntry("+>", 12, operators);
        Operators.addOpEntry("!>", 12, operators);
        Operators.addOpEntry("&>", 12, operators);
        Operators.addOpEntry("%>", 12, operators);
        Operators.addOpEntry("#>", 12, operators);
        Operators.addOpEntry("@>", 12, operators);
        Operators.addOpEntry("/>", 12, operators);
        Operators.addOpEntry("*>", 12, operators);
        Operators.addOpEntry("?>", 12, operators);
        Operators.addOpEntry("|>", 12, operators);
        Operators.addOpEntry("^>", 12, operators);
        Operators.addOpEntry("~>", 12, operators);
        Operators.addOpEntry("->>", 12, operators);
        Operators.addOpEntry("+>>", 12, operators);
        Operators.addOpEntry("!>>", 12, operators);
        Operators.addOpEntry("&>>", 12, operators);
        Operators.addOpEntry("%>>", 12, operators);
        Operators.addOpEntry("#>>", 12, operators);
        Operators.addOpEntry("@>>", 12, operators);
        Operators.addOpEntry("/>>", 12, operators);
        Operators.addOpEntry("*>>", 12, operators);
        Operators.addOpEntry("?>>", 12, operators);
        Operators.addOpEntry("|>>", 12, operators);
        Operators.addOpEntry("^>>", 12, operators);
        Operators.addOpEntry("~>>", 12, operators);
        Operators.addOpEntry("=>>", 12, operators);
        Operators.addOpEntry("**>", 12, operators);
        Operators.addOpEntry("**>>", 12, operators);
        Operators.addOpEntry("&&>", 12, operators);
        Operators.addOpEntry("&&>>", 12, operators);
        Operators.addOpEntry("||>", 12, operators);
        Operators.addOpEntry("||>>", 12, operators);
        Operators.addOpEntry("$>", 12, operators);
        Operators.addOpEntry("$>>", 12, operators);
        Operators.addOpEntry("and", 13, operators);
        Operators.addOpEntry("nand", 13, operators);
        Operators.addOpEntry("or", 13, operators);
        Operators.addOpEntry("xor", 13, operators);
        Operators.addOpEntry("nor", 13, operators);
        Operators.addOpEntry("<-", 14, operators);
        Operators.addOpEntry("return", 14, operators);
        Operators.addOpEntry("import", 14, operators);
        DEFAULT_OPERATORS = operators;
        HashMap<String, OpArity> aoperators = new HashMap<String, OpArity>();
        Operators.addOpArity("=", 2, aoperators);
        Operators.addOpArity("+=", 2, aoperators);
        Operators.addOpArity("-=", 2, aoperators);
        Operators.addOpArity("/=", 2, aoperators);
        Operators.addOpArity("*=", 2, aoperators);
        Operators.addOpArity("**=", 2, aoperators);
        Operators.addOpArity("%=", 2, aoperators);
        Operators.addOpArity("&=", 2, aoperators);
        Operators.addOpArity("&&=", 2, aoperators);
        Operators.addOpArity("|=", 2, aoperators);
        Operators.addOpArity("||=", 2, aoperators);
        Operators.addOpArity("^=", 2, aoperators);
        Operators.addOpArity("<<=", 2, aoperators);
        Operators.addOpArity(">>=", 2, aoperators);
        Operators.addOpArity("++", 1, aoperators);
        Operators.addOpArity("--", 1, aoperators);
        DEFAULT_ASSIGNMENT_OPERATORS = aoperators;
        HashMap<String, OpEntry> ioperators = new HashMap<String, OpEntry>();
        Operators.addOpEntry("\u2208", 12, ioperators);
        Operators.addOpEntry("\u2209", 12, ioperators);
        Operators.addOpEntry("::", 12, ioperators);
        Operators.addOpEntry(":::", 12, ioperators);
        DEFAULT_INVERTED_OPERATORS = ioperators;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OpTableCreator {
        public Map<Object, Object> create(Runtime var1);
    }

    public static class OpArity {
        public final String name;
        public final int arity;

        public OpArity(String name, int arity) {
            this.name = name;
            this.arity = arity;
        }
    }

    public static class OpEntry {
        public final String name;
        public final int precedence;

        public OpEntry(String name, int precedence) {
            this.name = name;
            this.precedence = precedence;
        }
    }
}

