/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dir {
    public static final boolean DOSISH;
    public static final boolean CASEFOLD_FILESYSTEM;
    public static final int FNM_NOESCAPE = 1;
    public static final int FNM_PATHNAME = 2;
    public static final int FNM_DOTMATCH = 4;
    public static final int FNM_CASEFOLD = 8;
    public static final int FNM_SYSCASE;
    public static final int FNM_NOMATCH = 1;
    public static final int FNM_ERROR = 2;
    public static final String EMPTY = "";
    public static final String SLASH = "/";
    public static final String STAR = "*";
    public static final String DOUBLE_STAR = "**";
    public static final GlobFunc push_pattern;
    public static final GlobFunc glob_caller;

    private static boolean isdirsep(char c) {
        return DOSISH ? c == '\\' || c == '/' : c == '/';
    }

    private static int rb_path_next(String _s, int s, int send) {
        while (s < send && !Dir.isdirsep(_s.charAt(s))) {
            ++s;
        }
        return s;
    }

    private static int fnmatch_helper(String bytes, int pstart, int pend, String string, int sstart, int send, int flags) {
        boolean nocase;
        int s = sstart;
        int pat = pstart;
        boolean escape = (flags & 1) == 0;
        boolean pathname = (flags & 2) != 0;
        boolean period = (flags & 4) == 0;
        boolean bl = nocase = (flags & 8) != 0;
        block6: while (pat < pend) {
            char c = bytes.charAt(pat++);
            switch (c) {
                case '?': {
                    if (s >= send || pathname && Dir.isdirsep(string.charAt(s)) || period && string.charAt(s) == '.' && (s == 0 || pathname && Dir.isdirsep(string.charAt(s - 1)))) {
                        return 1;
                    }
                    ++s;
                    continue block6;
                }
                case '*': {
                    while (pat < pend && (c = bytes.charAt(pat++)) == '*') {
                    }
                    if (s < send && period && string.charAt(s) == '.' && (s == 0 || pathname && Dir.isdirsep(string.charAt(s - 1)))) {
                        return 1;
                    }
                    if (pat > pend || pat == pend && c == '*') {
                        if (pathname && Dir.rb_path_next(string, s, send) < send) {
                            return 1;
                        }
                        return 0;
                    }
                    if (pathname && Dir.isdirsep(c)) {
                        if ((s = Dir.rb_path_next(string, s, send)) < send) {
                            ++s;
                            continue block6;
                        }
                        return 1;
                    }
                    char test = escape && c == '\\' && pat < pend ? bytes.charAt(pat) : c;
                    test = Character.toLowerCase(test);
                    --pat;
                    while (s < send) {
                        if ((c == '?' || c == '[' || Character.toLowerCase(string.charAt(s)) == test) && Dir.fnmatch(bytes, pat, pend, string, s, send, flags | 4) == 0) {
                            return 0;
                        }
                        if (pathname && Dir.isdirsep(string.charAt(s))) break;
                        ++s;
                    }
                    return 1;
                }
                case '[': {
                    if (s >= send || pathname && Dir.isdirsep(string.charAt(s)) || period && string.charAt(s) == '.' && (s == 0 || pathname && Dir.isdirsep(string.charAt(s - 1)))) {
                        return 1;
                    }
                    if ((pat = Dir.range(bytes, pat, pend, string.charAt(s), flags)) == -1) {
                        return 1;
                    }
                    ++s;
                    continue block6;
                }
                case '\\': {
                    if (!escape || DOSISH && (pat >= pend || "*?[]\\".indexOf(bytes.charAt(pat)) == -1)) break;
                    c = pat >= pend ? (char)'\\' : (char)bytes.charAt(pat++);
                }
            }
            if (s >= send) {
                return 1;
            }
            if (!(DOSISH && pathname && Dir.isdirsep(c) && Dir.isdirsep(string.charAt(s)) || !(nocase ? Character.toLowerCase(c) != Character.toLowerCase(string.charAt(s)) : c != string.charAt(s)))) {
                return 1;
            }
            ++s;
        }
        return s >= send ? 0 : 1;
    }

    public static int fnmatch(String bytes, int pstart, int pend, String string, int sstart, int send, int flags) {
        boolean period = (flags & 4) == 0;
        boolean pathname = (flags & 2) != 0;
        int pat_pos = pstart;
        int str_pos = sstart;
        int ptmp = -1;
        int stmp = -1;
        if (pathname) {
            while (true) {
                int strSlashIdx;
                int patSlashIdx;
                if (Dir.isDoubleStarAndSlash(bytes, pat_pos)) {
                    while (Dir.isDoubleStarAndSlash(bytes, pat_pos += 3)) {
                    }
                    ptmp = pat_pos;
                    stmp = str_pos;
                }
                if (Dir.fnmatch_helper(bytes, pat_pos, patSlashIdx = Dir.nextSlashIndex(bytes, pat_pos, pend), string, str_pos, strSlashIdx = Dir.nextSlashIndex(string, str_pos, send), flags) == 0) {
                    if (patSlashIdx < pend && strSlashIdx < send) {
                        pat_pos = ++patSlashIdx;
                        str_pos = ++strSlashIdx;
                        continue;
                    }
                    if (patSlashIdx == pend && strSlashIdx == send) {
                        return 0;
                    }
                }
                if (ptmp == -1 || stmp == -1 || period && string.charAt(stmp) == '.' || (stmp = Dir.nextSlashIndex(string, stmp, send)) >= send) break;
                pat_pos = ptmp;
                str_pos = ++stmp;
            }
            return 1;
        }
        return Dir.fnmatch_helper(bytes, pstart, pend, string, sstart, send, flags);
    }

    private static boolean isDoubleStarAndSlash(String bytes, int pos) {
        if (bytes.length() - pos <= 2) {
            return false;
        }
        return bytes.charAt(pos) == '*' && bytes.charAt(pos + 1) == '*' && bytes.charAt(pos + 2) == '/';
    }

    private static int nextSlashIndex(String bytes, int start, int end) {
        int idx;
        for (idx = start; idx < end && idx < bytes.length() && bytes.charAt(idx) != '/'; ++idx) {
        }
        return idx;
    }

    public static int range(String _pat, int pat, int pend, char test, int flags) {
        boolean not;
        boolean ok = false;
        boolean nocase = (flags & 8) != 0;
        boolean escape = (flags & 1) == 0;
        boolean bl = not = _pat.charAt(pat) == '!' || _pat.charAt(pat) == '^';
        if (not) {
            ++pat;
        }
        if (nocase) {
            test = Character.toLowerCase(test);
        }
        while (_pat.charAt(pat) != ']') {
            char cend;
            if (escape && _pat.charAt(pat) == '\\') {
                ++pat;
            }
            if (pat >= pend) {
                return -1;
            }
            char cstart = cend = _pat.charAt(pat++);
            if (_pat.charAt(pat) == '-' && _pat.charAt(pat + 1) != ']') {
                if (escape && _pat.charAt(++pat) == '\\') {
                    ++pat;
                }
                if (pat >= pend) {
                    return -1;
                }
                cend = _pat.charAt(pat++);
            }
            if (nocase) {
                if (Character.toLowerCase(cstart) > test || test > Character.toLowerCase(cend)) continue;
                ok = true;
                continue;
            }
            if (cstart > test || test > cend) continue;
            ok = true;
        }
        return ok == not ? -1 : pat + 1;
    }

    public static List<String> push_glob(String cwd, String globString, int flags) {
        ArrayList<String> result = new ArrayList<String>();
        if (globString.length() > 0) {
            Dir.push_braces(cwd, result, new GlobPattern(globString, flags));
        }
        return result;
    }

    private static int push_braces(String cwd, List<String> result, GlobPattern pattern) {
        pattern.reset();
        int lbrace = pattern.indexOf('{');
        int rbrace = pattern.findClosingIndexOf(lbrace);
        if (lbrace == -1 || rbrace == -1) {
            return Dir.push_globs(cwd, result, pattern);
        }
        String buf = EMPTY;
        int i = lbrace;
        while (pattern.string.charAt(i) != '}') {
            int middleRegionIndex;
            for (i = middleRegionIndex = i + 1; i < pattern.end && pattern.string.charAt(i) != '}' && pattern.string.charAt(i) != ','; ++i) {
                if (pattern.string.charAt(i) != '{') continue;
                pattern.findClosingIndexOf(i);
            }
            buf = EMPTY;
            buf = buf + pattern.string.substring(pattern.begin, lbrace);
            buf = buf + pattern.string.substring(middleRegionIndex, i);
            int status = Dir.push_braces(cwd, result, new GlobPattern(buf = buf + pattern.string.substring(rbrace + 1, pattern.end), 0, buf.length(), pattern.flags));
            if (status == 0) continue;
            return status;
        }
        return 0;
    }

    private static int push_globs(String cwd, List<String> ary, GlobPattern pattern) {
        pattern.flags |= FNM_SYSCASE;
        return Dir.glob_helper(cwd, pattern.string, pattern.begin, pattern.end, -1, pattern.flags, glob_caller, new GlobArgs(push_pattern, ary));
    }

    private static boolean has_magic(String bytes, int begin, int end, int flags) {
        boolean escape = (flags & 1) == 0;
        boolean nocase = (flags & 8) != 0;
        int open = 0;
        block6: for (int i = begin; i < end; ++i) {
            switch (bytes.charAt(i)) {
                case '*': 
                case '?': {
                    return true;
                }
                case '[': {
                    ++open;
                    continue block6;
                }
                case ']': {
                    if (open <= 0) continue block6;
                    return true;
                }
                case '\\': {
                    if (!escape || i != end) continue block6;
                    return false;
                }
                default: {
                    if (FNM_SYSCASE != 0 || !nocase || !Character.isLetter(bytes.charAt(i))) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    private static int remove_backslashes(StringBuilder bytes, int index, int len) {
        int t = index;
        while (index < len && (bytes.charAt(index) != '\\' || ++index != len)) {
            bytes.replace(t, t + 1, bytes.substring(index, index + 1));
            ++index;
            ++t;
        }
        return t;
    }

    private static int strchr(String bytes, int begin, int end, char ch) {
        for (int i = begin; i < end; ++i) {
            if (bytes.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    private static String extract_path(String bytes, int begin, int end) {
        int len = end - begin;
        if (!(len <= 1 || bytes.charAt(end - 1) != '/' || DOSISH && len >= 2 && bytes.charAt(end - 2) == ':')) {
            --len;
        }
        return bytes.substring(begin, begin + len);
    }

    private static String extract_elem(String bytes, int begin, int end) {
        int elementEnd = Dir.strchr(bytes, begin, end, '/');
        if (elementEnd == -1) {
            elementEnd = end;
        }
        return Dir.extract_path(bytes, begin, elementEnd);
    }

    private static boolean BASE(String base) {
        return DOSISH ? !(base.length() <= 0 || Dir.isdirsep(base.charAt(0)) && base.length() < 2 || base.length() > 2 && base.charAt(1) == ':' && Dir.isdirsep(base.charAt(2)) && base.length() < 4) : base.length() > 0 && (!Dir.isdirsep(base.charAt(0)) || base.length() >= 2);
    }

    private static boolean isJarFilePath(String bytes, int begin, int end) {
        return end > 6 && bytes.substring(begin, begin + 5).equals("file:");
    }

    private static String[] files(File directory) {
        String[] files = directory.list();
        if (files != null) {
            String[] filesPlusDotFiles = new String[files.length + 2];
            System.arraycopy(files, 0, filesPlusDotFiles, 2, files.length);
            filesPlusDotFiles[0] = ".";
            filesPlusDotFiles[1] = "..";
            return filesPlusDotFiles;
        }
        return new String[0];
    }

    private static int glob_helper(String cwd, String _bytes, int begin, int end, int sub, int flags, GlobFunc func, GlobArgs arg) {
        int p;
        CharSequence bytes = _bytes;
        int status = 0;
        StringBuilder newpath = null;
        int n = p = sub != -1 ? sub : begin;
        if (!Dir.has_magic(_bytes, p, end, flags)) {
            if (DOSISH || (flags & 1) == 0) {
                newpath = new StringBuilder();
                newpath.append(bytes, 0, end);
                if (sub != -1) {
                    p = sub - begin;
                    end = Dir.remove_backslashes(newpath, p, end);
                    sub = p;
                } else {
                    end = Dir.remove_backslashes(newpath, 0, end);
                    bytes = newpath;
                }
            }
            if (bytes.charAt(begin) == '/' || DOSISH && begin + 2 < end && bytes.charAt(begin + 1) == ':' && Dir.isdirsep(bytes.charAt(begin + 2))) {
                if (new File(((Object)bytes.subSequence(begin, end)).toString()).exists()) {
                    status = func.call(bytes.toString(), begin, end, arg);
                }
            } else if (Dir.isJarFilePath(bytes.toString(), begin, end)) {
                int ix = end;
                for (int i = 0; i < end; ++i) {
                    if (bytes.charAt(begin + i) != '!') continue;
                    ix = i;
                    break;
                }
                File st = new File(((Object)bytes.subSequence(begin + 5, ix)).toString());
                String jar = ((Object)bytes.subSequence(begin + ix + 1, end)).toString();
                try {
                    JarFile jf = new JarFile(st);
                    if (jar.startsWith(SLASH)) {
                        jar = jar.substring(1);
                    }
                    if (jf.getEntry(jar + SLASH) != null) {
                        jar = jar + SLASH;
                    }
                    if (jf.getEntry(jar) != null) {
                        status = func.call(bytes.toString(), begin, end, arg);
                    }
                }
                catch (Exception e) {}
            } else if (end - begin > 0 && new File(cwd, ((Object)bytes.subSequence(begin, end)).toString()).exists()) {
                status = func.call(bytes.toString(), begin, end - begin, arg);
            }
            return status;
        }
        String bytes2 = bytes.toString();
        String buf = EMPTY;
        ArrayList<String> link = new ArrayList<String>();
        while (p != -1 && status == 0) {
            int m;
            block46: {
                File st;
                block45: {
                    JarFile jf;
                    String jar;
                    boolean recursive;
                    String magic;
                    String base;
                    block47: {
                        if (bytes2.charAt(p) == '/') {
                            ++p;
                        }
                        if (!Dir.has_magic(bytes2, p, (m = Dir.strchr(bytes2, p, end, '/')) == -1 ? end : m, flags)) break block46;
                        base = Dir.extract_path(bytes2, begin, p);
                        String dir = begin == p ? "." : base;
                        magic = Dir.extract_elem(bytes2, p, end);
                        recursive = false;
                        jar = null;
                        jf = null;
                        if (dir.charAt(0) == '/' || DOSISH && 2 < dir.length() && dir.charAt(1) == ':' && Dir.isdirsep(dir.charAt(2))) {
                            st = new File(dir);
                        } else if (Dir.isJarFilePath(dir, 0, dir.length())) {
                            int ix = dir.length();
                            for (int i = 0; i < dir.length(); ++i) {
                                if (dir.charAt(i) != '!') continue;
                                ix = i;
                                break;
                            }
                            st = new File(dir.substring(5, ix));
                            jar = dir.substring(ix + 1, dir.length());
                            try {
                                jf = new JarFile(st);
                                if (jar.startsWith(SLASH)) {
                                    jar = jar.substring(1);
                                }
                                if (jf.getEntry(jar + SLASH) != null) {
                                    jar = jar + SLASH;
                                }
                            }
                            catch (Exception e) {
                                jar = null;
                                jf = null;
                            }
                        } else {
                            st = new File(cwd, dir);
                        }
                        if ((jf == null || !EMPTY.equals(jar) && (jf.getJarEntry(jar) == null || !jf.getJarEntry(jar).isDirectory())) && !st.isDirectory()) break;
                        if (m == -1 || !magic.equals(DOUBLE_STAR)) break block47;
                        int n2 = base.length();
                        recursive = true;
                        buf = base + bytes2.substring(base.length() > 0 ? m : m + 1, end);
                        status = Dir.glob_helper(cwd, buf, 0, buf.length(), n2, flags, func, arg);
                        if (status != 0) break block45;
                    }
                    if (jar == null) {
                        String[] dirp = Dir.files(st);
                        for (int i = 0; i < dirp.length; ++i) {
                            String bs;
                            if (recursive) {
                                bs = dirp[i];
                                if (Dir.fnmatch(STAR, 0, 1, bs, 0, bs.length(), flags) != 0) continue;
                                buf = base + (Dir.BASE(base) ? SLASH : EMPTY);
                                st = (buf = buf + dirp[i]).charAt(0) == '/' || DOSISH && 2 < buf.length() && buf.charAt(1) == ':' && Dir.isdirsep(buf.charAt(2)) ? new File(buf) : new File(cwd, buf);
                                if (!st.isDirectory() || ".".equals(dirp[i]) || "..".equals(dirp[i])) continue;
                                int t = buf.length();
                                buf = buf + "/**";
                                status = Dir.glob_helper(cwd, buf = buf + bytes2.substring(m, end), 0, buf.length(), t, flags, func, arg);
                                if (status == 0) continue;
                                break;
                            }
                            bs = dirp[i];
                            if (Dir.fnmatch(magic, 0, magic.length(), bs, 0, bs.length(), flags) != 0) continue;
                            buf = base + (Dir.BASE(base) ? SLASH : EMPTY) + dirp[i];
                            if (m == -1) {
                                status = func.call(buf, 0, buf.length(), arg);
                                if (status == 0) continue;
                                break;
                            }
                            link.add(buf);
                            buf = EMPTY;
                        }
                    } else {
                        try {
                            ArrayList<JarEntry> dirp = new ArrayList<JarEntry>();
                            Enumeration<JarEntry> eje = jf.entries();
                            while (eje.hasMoreElements()) {
                                JarEntry je = eje.nextElement();
                                String name = je.getName();
                                int ix = name.indexOf(47, jar.length());
                                if (ix != -1 && ix != name.length() - 1 || !SLASH.equals(jar) && (!name.startsWith(jar) || name.length() <= jar.length())) continue;
                                dirp.add(je);
                            }
                            for (JarEntry je : dirp) {
                                String bs = je.getName();
                                int len = bs.length();
                                if (je.isDirectory()) {
                                    --len;
                                }
                                if (recursive) {
                                    if (Dir.fnmatch(STAR, 0, 1, bs, 0, len, flags) != 0) continue;
                                    buf = base.substring(0, base.length() - jar.length());
                                    buf = buf + (Dir.BASE(base) ? SLASH : EMPTY);
                                    buf = buf + bs.substring(0, len);
                                    if (!je.isDirectory()) continue;
                                    int t = buf.length();
                                    status = Dir.glob_helper(cwd, buf = buf + "/**" + bytes2.substring(m, end), 0, buf.length(), t, flags, func, arg);
                                    if (status == 0) continue;
                                }
                                if (Dir.fnmatch(magic, 0, magic.length(), bs, 0, len, flags) != 0) continue;
                                buf = base.substring(0, base.length() - jar.length());
                                buf = buf + (Dir.BASE(base) ? SLASH : EMPTY);
                                buf = buf + bs.substring(0, len);
                                if (m == -1) {
                                    status = func.call(buf, 0, buf.length(), arg);
                                    if (status == 0) continue;
                                }
                                link.add(buf);
                                buf = EMPTY;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (link.size() > 0) {
                    for (String b : link) {
                        if (status != 0 || !(st = b.charAt(0) == '/' || DOSISH && 2 < b.length() && b.charAt(1) == ':' && Dir.isdirsep(b.charAt(2)) ? new File(b) : new File(cwd, b)).isDirectory()) continue;
                        int len = b.length();
                        buf = b + bytes2.substring(m, end);
                        status = Dir.glob_helper(cwd, buf, 0, buf.length(), len, flags, func, arg);
                    }
                    break;
                }
            }
            p = m;
        }
        return status;
    }

    static {
        CASEFOLD_FILESYSTEM = DOSISH = System.getProperty("os.name").indexOf("Windows") != -1;
        FNM_SYSCASE = CASEFOLD_FILESYSTEM ? 8 : 0;
        push_pattern = new GlobFunc(){

            public int call(String ptr, int p, int len, Object ary) {
                ((List)ary).add(ptr.substring(p, p + len));
                return 0;
            }
        };
        glob_caller = new GlobFunc(){

            public int call(String ptr, int p, int len, Object ary) {
                GlobArgs args = (GlobArgs)ary;
                args.c = p;
                return args.func.call(ptr, args.c, len, args.v);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GlobArgs {
        GlobFunc func;
        int c = -1;
        List<String> v;

        public GlobArgs(GlobFunc func, List<String> arg) {
            this.func = func;
            this.v = arg;
        }
    }

    private static interface GlobFunc {
        public int call(String var1, int var2, int var3, Object var4);
    }

    private static class GlobPattern {
        final String string;
        final int begin;
        final int end;
        int flags;
        int index;

        public GlobPattern(String string, int flags) {
            this(string, 0, string.length(), flags);
        }

        public GlobPattern(String string, int index, int end, int flags) {
            this.string = string;
            this.index = index;
            this.begin = index;
            this.end = end;
            this.flags = flags;
        }

        public int findClosingIndexOf(int leftTokenIndex) {
            char rightToken;
            if (leftTokenIndex == -1 || leftTokenIndex > this.end) {
                return -1;
            }
            char leftToken = this.string.charAt(leftTokenIndex);
            switch (leftToken) {
                case '{': {
                    rightToken = '}';
                    break;
                }
                case '[': {
                    rightToken = ']';
                    break;
                }
                default: {
                    return -1;
                }
            }
            int nest = 1;
            this.index = leftTokenIndex + 1;
            while (this.hasNext()) {
                char c = this.next();
                if (c == leftToken) {
                    ++nest;
                    continue;
                }
                if (c != rightToken || --nest != 0) continue;
                return this.index();
            }
            return -1;
        }

        public boolean hasNext() {
            return this.index < this.end;
        }

        public void reset() {
            this.index = this.begin;
        }

        public void setIndex(int value) {
            this.index = value;
        }

        public int index() {
            return this.index - 1;
        }

        public int indexOf(char c) {
            while (this.hasNext()) {
                if (this.next() != c) continue;
                return this.index();
            }
            return -1;
        }

        public char next() {
            return this.string.charAt(this.index++);
        }
    }
}

