/*
 * Decompiled with CFR 0.152.
 */
package ioke.lang.util;

import ioke.lang.IokeSystem;

public class StringUtils {
    public String xmlSafe(String s) {
        int len = s.length();
        StringBuilder result = new StringBuilder(s.length());
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    result.append("&#34;");
                    continue block6;
                }
                default: {
                    if (c > '~') {
                        result.append("&#" + c + ";");
                        continue block6;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public String escape(String s) {
        int len = s.length();
        StringBuilder result = new StringBuilder(s.length());
        block11: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    result.append(c).append(c);
                    continue block11;
                }
                case '\"': {
                    result.append('\\').append(c);
                    continue block11;
                }
                case '#': {
                    if (i + 1 < len && s.charAt(i + 1) == '{') {
                        result.append('\\').append(c);
                        continue block11;
                    }
                    result.append(c);
                    continue block11;
                }
                case '\b': {
                    result.append('\\').append('b');
                    continue block11;
                }
                case '\f': {
                    result.append('\\').append('f');
                    continue block11;
                }
                case '\r': {
                    result.append('\\').append('r');
                    continue block11;
                }
                case '\t': {
                    result.append('\\').append('t');
                    continue block11;
                }
                case '\n': {
                    result.append('\\').append('n');
                    continue block11;
                }
                case '\u001b': {
                    result.append('\\').append('e');
                    continue block11;
                }
                default: {
                    if (c < ' ') {
                        result.append(String.format("\\%03o", c));
                        continue block11;
                    }
                    if (c > '~') {
                        if (c > '\u00ff') {
                            result.append(String.format("\\u%04X", c));
                            continue block11;
                        }
                        result.append(String.format("\\%03o", c));
                        continue block11;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public String replaceEscapes(String s) {
        if (s.indexOf(92) == -1) {
            if (IokeSystem.DOSISH) {
                return s.replaceAll("\r\n", "\n");
            }
            return s;
        }
        int len = s.length();
        StringBuilder result = new StringBuilder(s.length());
        if (IokeSystem.DOSISH) {
            block32: for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '\r' && i + 1 < len && s.charAt(i + 1) == '\n') {
                    result.append('\n');
                    ++i;
                    continue;
                }
                if (c != '\\') {
                    result.append(c);
                    continue;
                }
                switch (s.charAt(++i)) {
                    case '\n': {
                        continue block32;
                    }
                    case '\r': {
                        if (i + 1 >= len || s.charAt(i + 1) != '\n') continue block32;
                        ++i;
                        continue block32;
                    }
                    case '\\': {
                        result.append(c);
                        continue block32;
                    }
                    case 'f': {
                        result.append('\f');
                        continue block32;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block32;
                    }
                    case 'n': {
                        result.append('\n');
                        continue block32;
                    }
                    case 't': {
                        result.append('\t');
                        continue block32;
                    }
                    case 'b': {
                        result.append('\b');
                        continue block32;
                    }
                    case 'e': {
                        result.append('\u001b');
                        continue block32;
                    }
                    case '\"': {
                        result.append('\"');
                        continue block32;
                    }
                    case ']': {
                        result.append(']');
                        continue block32;
                    }
                    case '#': {
                        result.append('#');
                        continue block32;
                    }
                    case 'u': {
                        result.append((char)Integer.valueOf(s.substring(i + 1, i + 5), 16).intValue());
                        i += 4;
                        continue block32;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char cx;
                        int clen = 1;
                        char c2 = cx = i + 1 < len ? s.charAt(i + 1) : (char)'\u0000';
                        if (cx >= '0' && cx <= '7') {
                            ++clen;
                        }
                        char c3 = cx = i + 2 < len ? s.charAt(i + 2) : (char)'\u0000';
                        if (cx >= '0' && cx <= '7') {
                            ++clen;
                        }
                        result.append((char)Integer.valueOf(s.substring(i, i + clen), 8).intValue());
                        i += clen - 1;
                        continue block32;
                    }
                    default: {
                        result.append(s.charAt(i));
                    }
                }
            }
        } else {
            block33: for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c != '\\') {
                    result.append(c);
                    continue;
                }
                switch (s.charAt(++i)) {
                    case '\n': {
                        continue block33;
                    }
                    case '\r': {
                        if (i + 1 >= len || s.charAt(i + 1) != '\n') continue block33;
                        ++i;
                        continue block33;
                    }
                    case '\\': {
                        result.append(c);
                        continue block33;
                    }
                    case 'f': {
                        result.append('\f');
                        continue block33;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block33;
                    }
                    case 'n': {
                        result.append('\n');
                        continue block33;
                    }
                    case 't': {
                        result.append('\t');
                        continue block33;
                    }
                    case 'b': {
                        result.append('\b');
                        continue block33;
                    }
                    case 'e': {
                        result.append('\u001b');
                        continue block33;
                    }
                    case '\"': {
                        result.append('\"');
                        continue block33;
                    }
                    case ']': {
                        result.append(']');
                        continue block33;
                    }
                    case '#': {
                        result.append('#');
                        continue block33;
                    }
                    case 'u': {
                        result.append((char)Integer.valueOf(s.substring(i + 1, i + 5), 16).intValue());
                        i += 4;
                        continue block33;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char cx;
                        int clen = 1;
                        char c4 = cx = i + 1 < len ? s.charAt(i + 1) : (char)'\u0000';
                        if (cx >= '0' && cx <= '7') {
                            ++clen;
                        }
                        char c5 = cx = i + 2 < len ? s.charAt(i + 2) : (char)'\u0000';
                        if (cx >= '0' && cx <= '7') {
                            ++clen;
                        }
                        result.append((char)Integer.valueOf(s.substring(i, i + clen), 8).intValue());
                        i += clen - 1;
                        continue block33;
                    }
                    default: {
                        result.append(s.charAt(i));
                    }
                }
            }
        }
        return result.toString();
    }

    public String replaceRegexpEscapes(String s) {
        if (s.indexOf(92) == -1) {
            if (IokeSystem.DOSISH) {
                return s.replaceAll("\r\n", "\n");
            }
            return s;
        }
        int len = s.length();
        StringBuilder result = new StringBuilder(s.length());
        if (IokeSystem.DOSISH) {
            block28: for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '\r' && i + 1 < len && s.charAt(i + 1) == '\n') {
                    result.append('\n');
                    ++i;
                    continue;
                }
                if (c != '\\') {
                    result.append(c);
                    continue;
                }
                switch (s.charAt(++i)) {
                    case '\n': {
                        continue block28;
                    }
                    case '\r': {
                        if (i + 1 >= len || s.charAt(i + 1) != '\n') continue block28;
                        ++i;
                        continue block28;
                    }
                    case 'f': {
                        result.append('\f');
                        continue block28;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block28;
                    }
                    case 'n': {
                        result.append('\n');
                        continue block28;
                    }
                    case 't': {
                        result.append('\t');
                        continue block28;
                    }
                    case 'e': {
                        result.append('\u001b');
                        continue block28;
                    }
                    case '\"': {
                        result.append('\"');
                        continue block28;
                    }
                    case ']': {
                        result.append(']');
                        continue block28;
                    }
                    case '#': {
                        result.append('#');
                        continue block28;
                    }
                    case 'u': {
                        result.append((char)Integer.valueOf(s.substring(i + 1, i + 5), 16).intValue());
                        i += 4;
                        continue block28;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char cx;
                        int clen = 1;
                        char c2 = cx = i + 1 < len ? s.charAt(i + 1) : (char)'\u0000';
                        if (cx >= '0' && cx <= '7') {
                            ++clen;
                        }
                        char c3 = cx = i + 2 < len ? s.charAt(i + 2) : (char)'\u0000';
                        if (cx >= '0' && cx <= '7') {
                            ++clen;
                        }
                        result.append((char)Integer.valueOf(s.substring(i, i + clen), 8).intValue());
                        i += clen - 1;
                        continue block28;
                    }
                    default: {
                        result.append('\\');
                        result.append(s.charAt(i));
                    }
                }
            }
        } else {
            block29: for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c != '\\') {
                    result.append(c);
                    continue;
                }
                switch (s.charAt(++i)) {
                    case '\n': {
                        continue block29;
                    }
                    case '\r': {
                        if (i + 1 >= len || s.charAt(i + 1) != '\n') continue block29;
                        ++i;
                        continue block29;
                    }
                    case 'f': {
                        result.append('\f');
                        continue block29;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block29;
                    }
                    case 'n': {
                        result.append('\n');
                        continue block29;
                    }
                    case 't': {
                        result.append('\t');
                        continue block29;
                    }
                    case 'e': {
                        result.append('\u001b');
                        continue block29;
                    }
                    case '\"': {
                        result.append('\"');
                        continue block29;
                    }
                    case ']': {
                        result.append(']');
                        continue block29;
                    }
                    case '#': {
                        result.append('#');
                        continue block29;
                    }
                    case 'u': {
                        result.append((char)Integer.valueOf(s.substring(i + 1, i + 5), 16).intValue());
                        i += 4;
                        continue block29;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char cx;
                        int clen = 1;
                        char c4 = cx = i + 1 < len ? s.charAt(i + 1) : (char)'\u0000';
                        if (cx >= '0' && cx <= '7') {
                            ++clen;
                        }
                        char c5 = cx = i + 2 < len ? s.charAt(i + 2) : (char)'\u0000';
                        if (cx >= '0' && cx <= '7') {
                            ++clen;
                        }
                        result.append((char)Integer.valueOf(s.substring(i, i + clen), 8).intValue());
                        i += clen - 1;
                        continue block29;
                    }
                    default: {
                        result.append('\\');
                        result.append(s.charAt(i));
                    }
                }
            }
        }
        return result.toString();
    }
}

