/*
 * Decompiled with CFR 0.152.
 */
package org.jregex;

import org.jregex.Block;
import org.jregex.CharacterClass;
import org.jregex.Term;
import org.jregex.UnicodeConstants;

class Bitset
implements UnicodeConstants {
    private static final Block[][] categoryBits = new Block[32][256];
    private boolean positive = true;
    private boolean isLarge = false;
    boolean[] block0;
    private static final boolean[] emptyBlock0;
    Block[] blocks;
    private int weight;

    Bitset() {
    }

    final void reset() {
        this.positive = true;
        this.block0 = null;
        this.blocks = null;
        this.isLarge = false;
        this.weight = 0;
    }

    static final void unify(Bitset bs, Term term) {
        if (bs.isLarge) {
            term.type = Term.TermType.BITSET2;
            term.bitset2 = Block.toBitset2(bs.blocks);
        } else {
            term.type = Term.TermType.BITSET;
            term.bitset = bs.block0 == null ? emptyBlock0 : bs.block0;
        }
        term.inverse = !bs.positive;
        term.weight = bs.positive ? bs.weight : 65536 - bs.weight;
    }

    final void setPositive(boolean b) {
        this.positive = b;
    }

    final boolean isPositive() {
        return this.positive;
    }

    final boolean isLarge() {
        return this.isLarge;
    }

    private final void enableLargeMode() {
        if (this.isLarge) {
            return;
        }
        Block[] blocks = new Block[256];
        this.blocks = blocks;
        if (this.block0 != null) {
            blocks[0] = new Block(this.block0);
        }
        this.isLarge = true;
    }

    final int getWeight() {
        return this.positive ? this.weight : 65536 - this.weight;
    }

    final void setWordChar(boolean unicode) {
        if (unicode) {
            this.setCategory(1);
            this.setCategory(2);
            this.setCategory(3);
            this.setCategory(5);
            this.setCategory(9);
            this.setChar('_');
        } else {
            this.setRange('a', 'z');
            this.setRange('A', 'Z');
            this.setRange('0', '9');
            this.setChar('_');
        }
    }

    final void setDigit(boolean unicode) {
        if (unicode) {
            this.setCategory(9);
        } else {
            this.setRange('0', '9');
        }
    }

    final void setSpace(boolean unicode) {
        if (unicode) {
            this.setCategory(12);
            this.setCategory(14);
            this.setCategory(13);
        } else {
            this.setChar(' ');
            this.setChar('\r');
            this.setChar('\n');
            this.setChar('\t');
            this.setChar('\f');
        }
    }

    final void setCategory(int c) {
        if (!this.isLarge) {
            this.enableLargeMode();
        }
        Block[] catBits = categoryBits[c];
        this.weight += Block.add(this.blocks, catBits, 0, 255, false);
    }

    final void setChars(String chars) {
        for (int i = chars.length() - 1; i >= 0; --i) {
            this.setChar(chars.charAt(i));
        }
    }

    final void setChar(char c) {
        this.setRange(c, c);
    }

    final void setRange(char c1, char c2) {
        if (c2 >= '\u0100' || this.isLarge) {
            int s = 0;
            if (!this.isLarge) {
                this.enableLargeMode();
            }
            Block[] blocks = this.blocks;
            for (int c = c1; c <= c2; ++c) {
                int i2 = c >> 8 & 0xFF;
                int i = c & 0xFF;
                Block block = blocks[i2];
                if (block == null) {
                    blocks[i2] = block = new Block();
                }
                if (!block.set(i)) continue;
                ++s;
            }
            this.weight += s;
        } else {
            boolean[] block0 = this.block0;
            if (block0 == null) {
                this.block0 = block0 = new boolean[256];
            }
            this.weight += Bitset.set(block0, true, c1, c2);
        }
    }

    final void add(Bitset bs) {
        this.add(bs, false);
    }

    final void add(Bitset bs, boolean inverse) {
        this.weight += Bitset.addImpl(this, bs, !bs.positive ^ inverse);
    }

    private static final int addImpl(Bitset bs1, Bitset bs2, boolean inv) {
        int s = 0;
        if (!(bs1.isLarge || bs2.isLarge || inv)) {
            if (bs2.block0 != null) {
                boolean[] bits = bs1.block0;
                if (bits == null) {
                    bs1.block0 = bits = new boolean[256];
                }
                s += Bitset.add(bits, bs2.block0, 0, 255, false);
            }
        } else {
            if (!bs1.isLarge) {
                bs1.enableLargeMode();
            }
            if (!bs2.isLarge) {
                bs2.enableLargeMode();
            }
            s += Block.add(bs1.blocks, bs2.blocks, 0, 255, inv);
        }
        return s;
    }

    final void subtract(Bitset bs) {
        this.subtract(bs, false);
    }

    final void subtract(Bitset bs, boolean inverse) {
        this.weight += Bitset.subtractImpl(this, bs, !bs.positive ^ inverse);
    }

    private static final int subtractImpl(Bitset bs1, Bitset bs2, boolean inv) {
        int s = 0;
        if (!(bs1.isLarge || bs2.isLarge || inv)) {
            boolean[] bits2 = bs2.block0;
            if (bs2.block0 != null) {
                boolean[] bits1 = bs1.block0;
                if (bits1 == null) {
                    return 0;
                }
                s += Bitset.subtract(bits1, bits2, 0, 255, false);
            }
        } else {
            if (!bs1.isLarge) {
                bs1.enableLargeMode();
            }
            if (!bs2.isLarge) {
                bs2.enableLargeMode();
            }
            s += Block.subtract(bs1.blocks, bs2.blocks, 0, 255, inv);
        }
        return s;
    }

    final void intersect(Bitset bs) {
        this.intersect(bs, false);
    }

    final void intersect(Bitset bs, boolean inverse) {
        this.subtract(bs, !inverse);
    }

    static final int add(boolean[] bs1, boolean[] bs2, int from, int to, boolean inv) {
        int s = 0;
        for (int i = from; i <= to; ++i) {
            if (bs1[i] || !(bs2[i] ^ inv)) continue;
            ++s;
            bs1[i] = true;
        }
        return s;
    }

    static final int subtract(boolean[] bs1, boolean[] bs2, int from, int to, boolean inv) {
        int s = 0;
        for (int i = from; i <= to; ++i) {
            if (!bs1[i] || !(bs2[i] ^ inv)) continue;
            --s;
            bs1[i] = false;
        }
        return s;
    }

    static final int set(boolean[] arr, boolean value, int from, int to) {
        int s = 0;
        for (int i = from; i <= to; ++i) {
            if (arr[i] == value) continue;
            s = value ? ++s : --s;
            arr[i] = value;
        }
        return s;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.positive) {
            sb.append('^');
        }
        if (this.isLarge) {
            sb.append(CharacterClass.stringValue2(Block.toBitset2(this.blocks)));
        } else if (this.block0 != null) {
            sb.append(CharacterClass.stringValue0(this.block0));
        }
        sb.append('(');
        sb.append(this.getWeight());
        sb.append(')');
        return sb.toString();
    }

    static {
        for (int i = 0; i <= 65535; ++i) {
            int blockNo;
            int cat = Character.getType((char)i);
            Block b = categoryBits[cat][blockNo = i >> 8 & 0xFF];
            if (b == null) {
                Bitset.categoryBits[cat][blockNo] = b = new Block();
            }
            b.set(i & 0xFF);
        }
        emptyBlock0 = new boolean[256];
    }
}

