/*
 * Decompiled with CFR 0.152.
 */
package org.jregex;

import org.jregex.Find;
import org.jregex.FindBack;
import org.jregex.Term;

public class Optimizer {
    public static final int THRESHOLD = 20;
    private Term atom;
    private int distance;

    static Optimizer find(Term entry) {
        return Optimizer.find(entry, 0);
    }

    private static Optimizer find(Term term, int dist) {
        if (term == null) {
            return null;
        }
        Term next = term.next;
        Term.TermType type = term.type;
        switch (type) {
            case CHAR: 
            case REG: 
            case REG_I: {
                return new Optimizer(term, dist);
            }
            case BITSET: 
            case BITSET2: {
                if (term.weight <= 20) {
                    return new Optimizer(term, dist);
                }
                return Optimizer.find(term.next, dist + 1);
            }
            case ANY_CHAR: 
            case ANY_CHAR_NE: {
                return Optimizer.find(next, dist + 1);
            }
            case REPEAT_MIN_INF: 
            case REPEAT_MIN_MAX: {
                if (term.minCount > 0) {
                    return Optimizer.find(term.target, dist);
                }
                return null;
            }
            case BOUNDARY: 
            case DIRECTION: 
            case UBOUNDARY: 
            case UDIRECTION: 
            case GROUP_IN: 
            case GROUP_OUT: 
            case VOID: 
            case START: 
            case END: 
            case END_EOL: 
            case LINE_START: 
            case LINE_END: 
            case LAST_MATCH_END: 
            case CNT_SET_0: 
            case CNT_INC: 
            case CNT_GT_EQ: 
            case READ_CNT_LT: 
            case CRSTORE_CRINC: 
            case CR_SET_0: 
            case CR_LT: 
            case CR_GT_EQ: {
                return Optimizer.find(next, dist);
            }
        }
        return null;
    }

    private Optimizer(Term atom, int distance) {
        this.atom = atom;
        this.distance = distance;
    }

    Term makeFirst(Term theFirst) {
        return new Find(this.atom, this.distance, theFirst);
    }

    Term makeBacktrack(Term back) {
        int min = back.minCount;
        switch (back.type) {
            case BACKTRACK_0: {
                min = 0;
            }
            case BACKTRACK_MIN: {
                return new FindBack(this.atom, this.distance, min, back);
            }
            case BACKTRACK_REG_MIN: {
                return back;
            }
        }
        throw new Error("unexpected iterator's backtracker:" + back);
    }
}

