/*
 * Decompiled with CFR 0.152.
 */
package org.jregex;

import org.jregex.MemReg;
import org.jregex.Term;

class SearchEntry {
    Term term;
    int index;
    int cnt;
    int regLen;
    boolean isState;
    SearchEntry sub;
    SearchEntry on;
    private MState mHead;
    private MState mCurrent;
    private CState cHead;
    private CState cCurrent;

    SearchEntry() {
    }

    static final void saveMemregState(SearchEntry entry, int memreg, MemReg mr) {
        entry.isState = true;
        MState current = entry.mCurrent;
        if (current == null) {
            MState head = entry.mHead;
            if (head == null) {
                entry.mCurrent = current = new MState();
                entry.mHead = current;
            } else {
                current = head;
            }
        } else {
            MState next = current.next;
            if (next == null) {
                current.next = next = new MState();
                next.prev = current;
            }
            current = next;
        }
        current.index = memreg;
        current.in = mr.in;
        current.out = mr.out;
        entry.mCurrent = current;
    }

    static final void saveCntState(SearchEntry entry, int cntreg, int value) {
        entry.isState = true;
        CState current = entry.cCurrent;
        if (current == null) {
            CState head = entry.cHead;
            if (head == null) {
                entry.cCurrent = current = new CState();
                entry.cHead = current;
            } else {
                current = head;
            }
        } else {
            CState next = current.next;
            if (next == null) {
                current.next = next = new CState();
                next.prev = current;
            }
            current = next;
        }
        current.index = cntreg;
        current.value = value;
        entry.cCurrent = current;
    }

    static final void popState(SearchEntry entry, MemReg[] memregs, int[] counters) {
        MState ms = entry.mCurrent;
        while (ms != null) {
            MemReg mr = memregs[ms.index];
            mr.in = ms.in;
            mr.out = ms.out;
            ms = ms.prev;
        }
        CState cs = entry.cCurrent;
        while (cs != null) {
            counters[cs.index] = cs.value;
            cs = cs.prev;
        }
        entry.mCurrent = null;
        entry.cCurrent = null;
        entry.isState = false;
    }

    final void reset(int restQueue) {
        this.term = null;
        this.regLen = 0;
        this.cnt = 0;
        this.index = 0;
        this.mCurrent = null;
        this.cCurrent = null;
        this.isState = false;
        SearchEntry on = this.on;
        if (on != null) {
            if (restQueue > 0) {
                on.reset(restQueue - 1);
            } else {
                this.on = null;
                on.sub = null;
            }
        }
    }

    private static class CState {
        int index;
        int value;
        CState next;
        CState prev;

        private CState() {
        }
    }

    private static class MState {
        int index;
        int in;
        int out;
        MState next;
        MState prev;

        private MState() {
        }
    }
}

