/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import org.dsa.iot.dslink.DSLinkHandler;
import org.dsa.iot.dslink.connection.DataHandler;
import org.dsa.iot.dslink.link.Requester;
import org.dsa.iot.dslink.link.Responder;
import org.dsa.iot.dslink.methods.StreamState;
import org.dsa.iot.dslink.node.NodeManager;
import org.dsa.iot.dslink.node.SubscriptionManager;
import org.dsa.iot.dslink.serializer.SerializationManager;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSLink {
    private static final Logger LOGGER = LoggerFactory.getLogger(DSLink.class);
    private final SubscriptionManager manager = new SubscriptionManager(this);
    private final DSLinkHandler linkHandler;
    private final NodeManager nodeManager;
    private final Requester requester;
    private final Responder responder;
    private final String path;
    private SerializationManager serialManager;
    private DataHandler dataHandler;

    protected DSLink(DSLinkHandler linkHandler, boolean isReqOrResp, String path) {
        if (linkHandler == null) {
            throw new NullPointerException("linkHandler");
        }
        this.linkHandler = linkHandler;
        this.path = path;
        if (isReqOrResp) {
            this.requester = new Requester(linkHandler);
            this.requester.setDSLink(this);
            this.responder = null;
            this.nodeManager = new NodeManager(this.requester, "node");
        } else {
            this.responder = new Responder(linkHandler);
            this.responder.setDSLink(this);
            this.requester = null;
            this.nodeManager = new NodeManager(this.responder, "node");
        }
    }

    public void setSerialManager(SerializationManager manager) {
        if (this.serialManager != null) {
            this.serialManager.stop();
        }
        this.serialManager = manager;
    }

    public SerializationManager getSerialManager() {
        return this.serialManager;
    }

    public DSLinkHandler getLinkHandler() {
        return this.linkHandler;
    }

    public void setWriter(DataHandler handler) {
        this.dataHandler = handler;
    }

    public DataHandler getWriter() {
        return this.dataHandler;
    }

    public boolean isConnected() {
        return this.dataHandler != null && this.dataHandler.isConnected();
    }

    public String getPath() {
        return this.path;
    }

    public Requester getRequester() {
        return this.requester;
    }

    public Responder getResponder() {
        return this.responder;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.manager;
    }

    public void setDefaultDataHandlers(boolean requester, boolean responder) {
        if (requester) {
            this.getWriter().setRespHandler(new Handler<DataHandler.DataReceived>(){

                @Override
                public void handle(DataHandler.DataReceived event) {
                    JsonArray array = event.getData();
                    for (Object object : array) {
                        try {
                            JsonObject json = (JsonObject)object;
                            DSLink.this.requester.parse(json);
                        }
                        catch (RuntimeException e) {
                            LOGGER.error("Failed to parse json", (Throwable)e);
                        }
                    }
                    DSLink.this.getWriter().writeAck(event.getMsgId());
                }
            });
        }
        if (responder) {
            this.getWriter().setReqHandler(new Handler<DataHandler.DataReceived>(){

                @Override
                public void handle(DataHandler.DataReceived event) {
                    JsonArray data = event.getData();
                    LinkedList<JsonObject> responses = new LinkedList<JsonObject>();
                    for (Object object : data) {
                        JsonObject json = (JsonObject)object;
                        try {
                            JsonObject resp = DSLink.this.responder.parse(json);
                            responses.add(resp);
                        }
                        catch (Exception e) {
                            JsonObject resp = new JsonObject();
                            Integer rid = (Integer)json.get("rid");
                            if (rid != null) {
                                resp.put("rid", rid);
                            }
                            resp.put("stream", StreamState.CLOSED.getJsonName());
                            JsonObject err = new JsonObject();
                            err.put("msg", e.getMessage());
                            StringWriter writer = new StringWriter();
                            e.printStackTrace(new PrintWriter(writer));
                            err.put("detail", writer.toString());
                            resp.put("error", err);
                            responses.add(resp);
                        }
                    }
                    Integer msgId = event.getMsgId();
                    DSLink.this.getWriter().writeRequestResponses(msgId, responses);
                }
            });
        }
    }

    public void stop() {
        SerializationManager manager = this.getSerialManager();
        if (manager != null) {
            manager.stop();
        }
    }
}

