/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink;

import org.dsa.iot.dslink.DSLinkHandler;
import org.dsa.iot.dslink.DSLinkProvider;
import org.dsa.iot.dslink.config.Configuration;
import org.dsa.iot.dslink.connection.ConnectionManager;
import org.dsa.iot.dslink.handshake.LocalHandshake;
import org.dsa.iot.dslink.handshake.LocalKeys;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.dsa.iot.dslink.util.log.LogLevel;
import org.dsa.iot.dslink.util.log.LogManager;

public class DSLinkFactory {
    public static void start(String[] args, DSLinkHandler handler) {
        DSLinkProvider provider = DSLinkFactory.generate(args, handler);
        if (provider != null) {
            DSLinkFactory.startProvider(provider);
        }
    }

    public static DSLinkProvider generate(String[] args, DSLinkHandler handler) {
        LogManager.setLevel(LogLevel.ERROR);
        boolean req = handler.isRequester();
        boolean resp = handler.isResponder();
        JsonObject ld = handler.getLinkData();
        Configuration conf = Configuration.autoConfigure(args, req, resp, ld);
        if (conf == null) {
            return null;
        }
        handler.setConfig(conf);
        return DSLinkFactory.generate(handler);
    }

    public static DSLinkProvider generate(DSLinkHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        Configuration config = handler.getConfig();
        if (config == null) {
            throw new NullPointerException("handler configuration not set");
        }
        LocalKeys keys = config.getKeys();
        if (keys == null) {
            keys = LocalKeys.generate();
            config.setKeys(keys);
        }
        config.validate();
        LocalHandshake lh = new LocalHandshake(config);
        ConnectionManager manager = new ConnectionManager(config, lh);
        return new DSLinkProvider(manager, handler);
    }

    private static void startProvider(DSLinkProvider provider) {
        if (provider != null) {
            provider.start();
            provider.sleep();
        }
    }
}

