/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink;

import org.dsa.iot.dslink.DSLink;
import org.dsa.iot.dslink.DSLinkProvider;
import org.dsa.iot.dslink.config.Configuration;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.exceptions.NoSuchPathException;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.util.json.JsonObject;

public abstract class DSLinkHandler {
    private Configuration configuration;
    private DSLinkProvider provider;

    public JsonObject getLinkData() {
        return null;
    }

    public boolean isResponder() {
        return false;
    }

    public boolean isRequester() {
        return false;
    }

    public void stop() {
    }

    public void setConfig(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.configuration = configuration;
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public void setProvider(DSLinkProvider provider) {
        this.provider = provider;
    }

    public DSLinkProvider getProvider() {
        return this.provider;
    }

    public void preInit() {
    }

    public void onRequesterInitialized(DSLink link) {
    }

    public void onRequesterConnected(DSLink link) {
    }

    public void onRequesterDisconnected(DSLink link) {
    }

    public void onResponderInitialized(DSLink link) {
    }

    public void onResponderConnected(DSLink link) {
    }

    public void onResponderDisconnected(DSLink link) {
    }

    public Node onSubscriptionFail(String path) {
        return null;
    }

    public Node onInvocationFail(String path) {
        return null;
    }

    public void onSetFail(String path, Value value) {
        throw new NoSuchPathException(path);
    }
}

