/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.dsa.iot.dslink.DSLink;
import org.dsa.iot.dslink.DSLinkHandler;
import org.dsa.iot.dslink.connection.ConnectionManager;
import org.dsa.iot.dslink.connection.DataHandler;
import org.dsa.iot.dslink.link.Responder;
import org.dsa.iot.dslink.node.NodeManager;
import org.dsa.iot.dslink.serializer.SerializationManager;
import org.dsa.iot.dslink.util.Objects;
import org.dsa.iot.dslink.util.handler.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSLinkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DSLinkProvider.class);
    private final Map<String, DSLink> linkRequesterCache;
    private final Map<String, DSLink> linkResponderCache;
    private final ConnectionManager manager;
    private final DSLinkHandler handler;
    private final Object lock;
    private boolean running;

    public DSLinkProvider(ConnectionManager manager, DSLinkHandler handler) {
        if (manager == null) {
            throw new NullPointerException("manager");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        handler.setProvider(this);
        this.linkRequesterCache = new ConcurrentHashMap<String, DSLink>();
        this.linkResponderCache = new ConcurrentHashMap<String, DSLink>();
        this.lock = new Object();
        this.manager = manager;
        this.handler = handler;
        handler.preInit();
    }

    public void start() {
        this.running = true;
        final String dsId = this.handler.getConfig().getDsIdWithHash();
        this.manager.setPreInitHandler(new Handler<ConnectionManager.Client>(){

            @Override
            public void handle(final ConnectionManager.Client event) {
                final CountDownLatch latch = new CountDownLatch(2);
                final DataHandler writer = event.getHandler();
                final String path = event.getPath();
                Objects.getDaemonThreadPool().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (event.isRequester()) {
                            DSLink link;
                            Object object = DSLinkProvider.this.lock;
                            synchronized (object) {
                                DSLink tmp = (DSLink)DSLinkProvider.this.linkRequesterCache.get(dsId);
                                if (tmp == null) {
                                    tmp = new DSLink(DSLinkProvider.this.handler, true, path);
                                    tmp.setWriter(writer);
                                    tmp.setDefaultDataHandlers(true, false);
                                    DSLinkProvider.this.handler.onRequesterInitialized(tmp);
                                    DSLinkProvider.this.linkRequesterCache.put(dsId, tmp);
                                }
                                link = tmp;
                            }
                            event.setRequesterOnConnected(new Handler<ConnectionManager.Client>(){

                                @Override
                                public void handle(ConnectionManager.Client event) {
                                    DSLinkProvider.this.handler.onRequesterConnected(link);
                                }
                            });
                            event.setRequesterOnDisconnected(new Handler<Void>(){

                                @Override
                                public void handle(Void event) {
                                    link.getRequester().clearSubscriptions();
                                    DSLinkProvider.this.handler.onRequesterDisconnected(link);
                                }
                            });
                        }
                        latch.countDown();
                    }
                });
                Objects.getDaemonThreadPool().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (event.isResponder()) {
                            DSLink link;
                            Object object = DSLinkProvider.this.lock;
                            synchronized (object) {
                                DSLink tmp = (DSLink)DSLinkProvider.this.linkResponderCache.get(dsId);
                                if (tmp == null) {
                                    tmp = new DSLink(DSLinkProvider.this.handler, false, path);
                                    tmp.setWriter(writer);
                                    File path2 = DSLinkProvider.this.handler.getConfig().getSerializationPath();
                                    if (path2 != null) {
                                        NodeManager man = tmp.getNodeManager();
                                        SerializationManager manager = new SerializationManager(path2, man);
                                        try {
                                            manager.deserialize();
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Failed to deserialize nodes", (Throwable)e);
                                        }
                                        manager.markChangedOverride(false);
                                        manager.start();
                                        tmp.setSerialManager(manager);
                                    }
                                    tmp.setDefaultDataHandlers(false, true);
                                    DSLinkProvider.this.handler.onResponderInitialized(tmp);
                                    DSLinkProvider.this.linkResponderCache.put(dsId, tmp);
                                }
                                link = tmp;
                            }
                            event.setResponderOnConnected(new Handler<ConnectionManager.Client>(){

                                @Override
                                public void handle(ConnectionManager.Client event) {
                                    DSLinkProvider.this.handler.onResponderConnected(link);
                                }
                            });
                            event.setResponderOnDisconnected(new Handler<Void>(){

                                @Override
                                public void handle(Void event) {
                                    Responder resp = link.getResponder();
                                    resp.getSubscriptionManager().disconnected();
                                    DSLinkProvider.this.handler.onResponderDisconnected(link);
                                }
                            });
                        }
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.manager.start(null);
    }

    public void stop() {
        this.running = false;
        this.manager.stop();
        this.handler.stop();
        for (DSLink link : this.linkRequesterCache.values()) {
            link.stop();
        }
        for (DSLink link : this.linkResponderCache.values()) {
            link.stop();
        }
    }

    public Map<String, DSLink> getResponders() {
        return Collections.unmodifiableMap(this.linkResponderCache);
    }

    public Map<String, DSLink> getRequesters() {
        return Collections.unmodifiableMap(this.linkRequesterCache);
    }

    public void sleep() {
        block3: {
            try {
                while (this.running) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException e) {
                if (!this.running) break block3;
                throw new RuntimeException(e);
            }
        }
    }
}

