/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.config;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;

@Parameters(separators="= ")
public class Arguments {
    @Parameter(names={"--broker", "-b"}, description="Sets the broker host to perform a handshake connection to", arity=1, required=true)
    private String broker;
    @Parameter(names={"--token", "-t"}, description="Sets the token used when connecting to the broker", arity=1)
    private String token;
    @Parameter(names={"--nodes", "-n"}, description="Sets the path for the serialized nodes", arity=1)
    private String nodes;
    @Parameter(names={"--key", "-k"}, description="Sets the path for the stored key", arity=1)
    private String key;
    @Parameter(names={"--log", "-l"}, description="Sets the log level", arity=1)
    private String log;
    @Parameter(names={"--log-file", "-f"}, description="Sets the output log file", arity=1)
    private String logFile;
    @Parameter(names={"--dslink-json", "-d"}, description="Sets the location of the dslink.json file", arity=1)
    private String dslinkJson = "dslink.json";
    @Parameter(names={"--name"}, description="Sets the name of the dslink", arity=1)
    private String name;
    @Parameter(names={"--help", "-h"}, description="Displays the help menu", help=true)
    private boolean help = false;

    public String getDslinkJson() {
        return this.dslinkJson;
    }

    public String getBrokerHost() {
        return this.broker;
    }

    public String getToken() {
        return this.token;
    }

    public String getNodesPath() {
        return this.nodes;
    }

    public String getKeyPath() {
        return this.key;
    }

    public String getLogLevel() {
        return this.log;
    }

    public String getLogPath() {
        return this.logFile;
    }

    public String getName() {
        return this.name;
    }

    public static Arguments parse(String[] args) {
        try {
            Arguments parsed = new Arguments();
            JCommander jc = new JCommander((Object)parsed, args);
            jc.setProgramName("<dslink>");
            if (parsed.help) {
                jc.usage();
                return null;
            }
            return parsed;
        }
        catch (ParameterException pe) {
            System.out.println("Use --help or -h to get usage help");
            System.out.println(pe.getMessage());
            return null;
        }
    }
}

