/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.config;

import java.io.File;
import java.io.IOException;
import org.dsa.iot.dslink.DSLinkHandler;
import org.dsa.iot.dslink.config.Arguments;
import org.dsa.iot.dslink.connection.ConnectionType;
import org.dsa.iot.dslink.handshake.LocalKeys;
import org.dsa.iot.dslink.util.FileUtils;
import org.dsa.iot.dslink.util.URLInfo;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.dsa.iot.dslink.util.log.LogManager;

public class Configuration {
    private URLInfo authEndpoint;
    private String dsId;
    private String zone;
    private boolean isRequester;
    private boolean isResponder;
    private ConnectionType type;
    private LocalKeys keys;
    private File serializationPath;
    private JsonObject linkData;
    private String token;

    public void setAuthEndpoint(String endpoint) {
        this.setAuthEndpoint(URLInfo.parse(endpoint));
    }

    public void setAuthEndpoint(URLInfo endpoint) {
        this.authEndpoint = endpoint;
    }

    public URLInfo getAuthEndpoint() {
        return this.authEndpoint;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public void setKeys(String serializedKeys) {
        if (serializedKeys == null) {
            throw new NullPointerException("serializedKeys");
        }
        this.setKeys(LocalKeys.deserialize(serializedKeys));
    }

    public void setKeys(LocalKeys keys) {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        this.keys = keys;
    }

    public LocalKeys getKeys() {
        return this.keys;
    }

    public void setConnectionType(ConnectionType type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
    }

    public ConnectionType getConnectionType() {
        return this.type;
    }

    public void setDsId(String dsId) {
        if (dsId == null) {
            throw new NullPointerException("dsId");
        }
        if (dsId.isEmpty()) {
            throw new IllegalArgumentException("dsId is empty");
        }
        this.dsId = dsId;
    }

    public String getDsId() {
        return this.dsId;
    }

    public String getDsIdWithHash() {
        return this.getDsId() + "-" + this.keys.encodedHashPublicKey();
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getZone() {
        return this.zone;
    }

    public void setRequester(boolean requester) {
        this.isRequester = requester;
    }

    public boolean isRequester() {
        return this.isRequester;
    }

    public void setResponder(boolean responder) {
        this.isResponder = responder;
    }

    public boolean isResponder() {
        return this.isResponder;
    }

    public void setLinkData(JsonObject data) {
        this.linkData = data == null ? null : data;
    }

    public JsonObject getLinkData() {
        return this.linkData;
    }

    public void setSerializationPath(File file) {
        this.serializationPath = file;
    }

    public File getSerializationPath() {
        return this.serializationPath;
    }

    public void validate() {
        if (this.dsId == null) {
            throw new IllegalStateException("dsId not set");
        }
        if (this.dsId.isEmpty()) {
            throw new IllegalStateException("dsId is empty");
        }
        if (this.type == null) {
            throw new IllegalStateException("connection type not set");
        }
        if (this.authEndpoint == null) {
            throw new IllegalStateException("authentication endpoint not set");
        }
        if (this.keys == null) {
            throw new IllegalStateException("keys not set");
        }
        if (!this.isRequester && !this.isResponder) {
            throw new IllegalStateException("Neither a requester nor a responder");
        }
        if (this.token != null && this.token.length() != 48) {
            throw new IllegalStateException("Token is not 48 characters long");
        }
    }

    public static Configuration autoConfigure(String[] origArgs, boolean requester, boolean responder, JsonObject linkData) {
        Configuration defaults = new Configuration();
        defaults.setConnectionType(ConnectionType.WEB_SOCKET);
        defaults.setRequester(requester);
        defaults.setResponder(responder);
        defaults.setLinkData(linkData);
        Arguments pArgs = Arguments.parse(origArgs);
        if (pArgs == null) {
            return null;
        }
        JsonObject json = Configuration.getAndValidateJson(pArgs.getDslinkJson());
        String name = Configuration.getFieldValue(pArgs.getName(), json, "name");
        String logLevel = Configuration.getFieldValue(pArgs.getLogLevel(), json, "log");
        String brokerHost = pArgs.getBrokerHost();
        String keyPath = Configuration.getFieldValue(pArgs.getKeyPath(), json, "key");
        String nodePath = Configuration.getFieldValue(pArgs.getNodesPath(), json, "nodes");
        String handlerClass = Configuration.getFieldValue(null, json, "handler_class");
        String logPath = pArgs.getLogPath();
        File file = null;
        if (logPath != null) {
            file = new File(logPath);
        }
        LogManager.configure(file);
        LogManager.setLevel(logLevel);
        String prop = System.getProperty("dslink.validate", "true");
        boolean validate = Boolean.parseBoolean(prop);
        if (validate) {
            prop = "dslink.validate.handler_class";
            prop = System.getProperty(prop, "true");
            validate = Boolean.parseBoolean(prop);
        }
        if (validate) {
            try {
                ClassLoader loader = Configuration.class.getClassLoader();
                Class<?> clazz = loader.loadClass(handlerClass);
                if (!DSLinkHandler.class.isAssignableFrom(clazz)) {
                    String err = "Class `" + handlerClass + "` does not extend";
                    err = err + " " + DSLinkHandler.class.getName();
                    throw new RuntimeException(err);
                }
            }
            catch (ClassNotFoundException e) {
                String err = "Handler class not found: " + handlerClass;
                throw new RuntimeException(err);
            }
        }
        defaults.setAuthEndpoint(brokerHost);
        defaults.setToken(pArgs.getToken());
        defaults.setDsId(name);
        File loc = new File(keyPath);
        defaults.setKeys(LocalKeys.getFromFileSystem(loc));
        loc = new File(nodePath);
        defaults.setSerializationPath(loc);
        return defaults;
    }

    private static JsonObject getAndValidateJson(String jsonPath) {
        File file = new File(jsonPath);
        try {
            byte[] bytes = FileUtils.readAllBytes(file);
            JsonObject json = new JsonObject(new String(bytes, "UTF-8"));
            json = (JsonObject)json.get("configs");
            if (json == null) {
                throw new RuntimeException("Missing `configs` field");
            }
            String prop = System.getProperty("dslink.validate", "true");
            if (!Boolean.parseBoolean(prop)) {
                return json;
            }
            prop = System.getProperty("dslink.validate.json", "true");
            if (!Boolean.parseBoolean(prop)) {
                return json;
            }
            Configuration.checkField(json, "broker");
            Configuration.checkParam(json, "name");
            Configuration.checkParam(json, "log");
            Configuration.checkParam(json, "key");
            Configuration.checkParam(json, "nodes");
            Configuration.checkParam(json, "handler_class");
            return json;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFieldValue(String argsVal, JsonObject json, String field) {
        if (argsVal == null) {
            JsonObject param = (JsonObject)json.get(field);
            if (param == null) {
                return null;
            }
            return (String)param.get("default");
        }
        return argsVal;
    }

    private static void checkField(JsonObject configs, String name) {
        if (!configs.contains(name)) {
            throw new RuntimeException("Missing config field of " + name);
        }
    }

    private static void checkParam(JsonObject configs, String param) {
        JsonObject conf = (JsonObject)configs.get(param);
        if (conf == null) {
            throw new RuntimeException("Missing config field of " + param);
        }
        if (conf.get("default") == null) {
            throw new RuntimeException("Missing default value in config of " + param);
        }
    }
}

