/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.connection;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dsa.iot.dslink.config.Configuration;
import org.dsa.iot.dslink.connection.ConnectionType;
import org.dsa.iot.dslink.connection.DataHandler;
import org.dsa.iot.dslink.connection.NetworkClient;
import org.dsa.iot.dslink.connection.connector.WebSocketConnector;
import org.dsa.iot.dslink.handshake.LocalHandshake;
import org.dsa.iot.dslink.handshake.RemoteHandshake;
import org.dsa.iot.dslink.util.Objects;
import org.dsa.iot.dslink.util.URLInfo;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private final Configuration configuration;
    private final LocalHandshake localHandshake;
    private Handler<Client> preInitHandler;
    private DataHandler handler;
    private NetworkClient client;
    private int delay = 1;
    private ScheduledFuture<?> future;
    private boolean running;

    public ConnectionManager(Configuration configuration, LocalHandshake localHandshake) {
        this.configuration = configuration;
        this.localHandshake = localHandshake;
    }

    public void setPreInitHandler(Handler<Client> onClientInit) {
        this.preInitHandler = onClientInit;
    }

    public synchronized void start(final Handler<Client> onClientConnected) {
        this.stop();
        this.running = true;
        ScheduledThreadPoolExecutor stpe = Objects.getDaemonThreadPool();
        stpe.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ConnectionManager connectionManager = ConnectionManager.this;
                synchronized (connectionManager) {
                    if (!ConnectionManager.this.running) {
                        return;
                    }
                }
                LOGGER.debug("Initiating connection sequence");
                RemoteHandshake remoteHandshake = ConnectionManager.this.generateHandshake(new Handler<Exception>(){

                    @Override
                    public void handle(Exception event) {
                        LOGGER.error("Failed to complete handshake: {}", (Object)event.getMessage());
                        ConnectionManager.this.reconnect();
                    }
                });
                if (remoteHandshake == null) {
                    return;
                }
                if (ConnectionManager.this.handler == null) {
                    ConnectionManager.this.handler = new DataHandler();
                }
                boolean req = ConnectionManager.this.localHandshake.isRequester();
                boolean resp = ConnectionManager.this.localHandshake.isResponder();
                String path = remoteHandshake.getPath();
                final Client cc = new Client(req, resp, path);
                cc.setHandler(ConnectionManager.this.handler);
                if (ConnectionManager.this.preInitHandler != null) {
                    ConnectionManager.this.preInitHandler.handle(cc);
                }
                ConnectionType type = ConnectionManager.this.configuration.getConnectionType();
                switch (type) {
                    case WEB_SOCKET: {
                        WebSocketConnector connector = new WebSocketConnector();
                        connector.setEndpoint(ConnectionManager.this.configuration.getAuthEndpoint());
                        connector.setRemoteHandshake(remoteHandshake);
                        connector.setLocalHandshake(ConnectionManager.this.localHandshake);
                        connector.setOnConnected((Handler)new Handler<Void>(){

                            @Override
                            public void handle(Void event) {
                                if (onClientConnected != null) {
                                    onClientConnected.handle(cc);
                                }
                                cc.connected();
                            }
                        });
                        connector.setOnDisconnected((Handler)new Handler<Void>(){

                            @Override
                            public void handle(Void event) {
                                cc.disconnected();
                                if (ConnectionManager.this.running) {
                                    LOGGER.warn("WebSocket connection failed");
                                    ConnectionManager.this.reconnect();
                                }
                            }
                        });
                        connector.setOnData((Handler)new Handler<JsonObject>(){

                            @Override
                            public void handle(JsonObject event) {
                                ConnectionManager.this.handler.processData(event);
                            }
                        });
                        ConnectionManager.this.client = connector;
                        ConnectionManager.this.handler.setClient(connector, remoteHandshake.getFormat());
                        connector.start();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled type: " + (Object)((Object)type));
                    }
                }
            }
        });
    }

    public synchronized void stop() {
        this.running = false;
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteHandshake generateHandshake(Handler<Exception> errorHandler) {
        try {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (!this.running) {
                    return null;
                }
            }
            URLInfo auth = this.configuration.getAuthEndpoint();
            return RemoteHandshake.generate(this.localHandshake, auth);
        }
        catch (Exception e) {
            if (errorHandler != null) {
                errorHandler.handle(e);
            }
            return null;
        }
    }

    private synchronized void reconnect() {
        if (!this.running) {
            return;
        }
        LOGGER.info("Reconnecting in {} seconds", (Object)this.delay);
        this.future = Objects.getDaemonThreadPool().schedule(new Runnable(){

            @Override
            public void run() {
                ConnectionManager.this.start(new Handler<Client>(){

                    @Override
                    public void handle(Client event) {
                        LOGGER.info("Connection established");
                        ConnectionManager.this.delay = 1;
                    }
                });
                ConnectionManager.this.delay = ConnectionManager.this.delay * 2;
                int cap = 60;
                if (ConnectionManager.this.delay > cap) {
                    ConnectionManager.this.delay = cap;
                }
                ConnectionManager.this.future = null;
            }
        }, (long)this.delay, TimeUnit.SECONDS);
    }

    public static class Client {
        private final boolean isRequester;
        private final boolean isResponder;
        private final String path;
        private Handler<Client> onRequesterConnected;
        private Handler<Client> onResponderConnected;
        private Handler<Void> onRequesterDisconnected;
        private Handler<Void> onResponderDisconnected;
        private DataHandler handler;

        public Client(boolean isRequester, boolean isResponder, String path) {
            this.isRequester = isRequester;
            this.isResponder = isResponder;
            this.path = path;
        }

        public DataHandler getHandler() {
            return this.handler;
        }

        void setHandler(DataHandler handler) {
            this.handler = handler;
        }

        public boolean isRequester() {
            return this.isRequester;
        }

        public boolean isResponder() {
            return this.isResponder;
        }

        public String getPath() {
            return this.path;
        }

        public void setRequesterOnConnected(Handler<Client> handler) {
            this.onRequesterConnected = handler;
        }

        public void setResponderOnConnected(Handler<Client> handler) {
            this.onResponderConnected = handler;
        }

        public void setRequesterOnDisconnected(Handler<Void> handler) {
            this.onRequesterDisconnected = handler;
        }

        public void setResponderOnDisconnected(Handler<Void> handler) {
            this.onResponderDisconnected = handler;
        }

        void connected() {
            if (this.onRequesterConnected != null) {
                this.onRequesterConnected.handle(this);
            }
            if (this.onResponderConnected != null) {
                this.onResponderConnected.handle(this);
            }
        }

        void disconnected() {
            if (this.onRequesterDisconnected != null) {
                this.onRequesterDisconnected.handle(null);
            }
            if (this.onResponderDisconnected != null) {
                this.onResponderDisconnected.handle(null);
            }
        }
    }
}

