/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.connection;

import java.util.Collection;
import java.util.Collections;
import org.dsa.iot.dslink.connection.MessageTracker;
import org.dsa.iot.dslink.connection.NetworkClient;
import org.dsa.iot.dslink.connection.QueuedWriteManager;
import org.dsa.iot.dslink.util.Objects;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.EncodingFormat;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHandler
implements MessageTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataHandler.class);
    private final Object msgLock = new Object();
    private int messageId = 0;
    private int lastReceivedAck = 0;
    private EncodingFormat format;
    private NetworkClient client;
    private Handler<DataReceived> reqHandler;
    private Handler<DataReceived> respHandler;
    private QueuedWriteManager reqsManager;
    private QueuedWriteManager respsManager;

    public void setClient(NetworkClient client, EncodingFormat format) {
        this.client = client;
        this.format = format;
        this.reqsManager = new QueuedWriteManager(client, this, format, "requests");
        this.respsManager = new QueuedWriteManager(client, this, format, "responses");
    }

    public void setReqHandler(Handler<DataReceived> handler) {
        this.reqHandler = handler;
    }

    public void setRespHandler(Handler<DataReceived> handler) {
        this.respHandler = handler;
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    public void processData(JsonObject obj) {
        Integer ackId;
        if (LOGGER.isDebugEnabled()) {
            String f = this.format.toJson();
            LOGGER.debug("Received data ({}): {}", (Object)f, (Object)obj);
        }
        final Integer msgId = (Integer)obj.get("msg");
        final JsonArray requests = (JsonArray)obj.get("requests");
        if (this.reqHandler != null && requests != null) {
            Objects.getDaemonThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    DataHandler.this.reqHandler.handle(new DataReceived(msgId, requests));
                }
            });
        }
        final JsonArray responses = (JsonArray)obj.get("responses");
        if (this.respHandler != null && responses != null) {
            Objects.getDaemonThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    DataHandler.this.respHandler.handle(new DataReceived(msgId, responses));
                }
            });
        }
        if ((ackId = (Integer)obj.get("ack")) != null) {
            this.ackReceived(ackId);
        }
    }

    public void writeRequest(JsonObject object, boolean merge) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        this.reqsManager.post(object, merge);
    }

    public void writeAck(Integer ack) {
        if (ack == null) {
            return;
        }
        JsonObject obj = new JsonObject();
        obj.put("ack", ack);
        this.client.write(this.format, obj);
    }

    public void writeResponse(JsonObject object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        this.writeRequestResponses(null, Collections.singleton(object));
    }

    public void writeRequestResponses(Integer ackId, Collection<JsonObject> objects) {
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        for (JsonObject o : objects) {
            this.respsManager.post(o, true);
        }
        if (ackId != null) {
            JsonObject ack = new JsonObject();
            ack.put("ack", ackId);
            this.client.write(this.format, ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ackReceived(int ack) {
        Object object = this.msgLock;
        synchronized (object) {
            this.lastReceivedAck = Math.max(this.lastReceivedAck, ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int missingAckCount() {
        Object object = this.msgLock;
        synchronized (object) {
            return this.messageId - this.lastReceivedAck;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int incrementMessageId() {
        Object object = this.msgLock;
        synchronized (object) {
            return ++this.messageId;
        }
    }

    public static class DataReceived {
        private final Integer msgId;
        private final JsonArray data;

        public DataReceived(Integer msgId, JsonArray data) {
            this.msgId = msgId;
            this.data = data;
        }

        public Integer getMsgId() {
            return this.msgId;
        }

        public JsonArray getData() {
            return this.data;
        }
    }
}

