/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.connection;

import io.netty.util.internal.SystemPropertyUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dsa.iot.dslink.connection.MessageTracker;
import org.dsa.iot.dslink.connection.NetworkClient;
import org.dsa.iot.dslink.util.Objects;
import org.dsa.iot.dslink.util.json.EncodingFormat;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedWriteManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueuedWriteManager.class);
    private static final int DISPATCH_DELAY;
    private final Map<Integer, JsonObject> mergedTasks = new HashMap<Integer, JsonObject>();
    private final List<JsonObject> rawTasks = new LinkedList<JsonObject>();
    private final EncodingFormat format;
    private final MessageTracker tracker;
    private final NetworkClient client;
    private final String topName;
    private ScheduledFuture<?> fut;

    public QueuedWriteManager(NetworkClient client, MessageTracker tracker, EncodingFormat format, String topName) {
        if (client == null) {
            throw new NullPointerException("client");
        }
        if (tracker == null) {
            throw new NullPointerException("tracker");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (topName == null) {
            throw new NullPointerException("topName");
        }
        this.format = format;
        this.tracker = tracker;
        this.topName = topName;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean post(JsonObject content, boolean merge) {
        while (this.shouldBlock()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        QueuedWriteManager e = this;
        synchronized (e) {
            if (this.shouldQueue()) {
                this.addTask(content, merge);
                this.schedule();
                return false;
            }
        }
        JsonArray updates = new JsonArray();
        updates.add(content);
        JsonObject top = new JsonObject();
        top.put(this.topName, updates);
        this.forceWrite(top);
        return true;
    }

    private synchronized void addTask(JsonObject content, boolean merge) {
        if (merge) {
            int rid = (Integer)content.get("rid");
            JsonObject obj = this.mergedTasks.get(rid);
            if (obj == null) {
                this.mergedTasks.put(rid, content);
            } else {
                JsonArray oldUpdates = (JsonArray)obj.get("updates");
                if (oldUpdates != null) {
                    JsonArray newUpdates = (JsonArray)content.remove("updates");
                    if (newUpdates != null) {
                        for (Object update : newUpdates) {
                            if (update instanceof JsonArray || update instanceof JsonObject) {
                                oldUpdates.add(update);
                                continue;
                            }
                            String clazz = update.getClass().getName();
                            String err = "Unhandled type: " + clazz;
                            throw new RuntimeException(err);
                        }
                    }
                    obj.mergeIn(content);
                } else {
                    obj.mergeIn(content);
                }
            }
        } else {
            this.rawTasks.add(content);
        }
    }

    private synchronized void schedule() {
        if (this.fut != null) {
            return;
        }
        this.fut = Objects.getDaemonThreadPool().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean schedule = false;
                QueuedWriteManager queuedWriteManager = QueuedWriteManager.this;
                synchronized (queuedWriteManager) {
                    QueuedWriteManager.this.fut = null;
                    if (QueuedWriteManager.this.shouldQueue()) {
                        schedule = true;
                    } else {
                        if (QueuedWriteManager.this.rawTasks.isEmpty() && QueuedWriteManager.this.mergedTasks.isEmpty()) {
                            return;
                        }
                        JsonArray updates = new JsonArray();
                        Iterator<Object> it = QueuedWriteManager.this.mergedTasks.values().iterator();
                        while (it.hasNext()) {
                            updates.add(it.next());
                            it.remove();
                        }
                        it = QueuedWriteManager.this.rawTasks.iterator();
                        while (it.hasNext()) {
                            updates.add(it.next());
                            it.remove();
                        }
                        JsonObject top = new JsonObject();
                        top.put(QueuedWriteManager.this.topName, updates);
                        QueuedWriteManager.this.forceWrite(top);
                    }
                    if (schedule) {
                        QueuedWriteManager.this.schedule();
                    }
                }
            }
        }, (long)DISPATCH_DELAY, TimeUnit.MILLISECONDS);
    }

    private synchronized boolean shouldBlock() {
        return this.mergedTasks.size() + this.rawTasks.size() > 100000;
    }

    private synchronized boolean shouldQueue() {
        return !this.client.writable() || this.tracker.missingAckCount() > 8 || this.fut != null;
    }

    private synchronized void forceWrite(JsonObject obj) {
        obj.put("msg", this.tracker.incrementMessageId());
        this.client.write(this.format, obj);
    }

    static {
        String s = "dslink.dispatchDelay";
        DISPATCH_DELAY = SystemPropertyUtil.getInt((String)s, (int)75);
        LOGGER.debug("-D{}: {}", (Object)s, (Object)DISPATCH_DELAY);
    }
}

