/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.connection;

import io.netty.util.CharsetUtil;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.dsa.iot.dslink.connection.NetworkClient;
import org.dsa.iot.dslink.connection.NetworkHandlers;
import org.dsa.iot.dslink.handshake.LocalHandshake;
import org.dsa.iot.dslink.handshake.RemoteHandshake;
import org.dsa.iot.dslink.util.URLInfo;
import org.dsa.iot.dslink.util.UrlBase64;
import org.dsa.iot.dslink.util.json.EncodingFormat;

public abstract class RemoteEndpoint
extends NetworkHandlers
implements NetworkClient {
    private LocalHandshake localHandshake;
    private RemoteHandshake remoteHandshake;
    private URLInfo endpoint;

    public abstract void start();

    public void setLocalHandshake(LocalHandshake handshake) {
        this.localHandshake = handshake;
    }

    public LocalHandshake getLocalHandshake() {
        return this.localHandshake;
    }

    public void setRemoteHandshake(RemoteHandshake handshake) {
        this.remoteHandshake = handshake;
    }

    public RemoteHandshake getRemoteHandshake() {
        return this.remoteHandshake;
    }

    public void setEndpoint(URLInfo endpoint) {
        this.endpoint = endpoint;
    }

    public URLInfo getEndpoint() {
        return this.endpoint;
    }

    public EncodingFormat getFormat() {
        return this.remoteHandshake.getFormat();
    }

    public String getUri() {
        RemoteHandshake handshake = this.getRemoteHandshake();
        String uri = handshake.getWsUri() + "?auth=";
        String s = handshake.getSalt();
        if (s != null) {
            byte[] salt = handshake.getSalt().getBytes(CharsetUtil.UTF_8);
            byte[] sharedSecret = handshake.getRemoteKey().getSharedSecret();
            byte[] bytes = new byte[salt.length + sharedSecret.length];
            System.arraycopy(salt, 0, bytes, 0, salt.length);
            System.arraycopy(sharedSecret, 0, bytes, salt.length, sharedSecret.length);
            SHA256.Digest sha = new SHA256.Digest();
            byte[] digested = sha.digest(bytes);
            uri = uri + UrlBase64.encode(digested);
        } else {
            uri = uri + "_";
        }
        String token = this.getLocalHandshake().getToken();
        if (token != null) {
            uri = uri + "&token=" + token;
        }
        uri = uri + "&format=" + handshake.getFormat().toJson();
        uri = uri + "&dsId=" + this.getLocalHandshake().getDsId();
        return uri;
    }
}

