/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.connection.connector;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dsa.iot.dslink.connection.NetworkClient;
import org.dsa.iot.dslink.connection.RemoteEndpoint;
import org.dsa.iot.dslink.provider.WsProvider;
import org.dsa.iot.dslink.util.Objects;
import org.dsa.iot.dslink.util.URLInfo;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.http.WsClient;
import org.dsa.iot.dslink.util.json.EncodingFormat;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnector
extends RemoteEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketConnector.class);
    private ScheduledFuture<?> pingHandler;
    private NetworkClient writer;
    private long lastSentMessage;

    @Override
    public void start() {
        URLInfo endpoint = this.getEndpoint();
        endpoint = new URLInfo(endpoint.protocol, endpoint.host, endpoint.port, this.getUri(), endpoint.secure);
        WsProvider.getProvider().connect(new WsHandler(endpoint));
    }

    @Override
    public void close() {
        if (this.pingHandler != null) {
            try {
                this.pingHandler.cancel(false);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.pingHandler = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.writer = null;
        }
    }

    @Override
    public boolean writable() {
        return this.isConnected() && this.writer.writable();
    }

    @Override
    public void write(EncodingFormat format, JsonObject data) {
        this.checkConnected();
        this.writer.write(format, data);
        if (LOGGER.isDebugEnabled()) {
            String s = format.toJson();
            LOGGER.debug("Sent data ({}): {}", (Object)s, (Object)data);
        }
        this.lastSentMessage = System.currentTimeMillis();
    }

    @Override
    public boolean isConnected() {
        if (this.writer != null) {
            if (this.writer.isConnected()) {
                return true;
            }
            this.close();
            this.getOnDisconnected().handle(null);
        }
        return false;
    }

    private void setupPingHandler() {
        if (this.pingHandler != null) {
            this.pingHandler.cancel(false);
        }
        this.pingHandler = Objects.getDaemonThreadPool().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - WebSocketConnector.this.lastSentMessage >= 29000L) {
                    try {
                        WebSocketConnector.this.write(WebSocketConnector.this.getFormat(), new JsonObject());
                        LOGGER.debug("Sent ping");
                    }
                    catch (Exception e) {
                        WebSocketConnector.this.close();
                    }
                }
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private void checkConnected() {
        if (!this.isConnected()) {
            throw new RuntimeException("Cannot write to unconnected connection");
        }
    }

    private class WsHandler
    extends WsClient {
        public WsHandler(URLInfo url) {
            super(url);
        }

        @Override
        public void onData(byte[] data, int offset, int length) {
            JsonObject obj = new JsonObject(WebSocketConnector.this.getFormat(), data, offset, length);
            if (obj.contains("ping")) {
                obj.put("pong", obj.remove("ping"));
                WebSocketConnector.this.write(WebSocketConnector.this.getFormat(), obj);
                if (LOGGER.isDebugEnabled()) {
                    String s = "Received ping, sending pong";
                    LOGGER.debug(s);
                }
                return;
            }
            Handler h = WebSocketConnector.this.getOnData();
            if (h != null) {
                h.handle(obj);
            }
        }

        @Override
        public void onConnected(NetworkClient writer) {
            WebSocketConnector.this.writer = writer;
            WebSocketConnector.this.setupPingHandler();
            Handler onConnected = WebSocketConnector.this.getOnConnected();
            if (onConnected != null) {
                onConnected.handle(null);
            }
        }

        @Override
        public void onDisconnected() {
            WebSocketConnector.this.isConnected();
        }

        @Override
        public void onThrowable(Throwable throwable) {
            LOGGER.error("", throwable);
            this.onDisconnected();
        }
    }
}

