/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.handshake;

import io.netty.util.CharsetUtil;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.dsa.iot.dslink.config.Configuration;
import org.dsa.iot.dslink.handshake.LocalKeys;
import org.dsa.iot.dslink.util.StringUtils;
import org.dsa.iot.dslink.util.UrlBase64;
import org.dsa.iot.dslink.util.json.JsonObject;

public class LocalHandshake {
    private final LocalKeys keys;
    private final String publicKey;
    private final String dsId;
    private final boolean isRequester;
    private final boolean isResponder;
    private final JsonObject linkData;
    private final String zone;
    private final String token;

    public LocalHandshake(Configuration config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        config.validate();
        this.keys = config.getKeys();
        this.publicKey = this.keys.encodedPublicKey();
        String tmp = config.getDsIdWithHash();
        tmp = StringUtils.encodeName(tmp);
        this.dsId = tmp = tmp.replaceAll("%", "%25");
        this.isRequester = config.isRequester();
        this.isResponder = config.isResponder();
        this.linkData = config.getLinkData();
        this.zone = config.getZone();
        String token = config.getToken();
        if (token != null) {
            byte[] dsId = this.dsId.getBytes(CharsetUtil.UTF_8);
            byte[] fullToken = token.getBytes(CharsetUtil.UTF_8);
            byte[] bytes = new byte[dsId.length + fullToken.length];
            System.arraycopy(dsId, 0, bytes, 0, dsId.length);
            System.arraycopy(fullToken, 0, bytes, dsId.length, fullToken.length);
            SHA256.Digest sha = new SHA256.Digest();
            byte[] digested = sha.digest(bytes);
            String hash = UrlBase64.encode(digested);
            token = token.substring(0, 16) + hash;
        }
        this.token = token;
    }

    public LocalKeys getKeys() {
        return this.keys;
    }

    public String getToken() {
        return this.token;
    }

    public String getDsId() {
        return this.dsId;
    }

    public boolean isRequester() {
        return this.isRequester;
    }

    public boolean isResponder() {
        return this.isResponder;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.put("publicKey", this.publicKey);
        if (this.zone != null) {
            obj.put("zone", this.zone);
        }
        obj.put("isRequester", this.isRequester);
        obj.put("isResponder", this.isResponder);
        obj.put("linkData", this.linkData);
        obj.put("version", "1.0.4");
        return obj;
    }
}

