/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.handshake;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.dsa.iot.dslink.util.FileUtils;
import org.dsa.iot.dslink.util.UrlBase64;

public class LocalKeys {
    private static final String EC_CURVE = "SECP256R1";
    private final BCECPrivateKey privateKey;
    private final BCECPublicKey publicKey;
    private String encodedPublicKey;
    private String hashedPublicKey;

    LocalKeys(BCECPrivateKey privKey, BCECPublicKey pubKey) {
        this.privateKey = privKey;
        this.publicKey = pubKey;
    }

    public BCECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public BCECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public String encodedHashPublicKey() {
        if (this.hashedPublicKey != null) {
            return this.hashedPublicKey;
        }
        SHA256.Digest sha = new SHA256.Digest();
        byte[] encodedQ = this.publicKey.getQ().getEncoded(false);
        byte[] digested = sha.digest(encodedQ);
        this.hashedPublicKey = UrlBase64.encode(digested);
        return this.hashedPublicKey;
    }

    public String encodedPublicKey() {
        if (this.encodedPublicKey != null) {
            return this.encodedPublicKey;
        }
        byte[] encodedQ = this.publicKey.getQ().getEncoded(false);
        this.encodedPublicKey = UrlBase64.encode(encodedQ);
        return this.encodedPublicKey;
    }

    public String serialize() {
        BigInteger D = this.privateKey.getD();
        String encodedD = UrlBase64.encode(D.toByteArray());
        ECPoint point = this.publicKey.getQ();
        byte[] encodedPoint = point.getEncoded(false);
        String encodedQ = UrlBase64.encode(encodedPoint);
        return encodedD + " " + encodedQ;
    }

    public int hashCode() {
        int result = this.privateKey.getD().hashCode();
        byte[] encodedQ = this.publicKey.getQ().getEncoded(false);
        result = 31 * result + Arrays.hashCode(encodedQ);
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof LocalKeys) {
            LocalKeys other = (LocalKeys)o;
            byte[] localQ = this.publicKey.getQ().getEncoded(false);
            byte[] otherQ = other.publicKey.getQ().getEncoded(false);
            if (this.privateKey.getD().equals(other.privateKey.getD()) && Arrays.equals(localQ, otherQ)) {
                return true;
            }
        }
        return false;
    }

    public static LocalKeys getFromFileSystem(File file) {
        try {
            if (!file.exists()) {
                LocalKeys generated = LocalKeys.generate();
                FileUtils.write(file, generated.serialize().getBytes("UTF-8"));
                return generated;
            }
            byte[] bytes = FileUtils.readAllBytes(file);
            String serialized = new String(bytes, "UTF-8");
            return LocalKeys.deserialize(serialized);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static LocalKeys generate() {
        try {
            KeyPairGeneratorSpi.ECDH gen = new KeyPairGeneratorSpi.ECDH();
            ECGenParameterSpec spec = new ECGenParameterSpec(EC_CURVE);
            gen.initialize((AlgorithmParameterSpec)spec);
            KeyPair pair = gen.generateKeyPair();
            BCECPrivateKey privKey = (BCECPrivateKey)pair.getPrivate();
            BCECPublicKey publicKey = (BCECPublicKey)pair.getPublic();
            return new LocalKeys(privKey, publicKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LocalKeys deserialize(String serialized) {
        if (serialized == null) {
            throw new NullPointerException("serialized");
        }
        String[] split = serialized.split(" ");
        if (split.length != 2) {
            throw new RuntimeException("Serialized data is invalid");
        }
        ECDomainParameters params = LocalKeys.getParams();
        ProviderConfiguration conf = BouncyCastleProvider.CONFIGURATION;
        byte[] decodedQ = UrlBase64.decode(split[1]);
        ECPoint point = params.getCurve().decodePoint(decodedQ);
        ECPublicKeyParameters pubParams = new ECPublicKeyParameters(point, params);
        BCECPublicKey pubKey = new BCECPublicKey(EC_CURVE, pubParams, conf);
        BigInteger D = new BigInteger(UrlBase64.decode(split[0]));
        ECPrivateKeyParameters privParams = new ECPrivateKeyParameters(D, params);
        ECParameterSpec spec = LocalKeys.getParamSpec();
        BCECPrivateKey privKey = new BCECPrivateKey(EC_CURVE, privParams, pubKey, spec, conf);
        return new LocalKeys(privKey, pubKey);
    }

    private static ECDomainParameters getParams() {
        X9ECParameters ecp = SECNamedCurves.getByName((String)EC_CURVE);
        ECCurve curve = ecp.getCurve();
        ECPoint g = ecp.getG();
        BigInteger n = ecp.getN();
        BigInteger h = ecp.getH();
        byte[] s = ecp.getSeed();
        return new ECDomainParameters(curve, g, n, h, s);
    }

    private static ECParameterSpec getParamSpec() {
        ECDomainParameters params = LocalKeys.getParams();
        ECCurve curve = params.getCurve();
        ECPoint g = params.getG();
        BigInteger n = params.getN();
        BigInteger h = params.getH();
        byte[] s = params.getSeed();
        return new ECNamedCurveSpec(EC_CURVE, curve, g, n, h, s);
    }
}

