/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.handshake;

import io.netty.handler.codec.http.HttpResponseStatus;
import org.dsa.iot.dslink.handshake.LocalHandshake;
import org.dsa.iot.dslink.handshake.LocalKeys;
import org.dsa.iot.dslink.handshake.RemoteKey;
import org.dsa.iot.dslink.util.URLInfo;
import org.dsa.iot.dslink.util.http.HttpClient;
import org.dsa.iot.dslink.util.http.HttpResp;
import org.dsa.iot.dslink.util.json.EncodingFormat;
import org.dsa.iot.dslink.util.json.JsonObject;

public class RemoteHandshake {
    private final RemoteKey remoteKey;
    private final String wsUri;
    private final String salt;
    private final String path;
    private final EncodingFormat format;

    public RemoteHandshake(LocalKeys keys, JsonObject in) {
        String tempKey = (String)in.get("tempKey");
        this.remoteKey = tempKey != null ? RemoteKey.generate(keys, tempKey) : null;
        this.wsUri = (String)in.get("wsUri");
        this.salt = (String)in.get("salt");
        this.path = (String)in.get("path");
        this.format = EncodingFormat.toEnum((String)in.get("format"));
    }

    public RemoteKey getRemoteKey() {
        return this.remoteKey;
    }

    public String getWsUri() {
        return this.wsUri;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getPath() {
        return this.path;
    }

    public EncodingFormat getFormat() {
        return this.format;
    }

    public static RemoteHandshake generate(LocalHandshake lh, URLInfo url) {
        byte[] content;
        HttpResp resp;
        HttpResponseStatus status;
        if (url == null) {
            throw new NullPointerException("url");
        }
        HttpClient client = new HttpClient(url);
        String fullPath = url.path + "?dsId=" + lh.getDsId();
        String token = lh.getToken();
        if (token != null) {
            fullPath = fullPath + "&token=" + token;
        }
        if ((status = (resp = client.post(fullPath, content = lh.toJson().encode())).getStatus()).code() != HttpResponseStatus.OK.code()) {
            throw new RuntimeException("Bad status: " + status);
        }
        JsonObject o = new JsonObject(resp.getBody());
        LocalKeys k = lh.getKeys();
        return new RemoteHandshake(k, o);
    }
}

