/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.handshake;

import java.math.BigInteger;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.dsa.iot.dslink.handshake.LocalKeys;
import org.dsa.iot.dslink.util.UrlBase64;

public class RemoteKey {
    private final byte[] sharedSecret;

    private RemoteKey(byte[] sharedSecret) {
        this.sharedSecret = (byte[])sharedSecret.clone();
    }

    public byte[] getSharedSecret() {
        return (byte[])this.sharedSecret.clone();
    }

    public static RemoteKey generate(LocalKeys keys, String tempKey) {
        byte[] decoded = UrlBase64.decode(tempKey);
        ECParameterSpec params = keys.getPrivateKey().getParameters();
        ECPoint point = params.getCurve().decodePoint(decoded);
        ECPublicKeySpec spec = new ECPublicKeySpec(point, params);
        point = spec.getQ().multiply(keys.getPrivateKey().getD());
        BigInteger bi = point.normalize().getXCoord().toBigInteger();
        byte[] sharedSecret = bi.toByteArray();
        sharedSecret = RemoteKey.normalize(sharedSecret);
        return new RemoteKey(sharedSecret);
    }

    public static byte[] normalize(byte[] sharedSecret) {
        if (sharedSecret.length < 32) {
            byte[] fixed = new byte[32];
            int len = sharedSecret.length;
            System.arraycopy(sharedSecret, 0, fixed, 32 - len, len);
            sharedSecret = fixed;
        } else if (sharedSecret.length > 32) {
            byte[] fixed = new byte[32];
            System.arraycopy(sharedSecret, sharedSecret.length - 32, fixed, 0, fixed.length);
            sharedSecret = fixed;
        }
        return sharedSecret;
    }
}

