/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.link;

import java.lang.ref.WeakReference;
import java.util.Map;
import org.dsa.iot.dslink.DSLink;
import org.dsa.iot.dslink.DSLinkHandler;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.SubscriptionManager;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.serializer.SerializationManager;

public abstract class Linkable {
    private final DSLinkHandler handler;
    private WeakReference<DSLink> link;

    public Linkable(DSLinkHandler handler) {
        this.handler = handler;
    }

    public abstract void batchSet(Map<Node, Value> var1);

    public SubscriptionManager getSubscriptionManager() {
        DSLink dsLink = this.getDSLink();
        if (dsLink != null) {
            return dsLink.getSubscriptionManager();
        }
        return null;
    }

    public SerializationManager getSerialManager() {
        DSLink dslink = this.getDSLink();
        if (dslink != null) {
            return dslink.getSerialManager();
        }
        return null;
    }

    public DSLinkHandler getHandler() {
        return this.handler;
    }

    public void setDSLink(DSLink link) {
        if (link == null) {
            throw new NullPointerException("link");
        }
        this.link = new WeakReference<DSLink>(link);
    }

    public DSLink getDSLink() {
        return (DSLink)this.link.get();
    }
}

