/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.link;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.dsa.iot.dslink.DSLink;
import org.dsa.iot.dslink.DSLinkHandler;
import org.dsa.iot.dslink.link.Linkable;
import org.dsa.iot.dslink.methods.Request;
import org.dsa.iot.dslink.methods.StreamState;
import org.dsa.iot.dslink.methods.requests.CloseRequest;
import org.dsa.iot.dslink.methods.requests.ContinuousInvokeRequest;
import org.dsa.iot.dslink.methods.requests.InvokeRequest;
import org.dsa.iot.dslink.methods.requests.ListRequest;
import org.dsa.iot.dslink.methods.requests.RemoveRequest;
import org.dsa.iot.dslink.methods.requests.SetRequest;
import org.dsa.iot.dslink.methods.requests.SubscribeRequest;
import org.dsa.iot.dslink.methods.requests.UnsubscribeRequest;
import org.dsa.iot.dslink.methods.responses.CloseResponse;
import org.dsa.iot.dslink.methods.responses.ErrorResponse;
import org.dsa.iot.dslink.methods.responses.InvokeResponse;
import org.dsa.iot.dslink.methods.responses.ListResponse;
import org.dsa.iot.dslink.methods.responses.RemoveResponse;
import org.dsa.iot.dslink.methods.responses.SetResponse;
import org.dsa.iot.dslink.methods.responses.SubscribeResponse;
import org.dsa.iot.dslink.methods.responses.SubscriptionUpdate;
import org.dsa.iot.dslink.methods.responses.UnsubscribeResponse;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.NodeManager;
import org.dsa.iot.dslink.node.NodePair;
import org.dsa.iot.dslink.node.SubscriptionManager;
import org.dsa.iot.dslink.node.value.SubscriptionValue;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.util.Objects;
import org.dsa.iot.dslink.util.SubData;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.JsonObject;

public class Requester
extends Linkable {
    private final Map<Integer, RequestWrapper> reqs;
    private final AtomicInteger currentReqID = new AtomicInteger();
    private final AtomicInteger currentSubID = new AtomicInteger();
    private final Map<String, Integer> subPaths = new ConcurrentHashMap<String, Integer>();
    private final Map<Integer, String> subSids = new ConcurrentHashMap<Integer, String>();
    private final Map<Integer, Handler<SubscriptionValue>> subUpdates = new ConcurrentHashMap<Integer, Handler<SubscriptionValue>>();
    private final Map<Integer, InvokeResponse> invokeResponses = new HashMap<Integer, InvokeResponse>();

    public Requester(DSLinkHandler handler) {
        super(handler);
        this.reqs = new ConcurrentHashMap<Integer, RequestWrapper>();
    }

    @Override
    public void batchSet(Map<Node, Value> updates) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Integer> getSubscriptionPaths() {
        return Collections.unmodifiableMap(this.subPaths);
    }

    public Map<Integer, String> getSubscriptionIDs() {
        return Collections.unmodifiableMap(this.subSids);
    }

    public boolean isSubscribed(String path) {
        return this.subPaths.containsKey(path);
    }

    public Map<Integer, Handler<SubscriptionValue>> getSubscriptionHandlers() {
        return Collections.unmodifiableMap(this.subUpdates);
    }

    public void subscribe(String path, Handler<SubscriptionValue> onUpdate) {
        SubData sub = new SubData(path, null);
        this.subscribe(sub, onUpdate);
    }

    public void subscribe(SubData path, Handler<SubscriptionValue> onUpdate) {
        this.subscribe(Collections.singleton(path), onUpdate);
    }

    public void subscribe(Set<SubData> paths, Handler<SubscriptionValue> onUpdate) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        this.subscribe(new SubscribeRequest(paths), onUpdate);
    }

    public void subscribe(SubscribeRequest req, Handler<SubscriptionValue> onUpdate) {
        if (req == null) {
            throw new NullPointerException("req");
        }
        Set<SubData> paths = req.getPaths();
        HashMap<SubData, Integer> subs = new HashMap<SubData, Integer>();
        int min = this.currentSubID.getAndAdd(paths.size());
        int max = min + paths.size();
        Iterator<SubData> it = paths.iterator();
        StringBuilder error = null;
        while (min < max && it.hasNext()) {
            try {
                SubData data = it.next();
                String path = data.getPath();
                subs.put(data, min);
                Integer prev = this.subPaths.put(path, min);
                if (prev != null) {
                    String err = "Path " + path + " already subscribed";
                    throw new RuntimeException(err);
                }
                this.subSids.put(min, path);
                if (onUpdate != null) {
                    this.subUpdates.put(min, onUpdate);
                }
                ++min;
            }
            catch (IllegalArgumentException e) {
                if (error == null) {
                    error = new StringBuilder();
                }
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                error.append(writer.toString());
                error.append("\n\n");
            }
        }
        req.setSubSids(subs);
        RequestWrapper wrapper = new RequestWrapper(req);
        this.sendRequest(wrapper, this.currentReqID.incrementAndGet());
        if (error != null) {
            throw new RuntimeException(error.toString());
        }
    }

    public void unsubscribe(String path, Handler<UnsubscribeResponse> onResponse) {
        HashSet<String> paths = new HashSet<String>();
        paths.add(path);
        this.unsubscribe(paths, onResponse);
    }

    public void unsubscribe(Set<String> paths, Handler<UnsubscribeResponse> onResponse) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        ArrayList<Integer> subs = new ArrayList<Integer>();
        for (String path : paths) {
            Integer sid = this.subPaths.remove(path = NodeManager.normalizePath(path, true));
            if (sid == null) continue;
            subs.add(sid);
            this.subSids.remove(sid);
            this.subUpdates.remove(sid);
        }
        UnsubscribeRequest req = new UnsubscribeRequest(subs);
        RequestWrapper wrapper = new RequestWrapper(req);
        wrapper.unsubHandler = onResponse;
        this.sendRequest(wrapper, this.currentReqID.incrementAndGet());
    }

    public void closeStream(int rid, Handler<CloseResponse> onResponse) {
        CloseRequest req = new CloseRequest();
        RequestWrapper wrapper = new RequestWrapper(req);
        this.sendRequest(wrapper, rid);
        this.reqs.remove(rid);
        if (onResponse != null) {
            onResponse.handle(new CloseResponse(rid, null));
        }
    }

    public int invoke(InvokeRequest request, Handler<InvokeResponse> onResponse) {
        RequestWrapper wrapper = new RequestWrapper(request);
        wrapper.invokeHandler = onResponse;
        return this.sendRequest(wrapper);
    }

    public void continuousInvoke(int rid, JsonObject params) {
        ContinuousInvokeRequest req = new ContinuousInvokeRequest(params);
        RequestWrapper wrapper = new RequestWrapper(req);
        this.sendRequest(wrapper, rid, false);
    }

    public int list(ListRequest request, Handler<ListResponse> onResponse) {
        RequestWrapper wrapper = new RequestWrapper(request);
        wrapper.listHandler = onResponse;
        return this.sendRequest(wrapper);
    }

    public void set(SetRequest request, Handler<SetResponse> onResponse) {
        RequestWrapper wrapper = new RequestWrapper(request);
        wrapper.setHandler = onResponse;
        this.sendRequest(wrapper);
    }

    public void remove(RemoveRequest request, Handler<RemoveResponse> onResponse) {
        RequestWrapper wrapper = new RequestWrapper(request);
        wrapper.removeHandler = onResponse;
        this.sendRequest(wrapper);
    }

    private int sendRequest(RequestWrapper wrapper) {
        int rid = this.currentReqID.incrementAndGet();
        this.sendRequest(wrapper, rid);
        return rid;
    }

    private void sendRequest(RequestWrapper wrapper, int rid) {
        this.sendRequest(wrapper, rid, true);
    }

    private void sendRequest(RequestWrapper wrapper, int rid, boolean merge) {
        String name;
        DSLink link = this.getDSLink();
        if (link == null) {
            return;
        }
        Request request = wrapper.request;
        JsonObject obj = new JsonObject();
        request.addJsonValues(obj);
        obj.put("rid", rid);
        if (wrapper.shouldStore()) {
            this.reqs.put(rid, wrapper);
        }
        if ((name = request.getName()) != null) {
            obj.put("method", request.getName());
        }
        link.getWriter().writeRequest(obj, merge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(final JsonObject in) {
        ErrorResponse error;
        JsonObject e;
        DSLink link = this.getDSLink();
        if (link == null) {
            return;
        }
        int rid = (Integer)in.get("rid");
        if (rid == 0) {
            final SubscriptionUpdate update = new SubscriptionUpdate(this);
            Objects.getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    update.populate(in);
                }
            });
            return;
        }
        RequestWrapper wrapper = this.reqs.get(rid);
        if (wrapper == null) {
            return;
        }
        Request request = wrapper.request;
        String method = request.getName();
        StreamState stream = StreamState.toEnum((String)in.get("stream"));
        if (stream == null) {
            stream = StreamState.OPEN;
        }
        if ((e = (JsonObject)in.get("error")) != null) {
            String msg = (String)e.get("msg");
            String detail = (String)e.get("detail");
            error = new ErrorResponse(msg, detail);
        } else {
            error = null;
        }
        NodeManager manager = link.getNodeManager();
        boolean closed = StreamState.CLOSED == stream;
        switch (method) {
            case "list": {
                ListRequest listRequest = (ListRequest)request;
                Node node = manager.getNode(listRequest.getPath(), true).getNode();
                String path = node.getPath();
                SubscriptionManager subs = link.getSubscriptionManager();
                ListResponse listResp = new ListResponse(link, subs, rid, node, path);
                listResp.setError(error);
                listResp.populate(in);
                if (wrapper.listHandler == null) break;
                wrapper.listHandler.handle(listResp);
                break;
            }
            case "set": {
                SetRequest setRequest = (SetRequest)request;
                String path = setRequest.getPath();
                manager.getNode(path, true);
                SetResponse setResponse = new SetResponse(rid, link, path);
                setResponse.setError(error);
                setResponse.populate(in);
                if (wrapper.setHandler == null) break;
                wrapper.setHandler.handle(setResponse);
                break;
            }
            case "remove": {
                RemoveRequest removeRequest = (RemoveRequest)request;
                NodePair pair = manager.getNode(removeRequest.getPath(), true);
                RemoveResponse removeResponse = new RemoveResponse(rid, pair);
                removeResponse.setError(error);
                removeResponse.populate(in);
                if (wrapper.removeHandler == null) break;
                wrapper.removeHandler.handle(removeResponse);
                break;
            }
            case "close": {
                closed = true;
                break;
            }
            case "subscribe": {
                SubscribeResponse subResp = new SubscribeResponse(rid, link);
                subResp.setError(error);
                subResp.populate(in);
                break;
            }
            case "unsubscribe": {
                UnsubscribeResponse unsubResp = new UnsubscribeResponse(rid, link);
                unsubResp.setError(error);
                unsubResp.populate(in);
                if (wrapper.unsubHandler == null) break;
                wrapper.unsubHandler.handle(unsubResp);
                break;
            }
            case "invoke": {
                InvokeResponse inResp;
                InvokeRequest inReq = (InvokeRequest)request;
                String path = inReq.getPath();
                manager.getNode(path, true);
                Map<Integer, InvokeResponse> map = this.invokeResponses;
                synchronized (map) {
                    switch (stream) {
                        case OPEN: {
                            inResp = this.invokeResponses.get(rid);
                            break;
                        }
                        case INITIALIZED: {
                            inResp = new InvokeResponse(link, rid, path);
                            this.invokeResponses.put(rid, inResp);
                            break;
                        }
                        case CLOSED: {
                            inResp = this.invokeResponses.remove(rid);
                            break;
                        }
                        default: {
                            inResp = null;
                        }
                    }
                    if (inResp == null) {
                        inResp = new InvokeResponse(link, rid, path);
                    }
                }
                inResp.setStreamState(stream);
                inResp.setError(error);
                inResp.populate(in);
                boolean invoke = false;
                if (inReq.waitForStreamClose()) {
                    if (closed) {
                        invoke = true;
                    }
                } else {
                    invoke = true;
                }
                if (!invoke || wrapper.invokeHandler == null) break;
                wrapper.invokeHandler.handle(inResp);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported method: " + method);
            }
        }
        if (closed) {
            this.reqs.remove(rid);
        }
    }

    public void clearSubscriptions() {
        this.subPaths.clear();
        this.subSids.clear();
        this.subUpdates.clear();
        this.invokeResponses.clear();
    }

    private static class RequestWrapper {
        private final Request request;
        private Handler<InvokeResponse> invokeHandler;
        private Handler<ListResponse> listHandler;
        private Handler<RemoveResponse> removeHandler;
        private Handler<SetResponse> setHandler;
        private Handler<UnsubscribeResponse> unsubHandler;

        public RequestWrapper(Request request) {
            this.request = request;
        }

        public boolean shouldStore() {
            return this.invokeHandler != null || this.listHandler != null || this.removeHandler != null || this.setHandler != null || this.unsubHandler != null;
        }
    }
}

