/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.methods.requests;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.dsa.iot.dslink.methods.Request;
import org.dsa.iot.dslink.util.SubData;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;

public class SubscribeRequest
extends Request {
    private Map<SubData, Integer> subSids;
    private final Set<SubData> paths;

    public SubscribeRequest(Set<SubData> paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        this.paths = paths;
    }

    public Set<SubData> getPaths() {
        return Collections.unmodifiableSet(this.paths);
    }

    public void setSubSids(Map<SubData, Integer> sids) {
        this.subSids = sids;
    }

    @Override
    public String getName() {
        return "subscribe";
    }

    @Override
    public void addJsonValues(JsonObject out) {
        JsonArray array = new JsonArray();
        for (Map.Entry<SubData, Integer> sub : this.subSids.entrySet()) {
            SubData data = sub.getKey();
            String path = data.getPath();
            Integer qos = data.getQos();
            JsonObject obj = new JsonObject();
            obj.put("path", path);
            obj.put("sid", sub.getValue());
            if (qos != null) {
                obj.put("qos", qos);
            }
            array.add(obj);
        }
        out.put("paths", array);
    }
}

