/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.methods.responses;

import java.util.List;
import org.dsa.iot.dslink.DSLink;
import org.dsa.iot.dslink.DSLinkHandler;
import org.dsa.iot.dslink.connection.DataHandler;
import org.dsa.iot.dslink.link.Responder;
import org.dsa.iot.dslink.methods.Response;
import org.dsa.iot.dslink.methods.StreamState;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.NodeManager;
import org.dsa.iot.dslink.node.actions.Action;
import org.dsa.iot.dslink.node.actions.ActionResult;
import org.dsa.iot.dslink.node.actions.Parameter;
import org.dsa.iot.dslink.node.actions.table.Row;
import org.dsa.iot.dslink.node.actions.table.Table;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.node.value.ValueUtils;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;

public class InvokeResponse
extends Response {
    private final DSLink link;
    private final String path;
    private final int rid;
    private Table results;
    private ActionResult actRes;
    private StreamState state;

    public InvokeResponse(DSLink link, int rid, String path) {
        this.link = link;
        this.rid = rid;
        this.path = NodeManager.normalizePath(path, false);
    }

    @Override
    public int getRid() {
        return this.rid;
    }

    public Table getTable() {
        return this.results;
    }

    public String getPath() {
        return this.path;
    }

    public StreamState getState() {
        return this.state;
    }

    public void invoke(JsonObject params) {
        if (this.state == StreamState.CLOSED) {
            throw new IllegalStateException("Stream already closed");
        }
        this.link.getRequester().continuousInvoke(this.getRid(), params);
    }

    public void setStreamState(StreamState state) {
        this.state = state;
    }

    @Override
    public void populate(JsonObject in) {
        JsonArray updates;
        JsonArray cols;
        if (this.results == null) {
            this.results = new Table();
        }
        if ((cols = (JsonArray)in.get("columns")) != null) {
            for (Object object : cols) {
                JsonObject col = (JsonObject)object;
                String name = (String)col.get("name");
                String type = (String)col.get("type");
                JsonObject meta = (JsonObject)col.get("meta");
                ValueType vt = ValueType.toValueType(type);
                Parameter p = new Parameter(name, vt);
                p.setMetaData(meta);
                this.results.addColumn(p);
            }
        }
        if ((updates = (JsonArray)in.get("updates")) != null) {
            for (Object object : updates) {
                Row row = new Row();
                JsonArray rowArray = (JsonArray)object;
                for (Object rowValue : rowArray) {
                    row.addValue(ValueUtils.toValue(rowValue));
                }
                this.results.addRow(row);
            }
        }
    }

    @Override
    public JsonObject getJsonResponse(JsonObject in) {
        Action action;
        NodeManager man = this.link.getNodeManager();
        Node node = man.getNode(this.path, false, false).getNode();
        if (node == null) {
            DSLinkHandler handler = this.link.getLinkHandler();
            node = handler.onInvocationFail(this.path);
        }
        if (node == null || (action = node.getAction()) == null) {
            throw new RuntimeException("Node not invokable at " + this.path);
        }
        this.actRes = new ActionResult(node, in);
        action.invoke(this.actRes);
        Table table = this.actRes.getTable();
        StreamState state = this.actRes.getStreamState();
        JsonObject out = new JsonObject();
        out.put("rid", this.rid);
        out.put("stream", state.getJsonName());
        this.processColumns(action, out);
        Table.Mode mode = table.getMode();
        if (mode != null) {
            JsonObject def = new JsonObject();
            JsonObject meta = out.get("meta", def);
            meta.put("mode", mode.getName());
            JsonObject obj = table.getTableMeta();
            if (obj != null) {
                meta.put("meta", obj);
            }
            table.setTableMeta(null);
            out.put("meta", meta);
        }
        JsonArray results = new JsonArray();
        List<Row> rows = table.getRows(true);
        if (rows != null) {
            for (Row r : rows) {
                JsonArray row = new JsonArray();
                List<Value> values = r.getValues();
                if (values != null) {
                    for (Value v : values) {
                        row.add(v);
                    }
                }
                results.add(row);
            }
            out.put("updates", results);
        }
        if (state == StreamState.CLOSED) {
            this.link.getResponder().removeResponse(this.rid);
        } else {
            Handler<Void> ch = this.actRes.getCloseHandler();
            DataHandler writer = this.link.getWriter();
            Responder resp = this.link.getResponder();
            table.setStreaming(this.rid, writer, resp, ch);
        }
        return out;
    }

    @Override
    public JsonObject getCloseResponse() {
        if (this.actRes != null) {
            Handler<Void> handler = this.actRes.getCloseHandler();
            if (handler != null) {
                handler.handle(null);
            }
            Table table = this.actRes.getTable();
            table.setClosed();
        }
        JsonObject obj = new JsonObject();
        obj.put("rid", this.rid);
        obj.put("stream", StreamState.CLOSED.getJsonName());
        return obj;
    }

    private void processColumns(Action act, JsonObject obj) {
        Table table = this.actRes.getTable();
        List<Parameter> cols = table.getColumns();
        JsonArray array = null;
        if (!act.isHidden() && cols == null) {
            array = act.getColumns();
        } else if (cols != null) {
            array = new JsonArray();
            for (Parameter p : cols) {
                JsonObject o = new JsonObject();
                o.put("name", p.getName());
                o.put("type", p.getType().toJsonString());
                JsonObject meta = p.getMetaData();
                if (meta != null) {
                    o.put("meta", meta);
                }
                array.add(o);
            }
        }
        if (cols != null) {
            obj.put("columns", array);
        }
    }
}

