/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.methods.responses;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dsa.iot.dslink.DSLink;
import org.dsa.iot.dslink.methods.Response;
import org.dsa.iot.dslink.methods.StreamState;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.NodeBuilder;
import org.dsa.iot.dslink.node.NodeListener;
import org.dsa.iot.dslink.node.Permission;
import org.dsa.iot.dslink.node.SubscriptionManager;
import org.dsa.iot.dslink.node.Writable;
import org.dsa.iot.dslink.node.actions.Action;
import org.dsa.iot.dslink.node.actions.ActionResult;
import org.dsa.iot.dslink.node.actions.EditorType;
import org.dsa.iot.dslink.node.actions.Parameter;
import org.dsa.iot.dslink.node.actions.ResultType;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.node.value.ValueUtils;
import org.dsa.iot.dslink.util.StringUtils;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;

public class ListResponse
extends Response {
    private final DSLink link;
    private final SubscriptionManager manager;
    private final int rid;
    private final Node node;
    private final String path;
    private final Map<Node, Boolean> updates = new HashMap<Node, Boolean>();

    public ListResponse(DSLink link, SubscriptionManager manager, int rid, Node node, String path) {
        if (link == null) {
            throw new NullPointerException("link");
        }
        if (manager == null) {
            throw new NullPointerException("manager");
        }
        if (rid <= 0) {
            throw new IllegalArgumentException("rid <= 0");
        }
        this.link = link;
        this.manager = manager;
        this.rid = rid;
        this.node = node;
        this.path = path;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public int getRid() {
        return this.rid;
    }

    public Map<Node, Boolean> getUpdates() {
        return this.updates;
    }

    @Override
    public void populate(JsonObject in) {
        JsonArray updates = (JsonArray)in.get("updates");
        if (updates != null) {
            for (Object obj : updates) {
                if (obj instanceof JsonObject) {
                    this.update((JsonObject)obj);
                    continue;
                }
                this.update((JsonArray)obj);
            }
        }
    }

    private void update(JsonObject in) {
        String name = (String)in.get("name");
        String change = (String)in.get("change");
        if (change != null) {
            if ("remove".equals(change)) {
                if (name.startsWith("$$")) {
                    this.node.removeRoConfig(name.substring(2));
                } else if (name.startsWith("$")) {
                    this.node.removeConfig(name.substring(1));
                } else if (name.startsWith("@")) {
                    this.node.removeAttribute(name.substring(1));
                } else {
                    Node n = this.node.removeChild(name);
                    if (n != null) {
                        this.updates.put(n, true);
                    }
                }
            }
        } else {
            throw new RuntimeException("Unhandled update: " + in);
        }
    }

    private void update(JsonArray in) {
        String name = (String)in.get(0);
        Object v = in.get(1);
        if (name.startsWith("$$")) {
            if ("password".equals(name = name.substring(2))) {
                if (v instanceof String) {
                    this.node.setPassword(((String)v).toCharArray());
                }
            } else {
                this.node.setRoConfig(name, ValueUtils.toValue(v));
            }
        } else if (name.startsWith("$")) {
            if ("is".equals(name = name.substring(1))) {
                this.node.reset();
                this.node.setProfile((String)v);
            } else if ("interface".equals(name)) {
                this.node.setInterfaces((String)v);
            } else if ("invokable".equals(name)) {
                Permission perm = Permission.toEnum((String)v);
                Action act = ListResponse.getOrCreateAction(this.node, perm);
                act.setPermission(perm);
            } else if ("params".equals(name)) {
                JsonArray array = (JsonArray)v;
                Action act = ListResponse.getOrCreateAction(this.node, Permission.NONE);
                ListResponse.iterateActionMetaData(act, array, false);
            } else if ("columns".equals(name)) {
                JsonArray array = (JsonArray)v;
                Action act = ListResponse.getOrCreateAction(this.node, Permission.NONE);
                ListResponse.iterateActionMetaData(act, array, true);
            } else if ("result".equals(name)) {
                String string = (String)v;
                Action act = ListResponse.getOrCreateAction(this.node, Permission.NONE);
                act.setResultType(ResultType.toEnum(string));
            } else if ("writable".equals(name)) {
                String string = (String)v;
                this.node.setWritable(Writable.toEnum(string));
            } else if ("type".equals(name)) {
                ValueType type = ValueType.toValueType((String)v);
                this.node.setValueType(type);
            } else if ("name".equals(name)) {
                this.node.setDisplayName((String)v);
            } else if ("hidden".equals(name)) {
                this.node.setHidden((Boolean)v);
            } else {
                this.node.setConfig(name, ValueUtils.toValue(v));
            }
        } else if (name.startsWith("@")) {
            name = name.substring(1);
            this.node.setAttribute(name, ValueUtils.toValue(v));
        } else {
            JsonObject linkData;
            Boolean hidden;
            String invokable;
            String type;
            String displayName;
            String _interface;
            JsonObject childData = (JsonObject)v;
            Node child = this.node.getChild(name);
            String change = (String)childData.get("change");
            if (change != null && "remove".equals(change)) {
                if (child != null) {
                    this.node.removeChild(child.getName());
                    this.updates.put(this.node, true);
                }
                return;
            }
            String is = (String)childData.get("$is");
            if (child == null) {
                NodeBuilder builder = this.node.createChild(name, is);
                child = builder.build();
            }
            if ((_interface = (String)childData.get("$interface")) != null) {
                child.setInterfaces(_interface);
            }
            if ((displayName = (String)childData.get("$name")) != null) {
                child.setDisplayName(displayName);
            }
            if ((type = (String)childData.get("$type")) != null) {
                ValueType t = ValueType.toValueType(type);
                child.setValueType(t);
            }
            if ((invokable = (String)childData.get("$invokable")) != null) {
                Permission perm = Permission.toEnum(invokable);
                ListResponse.getOrCreateAction(child, perm);
            }
            if ((hidden = (Boolean)childData.get("$hidden")) != null) {
                child.setHidden(hidden);
            }
            if ((linkData = (JsonObject)childData.get("$linkData")) != null) {
                Value val = new Value(linkData);
                child.setConfig("linkData", val);
            }
            this.updates.put(child, false);
        }
    }

    @Override
    public JsonObject getJsonResponse(JsonObject in) {
        JsonObject out = new JsonObject();
        out.put("rid", this.getRid());
        out.put("stream", StreamState.OPEN.getJsonName());
        JsonArray updates = new JsonArray();
        if (this.node != null) {
            Map<String, Node> children;
            JsonArray update;
            Action action;
            Writable writable;
            char[] password;
            ValueType type;
            Set<String> interfaces;
            String profile = this.node.getProfile();
            if (profile == null) {
                String err = "Profile not set on node: " + this.node.getPath();
                throw new RuntimeException(err);
            }
            JsonArray update2 = new JsonArray();
            update2.add("$is");
            update2.add(profile);
            updates.add(update2);
            String name = this.node.getDisplayName();
            if (name != null) {
                JsonArray update3 = new JsonArray();
                update3.add("$name");
                update3.add(name);
                updates.add(update3);
            }
            if ((interfaces = this.node.getInterfaces()) != null && interfaces.size() > 0) {
                JsonArray update4 = new JsonArray();
                update4.add("$interface");
                update4.add(StringUtils.join(interfaces, "|"));
                updates.add(update4);
            }
            if ((type = this.node.getValueType()) != null) {
                JsonArray update5 = new JsonArray();
                update5.add("$type");
                update5.add(type.toJsonString());
                updates.add(update5);
            }
            if ((password = this.node.getPassword()) != null) {
                JsonArray update6 = new JsonArray();
                update6.add("$$password");
                update6.add(null);
                updates.add(update6);
            }
            if ((writable = this.node.getWritable()) != null && writable != Writable.NEVER) {
                JsonArray update7 = new JsonArray();
                update7.add("$writable");
                update7.add(writable.toJsonName());
                updates.add(update7);
            }
            if ((action = this.node.getAction()) != null && action.hasPermission()) {
                JsonArray update8 = new JsonArray();
                update8.add("$invokable");
                update8.add(action.getPermission().getJsonName());
                updates.add(update8);
                if (!action.isHidden()) {
                    update8 = new JsonArray();
                    update8.add("$params");
                    update8.add(action.getParams());
                    updates.add(update8);
                    update8 = new JsonArray();
                    update8.add("$columns");
                    update8.add(action.getColumns());
                    updates.add(update8);
                    update8 = new JsonArray();
                    update8.add("$result");
                    update8.add(action.getResultType().getJsonName());
                    updates.add(update8);
                }
            }
            this.add("$$", updates, this.node.getRoConfigurations());
            this.add("$", updates, this.node.getConfigurations());
            this.add("@", updates, this.node.getAttributes());
            Boolean hasChildren = this.node.getHasChildren();
            if (hasChildren != null) {
                update = new JsonArray();
                update.add("$hasChildren");
                update.add(hasChildren);
                updates.add(update);
            }
            if (this.node.isHidden()) {
                update = new JsonArray();
                update.add("$hidden");
                update.add(true);
                updates.add(update);
            }
            if ((children = this.node.getChildren()) != null) {
                for (Node child : children.values()) {
                    Object update9 = this.getChildUpdate(child, false);
                    updates.add(update9);
                }
            }
        }
        out.put("updates", updates);
        this.manager.addPathSub(this.path, this);
        return out;
    }

    public void childUpdate(Node child, boolean removed) {
        if (removed) {
            this.manager.removePathSub(child);
        }
        JsonArray updates = new JsonArray();
        updates.add(this.getChildUpdate(child, removed));
        JsonObject resp = new JsonObject();
        resp.put("rid", this.getRid());
        resp.put("stream", StreamState.OPEN.getJsonName());
        resp.put("updates", updates);
        this.link.getWriter().writeResponse(resp);
    }

    public void metaUpdate(String name, Value value) {
        JsonArray updates = new JsonArray();
        if (value != null) {
            JsonArray update = new JsonArray();
            update.add(name);
            update.add(value);
            update.add(value.getTimeStamp());
            updates.add(update);
        } else {
            JsonObject obj = new JsonObject();
            obj.put("name", name);
            obj.put("change", "remove");
            updates.add(obj);
        }
        JsonObject resp = new JsonObject();
        resp.put("rid", this.getRid());
        resp.put("stream", StreamState.OPEN.getJsonName());
        resp.put("updates", updates);
        this.link.getWriter().writeResponse(resp);
    }

    @Override
    public JsonObject getCloseResponse() {
        NodeListener listener;
        this.manager.removePathSub(this.node);
        if (this.node != null && (listener = this.node.getListener()) != null) {
            this.node.getListener().postListClosed();
        }
        JsonObject resp = new JsonObject();
        resp.put("rid", this.getRid());
        resp.put("stream", StreamState.CLOSED.getJsonName());
        return resp;
    }

    private void add(String prefix, JsonArray out, Map<String, Value> values) {
        if (values == null) {
            return;
        }
        for (Map.Entry<String, Value> entry : values.entrySet()) {
            JsonArray update = new JsonArray();
            update.add(prefix + entry.getKey());
            update.add(entry.getValue());
            out.add(update);
        }
    }

    private Object getChildUpdate(Node child, boolean removed) {
        Boolean hasChildren;
        ValueType type;
        Set<String> interfaces;
        Action action;
        if (removed) {
            JsonObject obj = new JsonObject();
            obj.put("name", child.getName());
            obj.put("change", "remove");
            return obj;
        }
        JsonArray update = new JsonArray();
        update.add(child.getName());
        JsonObject childData = new JsonObject();
        String profile = child.getProfile();
        if (profile == null) {
            String err = "Profile not set on node: " + child.getPath();
            throw new RuntimeException(err);
        }
        childData.put("$is", profile);
        String displayName = child.getDisplayName();
        if (displayName != null) {
            childData.put("$name", displayName);
        }
        if ((action = child.getAction()) != null) {
            String perm = action.getPermission().getJsonName();
            childData.put("$invokable", perm);
            String jsonName = action.getResultType().getJsonName();
            childData.put("$result", jsonName);
        }
        if ((interfaces = child.getInterfaces()) != null) {
            String _interface = StringUtils.join(interfaces, "|");
            childData.put("$interface", _interface);
        }
        if ((type = child.getValueType()) != null) {
            childData.put("$type", type.toJsonString());
        }
        if ((hasChildren = child.getHasChildren()) != null) {
            childData.put("$hasChildren", hasChildren);
        }
        if (child.isHidden()) {
            childData.put("$hidden", true);
        }
        update.add(childData);
        return update;
    }

    private static void iterateActionMetaData(Action act, JsonArray array, boolean isCol) {
        for (Object anArray : array) {
            Object def;
            JsonObject data = (JsonObject)anArray;
            String name = (String)data.get("name");
            String type = (String)data.get("type");
            ValueType valType = ValueType.toValueType(type);
            Parameter param = new Parameter(name, valType);
            if (isCol) {
                act.addResult(param);
                continue;
            }
            String editor = (String)data.get("editor");
            if (editor != null) {
                param.setEditorType(EditorType.make(editor));
            }
            if ((def = data.get("default")) != null) {
                param.setDefaultValue(ValueUtils.toValue(def));
            }
            act.addParameter(param);
        }
    }

    private static Action getOrCreateAction(Node node, Permission perm) {
        Action action = node.getAction();
        if (action != null) {
            return action;
        }
        action = ListResponse.getRawAction(perm);
        node.setAction(action);
        return action;
    }

    private static Action getRawAction(Permission perm) {
        return new Action(perm, new Handler<ActionResult>(){

            @Override
            public void handle(ActionResult event) {
                throw new UnsupportedOperationException();
            }
        });
    }
}

