/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.methods.responses;

import org.dsa.iot.dslink.methods.Response;
import org.dsa.iot.dslink.methods.StreamState;
import org.dsa.iot.dslink.node.NodePair;
import org.dsa.iot.dslink.util.json.JsonObject;

public class RemoveResponse
extends Response {
    private final int rid;
    private final NodePair pair;

    public RemoveResponse(int rid, NodePair pair) {
        if (pair.getReference() == null) {
            String err = "path does not reference config or attribute";
            throw new NullPointerException(err);
        }
        this.rid = rid;
        this.pair = pair;
    }

    @Override
    public int getRid() {
        return this.rid;
    }

    @Override
    public void populate(JsonObject in) {
    }

    @Override
    public JsonObject getJsonResponse(JsonObject in) {
        this.removeConfig();
        JsonObject obj = new JsonObject();
        obj.put("rid", this.rid);
        obj.put("stream", StreamState.CLOSED.getJsonName());
        return obj;
    }

    @Override
    public JsonObject getCloseResponse() {
        return null;
    }

    private void removeConfig() {
        String ref = this.pair.getReference();
        if (!ref.startsWith("@")) {
            throw new RuntimeException("Unable to set reference: " + ref);
        }
        ref = ref.substring(1);
        this.pair.getNode().removeAttribute(ref);
    }
}

