/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.methods.responses;

import org.dsa.iot.dslink.DSLink;
import org.dsa.iot.dslink.DSLinkHandler;
import org.dsa.iot.dslink.methods.Response;
import org.dsa.iot.dslink.methods.StreamState;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.NodePair;
import org.dsa.iot.dslink.node.Writable;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.node.value.ValueUtils;
import org.dsa.iot.dslink.util.json.JsonObject;

public class SetResponse
extends Response {
    private final int rid;
    private final DSLink link;
    private final String path;

    public SetResponse(int rid, DSLink link, String path) {
        this.rid = rid;
        this.link = link;
        this.path = path;
    }

    @Override
    public int getRid() {
        return this.rid;
    }

    @Override
    public void populate(JsonObject in) {
    }

    @Override
    public JsonObject getJsonResponse(JsonObject in) {
        this.updateNode(in);
        JsonObject obj = new JsonObject();
        obj.put("rid", this.rid);
        obj.put("stream", StreamState.CLOSED.getJsonName());
        return obj;
    }

    @Override
    public JsonObject getCloseResponse() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateNode(JsonObject in) {
        Value value = ValueUtils.toValue(in.get("value"));
        NodePair pair = this.link.getNodeManager().getNode(this.path, false, false);
        Node node = pair.getNode();
        if (node == null) {
            DSLinkHandler handler = this.link.getLinkHandler();
            handler.onSetFail(this.path, value);
            return;
        }
        String ref = pair.getReference();
        if (ref != null) {
            if (!ref.startsWith("@")) throw new RuntimeException("Unable to set reference: " + ref);
            ref = ref.substring(1);
            node.setAttribute(ref, value);
            return;
        } else {
            Writable writable = node.getWritable();
            if (writable == null || writable == Writable.NEVER) {
                throw new RuntimeException("Not writable");
            }
            Value current = node.getValue();
            if (!node.getValueType().compare(ValueType.DYNAMIC)) {
                this.checkValue(current, value);
            }
            node.setValue(value, true);
        }
    }

    private void checkValue(Value current, Value other) {
        ValueType otherType;
        if (current == null) {
            return;
        }
        ValueType currType = current.getType();
        if (currType != (otherType = other.getType())) {
            String expected = currType.toJsonString();
            String got = otherType.toJsonString();
            String error = "Type mismatch ";
            error = error + "(got: " + got + ", expected: " + expected + ")";
            throw new RuntimeException(error);
        }
    }
}

