/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.methods.responses;

import java.util.Map;
import org.dsa.iot.dslink.link.Requester;
import org.dsa.iot.dslink.methods.Response;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.NodeManager;
import org.dsa.iot.dslink.node.value.SubscriptionValue;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.node.value.ValueUtils;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;

public class SubscriptionUpdate
extends Response {
    private final Requester requester;
    private final NodeManager manager;

    public SubscriptionUpdate(Requester requester) {
        this.requester = requester;
        this.manager = requester.getDSLink().getNodeManager();
    }

    @Override
    public int getRid() {
        return 0;
    }

    @Override
    public void populate(JsonObject in) {
        JsonArray updates = (JsonArray)in.get("updates");
        Map<Integer, String> paths = this.requester.getSubscriptionIDs();
        Map<Integer, Handler<SubscriptionValue>> handlers = this.requester.getSubscriptionHandlers();
        if (updates != null) {
            for (Object obj : updates) {
                Handler<SubscriptionValue> handler;
                String timestamp;
                Object valueObj;
                String path;
                int rid;
                Iterable<Object> update;
                Number count = null;
                Number sum = null;
                Number min = null;
                Number max = null;
                if (obj instanceof JsonArray) {
                    update = (JsonArray)obj;
                    rid = (Integer)((JsonArray)update).get(0);
                    path = paths.get(rid);
                    valueObj = ((JsonArray)update).get(1);
                    timestamp = (String)((JsonArray)update).get(2);
                } else if (obj instanceof JsonObject) {
                    update = (JsonObject)obj;
                    rid = (Integer)((JsonObject)update).get("sid");
                    path = paths.get(rid);
                    valueObj = ((JsonObject)update).get("value");
                    timestamp = (String)((JsonObject)update).get("ts");
                    count = (Number)((JsonObject)update).get("count");
                    sum = (Number)((JsonObject)update).get("sum");
                    min = (Number)((JsonObject)update).get("min");
                    max = (Number)((JsonObject)update).get("max");
                } else {
                    String err = "Invalid subscription update: " + in;
                    throw new RuntimeException(err);
                }
                if (path == null) continue;
                Node node = this.manager.getNode(path, true).getNode();
                Value val = ValueUtils.toValue(valueObj, timestamp);
                if (val == null) {
                    ValueType type = node.getValueType();
                    if (type == null) continue;
                    val = ValueUtils.toEmptyValue(type, timestamp);
                }
                if ((handler = handlers.get(rid)) != null) {
                    SubscriptionValue value = new SubscriptionValue(path, val, count, sum, min, max);
                    handler.handle(value);
                }
                node.setValueType(val.getType());
                node.setValue(val);
            }
        }
    }

    @Override
    public JsonObject getJsonResponse(JsonObject in) {
        return null;
    }

    @Override
    public JsonObject getCloseResponse() {
        return null;
    }
}

