/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dsa.iot.dslink.link.Linkable;
import org.dsa.iot.dslink.node.MetaData;
import org.dsa.iot.dslink.node.NodeBuilder;
import org.dsa.iot.dslink.node.NodeListener;
import org.dsa.iot.dslink.node.NodeManager;
import org.dsa.iot.dslink.node.SubscriptionManager;
import org.dsa.iot.dslink.node.Writable;
import org.dsa.iot.dslink.node.actions.Action;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValuePair;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.serializer.SerializationManager;
import org.dsa.iot.dslink.util.StringUtils;

public class Node {
    private static final char[] BANNED_CHARS = new char[]{'%', '.', '/', '\\', '?', '*', ':', '|', '<', '>', '$', '@', ','};
    private final Object roConfigLock = new Object();
    private final Object configLock = new Object();
    private final Object attributeLock = new Object();
    private final Object interfaceLock = new Object();
    private final Object childrenLock = new Object();
    private final Object passwordLock = new Object();
    private final Object valueLock = new Object();
    private final WeakReference<Node> parent;
    private final Linkable link;
    private final String path;
    private final String name;
    private boolean serializable = true;
    private Map<String, Node> children;
    private NodeListener listener;
    private Writable writable;
    private Object metaData;
    private Map<String, Value> roConfigs;
    private Map<String, Value> configs;
    private Map<String, Value> attribs;
    private Boolean hasChildren;
    private boolean hidden;
    private ValueType valueType;
    private Value value;
    private String displayName;
    private String profile;
    private Set<String> interfaces;
    private Action action;
    private char[] pass;

    public Node(String name, Node parent, Linkable link) {
        this.parent = new WeakReference<Node>(parent);
        this.listener = new NodeListener(this);
        this.link = link;
        name = StringUtils.encodeName(name);
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (parent != null) {
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name");
            }
            this.name = name;
            this.path = parent instanceof NodeManager.SuperRoot ? "/" + name : parent.getPath() + "/" + name;
        } else {
            this.path = "/" + name;
            this.name = name;
        }
    }

    public Node getParent() {
        return (Node)this.parent.get();
    }

    public Linkable getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
        this.markChanged();
        if (this.link != null) {
            SubscriptionManager man = this.link.getSubscriptionManager();
            if (name != null) {
                man.postMetaUpdate(this, "$name", new Value(this.displayName));
            } else {
                man.postMetaUpdate(this, "$name", null);
            }
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setProfile(String profile) {
        this.profile = profile;
        this.markChanged();
    }

    public String getProfile() {
        return this.profile;
    }

    public NodeListener getListener() {
        return this.listener;
    }

    protected void setListener(NodeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterface(String _interface) {
        Object object = this.interfaceLock;
        synchronized (object) {
            if (_interface == null) {
                throw new NullPointerException("_interface");
            }
            if (this.interfaces == null) {
                this.interfaces = new HashSet<String>();
            }
            this.interfaces.add(_interface);
            this.markChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterface(String _interface) {
        Object object = this.interfaceLock;
        synchronized (object) {
            if (_interface == null) {
                throw new NullPointerException("_interface");
            }
            if (this.interfaces != null) {
                this.interfaces.remove(_interface);
                this.markChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterfaces(String interfaces) {
        Object object = this.interfaceLock;
        synchronized (object) {
            if (interfaces == null) {
                this.interfaces = null;
                return;
            }
            if (this.interfaces == null) {
                this.interfaces = new HashSet<String>();
            }
            String[] split = interfaces.split("\\|");
            Collections.addAll(this.interfaces, split);
            this.markChanged();
        }
    }

    public Set<String> getInterfaces() {
        Set<String> i = this.interfaces;
        return i != null ? Collections.unmodifiableSet(i) : null;
    }

    public void setValue(Value value) {
        this.setValue(value, false);
    }

    public void setValue(Value value, boolean externalSource) {
        this.setValue(value, externalSource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setValue(Value value, boolean externalSource, boolean publish) {
        ValuePair pair;
        ValueType type = this.valueType;
        if (type == null && value != null) {
            String err = "Value type not set on node (" + this.getPath() + ")";
            throw new RuntimeException(err);
        }
        Object object = this.valueLock;
        synchronized (object) {
            pair = new ValuePair(this.value, value, externalSource);
        }
        if (this.listener.postValueUpdate(pair)) {
            return false;
        }
        value = pair.getCurrent();
        if (value != null) {
            String err;
            if (type == null) {
                err = "Value type not set on node (" + this.getPath() + ")";
                throw new RuntimeException(err);
            }
            value.setImmutable();
            if (type.compare(ValueType.ENUM)) {
                if (!value.getType().compare(ValueType.STRING)) {
                    err = "[" + this.getPath() + "] ";
                    err = err + "Node has enum value type, value must be string";
                    throw new RuntimeException(err);
                }
                if (type.getEnums() == null || !type.getEnums().contains(value.getString())) {
                    err = "[" + this.getPath() + "] ";
                    err = err + "New value does not contain a valid enum value";
                    throw new RuntimeException(err);
                }
            } else if (type.compare(ValueType.TIME)) {
                if (!value.getType().compare(ValueType.STRING)) {
                    err = "[" + this.getPath() + "] ";
                    err = err + "Node has time value type, value must be string";
                    throw new RuntimeException(err);
                }
            } else if (!type.compare(ValueType.DYNAMIC) && !type.compare(value.getType())) {
                err = "[" + this.getPath() + "] ";
                err = err + "Expected value type ";
                err = err + "'" + type.toJsonString() + "' ";
                err = err + "got '" + value.getType().toJsonString() + "'";
                throw new RuntimeException(err);
            }
        }
        object = this.valueLock;
        synchronized (object) {
            SubscriptionManager manager;
            Value prev = this.value;
            this.value = value;
            if (prev != null && prev.isSerializable() || value != null && value.isSerializable() || prev == null && value == null) {
                this.markChanged();
            }
            if (publish && this.link != null && (manager = this.link.getSubscriptionManager()) != null) {
                manager.postValueUpdate(this);
            }
        }
        return true;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValueType(ValueType type) {
        this.valueType = type;
        this.markChanged();
        if (this.link != null) {
            SubscriptionManager man = this.link.getSubscriptionManager();
            if (type != null) {
                String t = type.toJsonString();
                man.postMetaUpdate(this, "$type", new Value(t));
            } else {
                man.postMetaUpdate(this, "$type", null);
            }
        }
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setWritable(Writable writable) {
        this.writable = writable;
        this.markChanged();
    }

    public Writable getWritable() {
        return this.writable;
    }

    public Map<String, Node> getChildren() {
        Map<String, Node> children = this.children;
        return children != null ? Collections.unmodifiableMap(children) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildren() {
        Object object = this.childrenLock;
        synchronized (object) {
            if (this.children != null) {
                Map<String, Node> children = this.getChildren();
                for (Node child : children.values()) {
                    this.removeChild(child);
                }
            }
            this.markChanged();
        }
    }

    public Node getChild(String name) {
        Map<String, Node> children = this.children;
        if (children != null) {
            name = StringUtils.encodeName(name);
            return children.get(name);
        }
        return null;
    }

    public NodeBuilder createChild(String name) {
        return this.createChild(name, this.profile);
    }

    public NodeBuilder createChild(String name, String profile) {
        NodeBuilder b = new NodeBuilder(this, new Node(name, this, this.link));
        if (profile != null) {
            b.setProfile(profile);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node addChild(Node node) {
        Object object = this.childrenLock;
        synchronized (object) {
            String name = node.getName();
            if (this.children == null) {
                this.children = new ConcurrentHashMap<String, Node>();
            } else if (this.children.containsKey(name)) {
                return this.children.get(name);
            }
            SubscriptionManager manager = null;
            if (this.link != null) {
                manager = this.link.getSubscriptionManager();
            }
            if (node.getProfile() == null) {
                node.setProfile(this.profile);
            }
            this.children.put(name, node);
            if (manager != null) {
                manager.postChildUpdate(node, false);
            }
            if (node.isSerializable()) {
                this.markChanged();
            }
            return node;
        }
    }

    public void delete() {
        Node parent = this.getParent();
        if (parent != null) {
            parent.removeChild(this);
        }
    }

    public Node removeChild(Node node) {
        if (node != null) {
            return this.removeChild(node.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node removeChild(String name) {
        Object object = this.childrenLock;
        synchronized (object) {
            name = StringUtils.encodeName(name);
            Node child = this.children != null ? this.children.remove(name) : null;
            SubscriptionManager manager = null;
            if (this.link != null) {
                manager = this.link.getSubscriptionManager();
            }
            if (child != null) {
                child.getListener().kill();
                if (manager != null) {
                    manager.postChildUpdate(child, true);
                    manager.removeValueSub(child);
                    manager.removePathSub(child);
                }
                if (this.isSerializable()) {
                    this.markChanged();
                }
            }
            return child;
        }
    }

    public boolean hasChild(String name) {
        Map<String, Node> children = this.children;
        if (children != null) {
            name = StringUtils.encodeName(name);
            return children.containsKey(name);
        }
        return false;
    }

    public Map<String, Value> getConfigurations() {
        Map<String, Value> c = this.configs;
        return c != null ? Collections.unmodifiableMap(c) : null;
    }

    public Value getConfig(String name) {
        Map<String, Value> c = this.configs;
        if (c != null) {
            name = StringUtils.encodeName(name);
            return c.get(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value removeConfig(String name) {
        Value ret;
        name = StringUtils.encodeName(name);
        Object object = this.configLock;
        synchronized (object) {
            ret = this.configs != null ? this.configs.remove(name) : null;
        }
        this.postRemoval("$", name, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Value> clearConfigs() {
        HashMap<String, Value> configs;
        Iterator iterator = this.configLock;
        synchronized (iterator) {
            if (this.configs == null) {
                return null;
            }
            configs = new HashMap<String, Value>(this.configs);
            this.configs.clear();
        }
        for (Map.Entry entry : configs.entrySet()) {
            this.postRemoval("$", (String)entry.getKey(), (Value)entry.getValue());
        }
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value setConfig(String name, Value value) {
        Object object = this.configLock;
        synchronized (object) {
            SubscriptionManager man;
            name = Node.checkAndEncodeName(name);
            if (value == null) {
                throw new NullPointerException("value");
            }
            if (this.configs == null) {
                this.configs = new ConcurrentHashMap<String, Value>();
            }
            switch (name) {
                case "params": 
                case "columns": 
                case "name": 
                case "is": 
                case "invokable": 
                case "interface": 
                case "permission": 
                case "result": 
                case "type": 
                case "writable": 
                case "hidden": {
                    String err = "Config `" + name + "` has special methods" + " for setting these properties";
                    throw new IllegalArgumentException(err);
                }
            }
            value.setImmutable();
            NodeListener.ValueUpdate update = new NodeListener.ValueUpdate(name, value, false);
            NodeListener listener = this.listener;
            if (listener != null) {
                listener.postConfigUpdate(update);
            }
            if ((man = this.link.getSubscriptionManager()) != null) {
                man.postMetaUpdate(this, "$" + name, value);
            }
            this.markChanged();
            return this.configs.put(name, value);
        }
    }

    public Map<String, Value> getRoConfigurations() {
        Map<String, Value> c = this.roConfigs;
        return c != null ? Collections.unmodifiableMap(c) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value removeRoConfig(String name) {
        Value ret;
        name = StringUtils.encodeName(name);
        Object object = this.roConfigLock;
        synchronized (object) {
            ret = this.roConfigs != null ? this.roConfigs.remove(name) : null;
        }
        this.postRemoval("$$", name, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Value> clearRoConfigs() {
        HashMap<String, Value> roConfigs;
        Iterator iterator = this.roConfigLock;
        synchronized (iterator) {
            if (this.roConfigs == null) {
                return null;
            }
            roConfigs = new HashMap<String, Value>(this.roConfigs);
            this.roConfigs.clear();
        }
        for (Map.Entry entry : roConfigs.entrySet()) {
            this.postRemoval("$$", (String)entry.getKey(), (Value)entry.getValue());
        }
        return roConfigs;
    }

    public Value getRoConfig(String name) {
        Map<String, Value> c = this.roConfigs;
        if (c != null) {
            name = StringUtils.encodeName(name);
            return c.get(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value setRoConfig(String name, Value value) {
        Object object = this.roConfigLock;
        synchronized (object) {
            name = Node.checkAndEncodeName(name);
            if (value == null) {
                throw new NullPointerException("value");
            }
            if (this.roConfigs == null) {
                this.roConfigs = new ConcurrentHashMap<String, Value>();
            }
            switch (name) {
                case "password": {
                    String err = "Config `" + name + "` has special methods" + " for setting these properties";
                    throw new IllegalArgumentException(err);
                }
            }
            SubscriptionManager man = this.link.getSubscriptionManager();
            if (man != null) {
                man.postMetaUpdate(this, "$$" + name, value);
            }
            this.markChanged();
            return this.roConfigs.put(name, value);
        }
    }

    public Map<String, Value> getAttributes() {
        Map<String, Value> a = this.attribs;
        return a != null ? Collections.unmodifiableMap(a) : null;
    }

    public Value getAttribute(String name) {
        Map<String, Value> a = this.attribs;
        if (a != null) {
            name = StringUtils.encodeName(name);
            return a.get(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value removeAttribute(String name) {
        Value ret;
        name = StringUtils.encodeName(name);
        Object object = this.attributeLock;
        synchronized (object) {
            ret = this.attribs != null ? this.attribs.remove(name) : null;
        }
        this.postRemoval("@", name, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Value> clearAttributes() {
        HashMap<String, Value> attribs;
        Iterator iterator = this.attributeLock;
        synchronized (iterator) {
            if (this.attribs == null) {
                return null;
            }
            attribs = new HashMap<String, Value>(this.attribs);
            this.attribs.clear();
        }
        for (Map.Entry entry : attribs.entrySet()) {
            this.postRemoval("@", (String)entry.getKey(), (Value)entry.getValue());
        }
        return attribs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value setAttribute(String name, Value value) {
        Object object = this.attributeLock;
        synchronized (object) {
            name = Node.checkAndEncodeName(name);
            if (value == null) {
                throw new NullPointerException("value");
            }
            if (this.attribs == null) {
                this.attribs = new ConcurrentHashMap<String, Value>();
            }
            value.setImmutable();
            NodeListener.ValueUpdate update = new NodeListener.ValueUpdate(name, value, false);
            this.listener.postAttributeUpdate(update);
            SubscriptionManager man = this.link.getSubscriptionManager();
            if (man != null) {
                man.postMetaUpdate(this, "@" + name, value);
            }
            this.markChanged();
            return this.attribs.put(name, value);
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
        this.markChanged();
        if (this.link == null) {
            return;
        }
        SubscriptionManager man = this.link.getSubscriptionManager();
        if (man != null) {
            if (action != null && !action.isHidden()) {
                Value params = new Value(action.getParams());
                Value cols = new Value(action.getColumns());
                man.postMetaUpdate(this, "$params", params);
                man.postMetaUpdate(this, "$columns", cols);
                action.setSubscriptionManager(this, man);
            } else {
                man.postMetaUpdate(this, "$params", null);
                man.postMetaUpdate(this, "$columns", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getPassword() {
        Object object = this.passwordLock;
        synchronized (object) {
            return this.pass != null ? (char[])this.pass.clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(char[] password) {
        Object object = this.passwordLock;
        synchronized (object) {
            this.pass = password != null ? (char[])password.clone() : null;
            this.markChanged();
        }
    }

    public void setHasChildren(Boolean hasChildren) {
        this.hasChildren = hasChildren;
        this.markChanged();
    }

    public Boolean getHasChildren() {
        return this.hasChildren;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.markChanged();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public NodeBuilder createFakeBuilder() {
        return new NodeBuilder(this.getParent(), this){

            @Override
            public Node build() {
                return Node.this;
            }
        };
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public void setSerializable(boolean serializable) {
        this.serializable = serializable;
        this.markChanged();
    }

    public void setMetaData(Object object) {
        if (object instanceof MetaData) {
            ((MetaData)object).setNode(this);
        }
        this.metaData = object;
    }

    public <T> T getMetaData() {
        return (T)this.metaData;
    }

    public void reset() {
        this.clearChildren();
        this.clearConfigs();
        this.clearRoConfigs();
        this.clearAttributes();
        this.setPassword(null);
        this.setDisplayName(null);
        this.setAction(null);
        this.setInterfaces(null);
        this.setValue(null);
        this.setValueType(null);
        this.setWritable(null);
    }

    private void markChanged() {
        SerializationManager sm;
        if (!this.isSerializable()) {
            return;
        }
        Linkable link = this.getLink();
        if (link != null && (sm = link.getSerialManager()) != null) {
            sm.markChanged();
        }
    }

    private void postRemoval(String prefix, String name, Value value) {
        if (value == null) {
            return;
        }
        NodeListener.ValueUpdate update = new NodeListener.ValueUpdate(name, value, true);
        if ("$".equals(prefix)) {
            this.listener.postConfigUpdate(update);
        } else if ("@".equals(prefix)) {
            this.listener.postAttributeUpdate(update);
        }
        SubscriptionManager man = this.link.getSubscriptionManager();
        if (man != null) {
            man.postMetaUpdate(this, prefix + name, null);
        }
        this.markChanged();
    }

    public static String checkAndEncodeName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name");
        }
        return StringUtils.encodeName(name);
    }

    public static char[] getBannedCharacters() {
        return (char[])BANNED_CHARS.clone();
    }
}

