/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node;

import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.NodeListener;
import org.dsa.iot.dslink.node.Writable;
import org.dsa.iot.dslink.node.actions.Action;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueType;

public class NodeBuilder {
    private final Node parent;
    private final Node child;

    public NodeBuilder(Node parent, Node child) {
        this.parent = parent;
        this.child = child;
    }

    public NodeBuilder setDisplayName(String name) {
        this.child.setDisplayName(name);
        return this;
    }

    public NodeBuilder setProfile(String profile) {
        this.child.setProfile(profile);
        return this;
    }

    public NodeBuilder setValue(Value value) {
        this.child.setValue(value);
        return this;
    }

    public NodeBuilder setValueType(ValueType type) {
        this.child.setValueType(type);
        return this;
    }

    public NodeBuilder setAction(Action action) {
        this.child.setAction(action);
        return this;
    }

    public NodeBuilder setConfig(String name, Value value) {
        this.child.setConfig(name, value);
        return this;
    }

    public NodeBuilder setRoConfig(String name, Value value) {
        this.child.setRoConfig(name, value);
        return this;
    }

    public NodeBuilder setAttribute(String name, Value value) {
        this.child.setAttribute(name, value);
        return this;
    }

    public NodeBuilder setInterfaces(String interfaces) {
        this.child.setInterfaces(interfaces);
        return this;
    }

    public NodeBuilder addInterface(String name) {
        this.child.addInterface(name);
        return this;
    }

    public NodeBuilder setPassword(char[] password) {
        this.child.setPassword(password);
        return this;
    }

    public NodeBuilder setWritable(Writable writable) {
        this.child.setWritable(writable);
        return this;
    }

    public NodeBuilder setMetaData(Object object) {
        this.child.setMetaData(object);
        return this;
    }

    public NodeBuilder setHasChildren(Boolean hasChildren) {
        this.child.setHasChildren(hasChildren);
        return this;
    }

    public NodeBuilder setHidden(boolean hidden) {
        this.child.setHidden(hidden);
        return this;
    }

    public NodeBuilder setSerializable(boolean serializable) {
        this.child.setSerializable(serializable);
        return this;
    }

    public NodeListener getListener() {
        return this.child.getListener();
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getChild() {
        return this.child;
    }

    public Node build() {
        Node node = this.parent.addChild(this.child);
        node.setSerializable(this.child.isSerializable());
        node.setProfile(this.child.getProfile());
        node.setMetaData(this.child.getMetaData());
        Action parentAct = node.getAction();
        Action childAct = this.child.getAction();
        if (parentAct != childAct) {
            node.setAction(this.child.getAction());
        }
        node.setListener(this.child.getListener());
        return node;
    }
}

