/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node;

import java.lang.ref.WeakReference;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValuePair;
import org.dsa.iot.dslink.util.handler.Handler;

public class NodeListener {
    private final WeakReference<Node> node;
    private Handler<ValuePair> valueHandler;
    private Handler<ValueUpdate> configHandler;
    private Handler<ValueUpdate> attribHandler;
    private Handler<Node> listHandler;
    private Handler<Node> listClosedHandler;
    private Handler<Node> onSubscribedHandler;
    private Handler<Node> onUnsubscribedHandler;

    public NodeListener(Node node) {
        this.node = new WeakReference<Node>(node);
    }

    public void setValueHandler(Handler<ValuePair> handler) {
        this.valueHandler = handler;
    }

    protected boolean postValueUpdate(ValuePair pair) {
        Handler<ValuePair> handler = this.valueHandler;
        if (handler != null) {
            handler.handle(pair);
            return pair.isRejected();
        }
        return false;
    }

    public void setConfigHandler(Handler<ValueUpdate> handler) {
        this.configHandler = handler;
    }

    protected void postConfigUpdate(ValueUpdate update) {
        Handler<ValueUpdate> handler = this.configHandler;
        if (handler != null) {
            handler.handle(update);
        }
    }

    public void setAttributeHandler(Handler<ValueUpdate> handler) {
        this.attribHandler = handler;
    }

    protected void postAttributeUpdate(ValueUpdate update) {
        Handler<ValueUpdate> handler = this.attribHandler;
        if (handler != null) {
            handler.handle(update);
        }
    }

    public void setOnListHandler(Handler<Node> handler) {
        this.listHandler = handler;
    }

    public void setOnListClosedHandler(Handler<Node> handler) {
        this.listClosedHandler = handler;
    }

    public void postListUpdate() {
        Node node;
        Handler<Node> handler = this.listHandler;
        if (handler != null && (node = (Node)this.node.get()) != null) {
            handler.handle(node);
        }
    }

    public void postListClosed() {
        Node node;
        Handler<Node> handler = this.listClosedHandler;
        if (handler != null && (node = (Node)this.node.get()) != null) {
            handler.handle(node);
        }
    }

    public void setOnSubscribeHandler(Handler<Node> handler) {
        this.onSubscribedHandler = handler;
    }

    protected void postOnSubscription() {
        Node node;
        Handler<Node> handler = this.onSubscribedHandler;
        if (handler != null && (node = (Node)this.node.get()) != null) {
            handler.handle(node);
        }
    }

    public void setOnUnsubscribeHandler(Handler<Node> handler) {
        this.onUnsubscribedHandler = handler;
    }

    protected void postOnUnsubscription() {
        Node node;
        Handler<Node> handler = this.onUnsubscribedHandler;
        if (handler != null && (node = (Node)this.node.get()) != null) {
            handler.handle(node);
        }
    }

    public void kill() {
        this.setValueHandler(null);
        this.setOnSubscribeHandler(null);
        this.setOnUnsubscribeHandler(null);
        this.setOnListHandler(null);
        this.setAttributeHandler(null);
        this.setConfigHandler(null);
    }

    public static class ValueUpdate {
        private final String name;
        private final Value value;
        private final boolean removed;

        public ValueUpdate(String name, Value value, boolean removed) {
            this.name = name;
            this.value = value;
            this.removed = removed;
        }

        public String name() {
            return this.name;
        }

        public Value value() {
            return this.value;
        }

        public boolean removed() {
            return this.removed;
        }
    }
}

