/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node;

import java.util.Map;
import org.dsa.iot.dslink.link.Linkable;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.NodeBuilder;
import org.dsa.iot.dslink.node.NodePair;
import org.dsa.iot.dslink.node.exceptions.NoSuchPathException;
import org.dsa.iot.dslink.util.StringUtils;

public class NodeManager {
    private final Node superRoot;
    private final String defaultProfile;

    public NodeManager(Linkable link, String defaultProfile) {
        this.superRoot = new SuperRoot(link, defaultProfile);
        this.defaultProfile = defaultProfile;
    }

    public NodeBuilder createRootNode(String name) {
        return this.createRootNode(name, this.defaultProfile);
    }

    public NodeBuilder createRootNode(String name, String profile) {
        NodeBuilder builder = this.superRoot.createChild(name);
        builder.setProfile(profile);
        return builder;
    }

    public Node getSuperRoot() {
        return this.superRoot;
    }

    public Map<String, Node> getChildren(String path) {
        Node child = this.getNode(path).getNode();
        if (child == null) {
            throw new NoSuchPathException(path);
        }
        return child.getChildren();
    }

    public NodePair getNode(String path) {
        return this.getNode(path, false);
    }

    public NodePair getNode(String path, boolean create) {
        return this.getNode(path, create, true);
    }

    public NodePair getNode(String path, boolean create, boolean willThrow) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if ("/".equals(path)) {
            return new NodePair(this.superRoot, null);
        }
        String[] parts = NodeManager.splitPath(path);
        if (parts.length == 1 && StringUtils.isReference(parts[0])) {
            return new NodePair(this.superRoot, parts[0]);
        }
        Node current = this.superRoot.getChild(parts[0]);
        if (create && current == null) {
            NodeBuilder b = this.superRoot.createChild(parts[0]);
            b.setProfile(this.defaultProfile);
            current = b.build();
        }
        for (int i = 1; i < parts.length && current != null; ++i) {
            if (i + 1 == parts.length && StringUtils.isReference(parts[i])) {
                return new NodePair(current, parts[i]);
            }
            Node temp = current.getChild(parts[i]);
            if (create && temp == null) {
                NodeBuilder b = current.createChild(parts[i]);
                b.setProfile(this.defaultProfile);
                temp = b.build();
            }
            current = temp;
        }
        if (current == null && willThrow) {
            throw new NoSuchPathException(path);
        }
        return new NodePair(current, null);
    }

    public static String[] splitPath(String path) {
        return NodeManager.normalizePath(path).split("/");
    }

    public static String normalizePath(String path) {
        return NodeManager.normalizePath(path, false);
    }

    public static String normalizePath(String path, boolean leading) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("path null or empty");
        }
        if (path.contains("//")) {
            throw new IllegalArgumentException("path contains //");
        }
        if ("/".equals(path)) {
            return path;
        }
        if (!leading && path.startsWith("/")) {
            path = path.substring(1);
        } else if (leading && !path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static class SuperRoot
    extends Node {
        private SuperRoot(Linkable link, String profile) {
            super("", null, link);
            super.setProfile(profile);
        }
    }
}

