/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.dsa.iot.dslink.DSLink;
import org.dsa.iot.dslink.methods.responses.ListResponse;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.NodeListener;
import org.dsa.iot.dslink.node.NodeManager;
import org.dsa.iot.dslink.node.storage.FileDriver;
import org.dsa.iot.dslink.node.storage.StorageDriver;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.util.Objects;
import org.dsa.iot.dslink.util.StringUtils;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;

public class SubscriptionManager {
    private static final StorageDriver DRIVER = new FileDriver();
    private final Map<String, ListResponse> pathSubsMap = new ConcurrentHashMap<String, ListResponse>();
    private final Map<String, Subscription> valueSubsPaths = new HashMap<String, Subscription>();
    private final Map<Integer, String> valueSubsSids = new HashMap<Integer, String>();
    private final Object valueLock = new Object();
    private final DSLink link;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionManager(DSLink link) {
        this.link = link;
        Object object = this.valueLock;
        synchronized (object) {
            DRIVER.read(this.valueSubsPaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        HashMap<String, Subscription> subs;
        ScheduledThreadPoolExecutor stpe = Objects.getDaemonThreadPool();
        NodeManager manager = this.link.getNodeManager();
        Object object = this.valueLock;
        synchronized (object) {
            subs = new HashMap<String, Subscription>(this.valueSubsPaths);
            this.valueSubsSids.clear();
        }
        Iterator<Object> it = subs.entrySet().iterator();
        while (it.hasNext()) {
            NodeListener listener;
            Map.Entry entry = it.next();
            Subscription sub = (Subscription)entry.getValue();
            if (sub.qos() > 0) continue;
            it.remove();
            String path = (String)entry.getKey();
            Node node = manager.getNode(path, false, false).getNode();
            if (node == null || (listener = node.getListener()) == null) continue;
            stpe.execute(new Runnable(){

                @Override
                public void run() {
                    listener.postOnUnsubscription();
                }
            });
        }
        it = this.pathSubsMap.keySet().iterator();
        while (it.hasNext()) {
            NodeListener listener;
            String path = (String)it.next();
            it.remove();
            Node node = manager.getNode(path, false, false).getNode();
            if (node == null || (listener = node.getListener()) == null) continue;
            stpe.execute(new Runnable(){

                @Override
                public void run() {
                    listener.postListClosed();
                }
            });
        }
    }

    public boolean hasValueSub(Node node) {
        return this.valueSubsPaths.containsKey(node.getPath());
    }

    public boolean hasPathSub(Node node) {
        return node != null && this.pathSubsMap.containsKey(node.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValueSub(String path, int sid, int qos) {
        path = NodeManager.normalizePath(path, true);
        Object object = this.valueLock;
        synchronized (object) {
            Subscription sub = new Subscription(path, sid, qos);
            Subscription prev = this.valueSubsPaths.put(path, sub);
            boolean ret = false;
            if (prev != null) {
                ret = true;
                this.valueSubsSids.remove(prev.sid());
                JsonArray updates = DRIVER.getUpdates(sub);
                if (updates != null) {
                    JsonObject resp = new JsonObject();
                    resp.put("rid", 0);
                    resp.put("updates", updates);
                    this.link.getWriter().writeResponse(resp);
                    ret = true;
                }
            }
            this.valueSubsSids.put(sid, path);
            if (ret) {
                return;
            }
        }
        NodeManager man = this.link.getNodeManager();
        Node node = man.getNode(path, false, false).getNode();
        if (node != null) {
            this.postValueUpdate(node);
            node.getListener().postOnSubscription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValueSub(int sid) {
        String path;
        Object object = this.valueLock;
        synchronized (object) {
            path = this.valueSubsSids.remove(sid);
            if (path == null) {
                return;
            }
            this.valueSubsPaths.remove(path);
        }
        Node node = null;
        NodeManager man = this.link.getNodeManager();
        if (man != null) {
            node = man.getNode(path, false, false).getNode();
        }
        if (node != null) {
            node.getListener().postOnUnsubscription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValueSub(Node node) {
        Subscription sub;
        Object object = this.valueLock;
        synchronized (object) {
            sub = this.valueSubsPaths.remove(node.getPath());
        }
        if (sub != null) {
            this.removeValueSub(sub.sid());
        }
    }

    public void addPathSub(String path, ListResponse resp) {
        if (path == null) {
            return;
        }
        this.pathSubsMap.put(path, resp);
    }

    public void removePathSub(Node node) {
        if (node == null) {
            return;
        }
        this.pathSubsMap.remove(node.getPath());
    }

    public void postChildUpdate(Node child, boolean removed) {
        Node parent = child.getParent();
        if (parent == null) {
            return;
        }
        ListResponse resp = this.pathSubsMap.get(parent.getPath());
        if (resp != null) {
            resp.childUpdate(child, removed);
        }
    }

    public void batchValueUpdate(Map<Node, Value> updates) {
        this.batchValueUpdate(updates, true);
    }

    public void batchValueUpdate(Map<Node, Value> updates, boolean set) {
        if (updates == null) {
            return;
        }
        JsonArray jsonUpdates = null;
        for (Map.Entry<Node, Value> entry : updates.entrySet()) {
            Subscription sub;
            Node node = entry.getKey();
            Value val = entry.getValue();
            if (set) {
                node.setValue(val, false, false);
            }
            if ((sub = this.valueSubsPaths.get(node.getPath())) == null) continue;
            if (!this.link.isConnected()) {
                if (sub.qos() <= 0) continue;
                DRIVER.store(sub, val);
                continue;
            }
            if (jsonUpdates == null) {
                jsonUpdates = new JsonArray();
            }
            jsonUpdates.add(sub.generateUpdate(val));
        }
        if (jsonUpdates != null) {
            JsonObject resp = new JsonObject();
            resp.put("rid", 0);
            resp.put("updates", jsonUpdates);
            this.link.getWriter().writeResponse(resp);
        }
    }

    public void postValueUpdate(Node node) {
        Value value = node.getValue();
        Map<Node, Value> map = Collections.singletonMap(node, value);
        this.batchValueUpdate(map, false);
    }

    public void postMetaUpdate(Node node, String name, Value value) {
        ListResponse resp = this.pathSubsMap.get(node.getPath());
        if (resp != null) {
            resp.metaUpdate(name, value);
        }
    }

    public static class Subscription {
        private final String path;
        private final int sid;
        private final int qos;

        public Subscription(String path, int sid, int qos) {
            this.path = StringUtils.encodeName(path);
            this.sid = sid;
            this.qos = qos;
        }

        public int sid() {
            return this.sid;
        }

        public int qos() {
            return this.qos;
        }

        public String path() {
            return this.path;
        }

        public JsonArray generateUpdate(Value val) {
            JsonArray update = new JsonArray();
            update.add(this.sid());
            if (val != null) {
                update.add(val);
                update.add(val.getTimeStamp());
            } else {
                update.add(null);
            }
            return update;
        }
    }
}

