/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node.actions;

import java.util.Collection;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.Permission;
import org.dsa.iot.dslink.node.SubscriptionManager;
import org.dsa.iot.dslink.node.actions.ActionResult;
import org.dsa.iot.dslink.node.actions.EditorType;
import org.dsa.iot.dslink.node.actions.Parameter;
import org.dsa.iot.dslink.node.actions.ResultType;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;

public class Action {
    protected JsonArray params = new JsonArray();
    protected JsonArray results = new JsonArray();
    private SubscriptionManager manager;
    private Node node;
    private Permission permission;
    private ResultType resultType;
    private boolean hidden;
    private final Handler<ActionResult> handler;

    public Action(Permission permission, Handler<ActionResult> handler) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        this.resultType = ResultType.VALUES;
        this.permission = permission;
        this.handler = handler;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setPermission(Permission permission) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        this.permission = permission;
    }

    public Action setResultType(ResultType type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.resultType = type;
        return this;
    }

    public Action addParameter(Parameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter");
        }
        JsonObject param = this.paramToJson(parameter);
        if (param != null) {
            this.params.add(param);
        }
        return this;
    }

    public Action addResult(Parameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter");
        }
        if (parameter.getDefault() != null) {
            String err = "Parameter cannot contain a default value in a result";
            throw new IllegalStateException(err);
        }
        if (parameter.getEditorType() != null) {
            String err = "Parameter cannot contain an editor type";
            throw new IllegalStateException(err);
        }
        JsonObject result = this.paramToJson(parameter);
        if (result != null) {
            this.results.add(result);
        }
        return this;
    }

    public void setParams(Collection<Parameter> newParams) {
        this.params = new JsonArray();
        for (Parameter p : newParams) {
            this.addParameter(p);
        }
        this.postParamsUpdate();
    }

    public void setSubscriptionManager(Node node, SubscriptionManager manager) {
        this.node = node;
        this.manager = manager;
    }

    public void invoke(ActionResult result) {
        if (!this.hasPermission()) {
            return;
        }
        this.handler.handle(result);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean hasPermission() {
        return this.permission != Permission.NONE;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public JsonArray getParams() {
        return this.params;
    }

    public JsonArray getColumns() {
        return this.results;
    }

    protected final void postParamsUpdate() {
        if (this.node != null && this.manager != null) {
            Value v = new Value(this.getParams());
            this.manager.postMetaUpdate(this.node, "$params", v);
        }
    }

    protected JsonObject paramToJson(Parameter param) {
        String placeHolder;
        String description;
        EditorType type;
        if (param == null) {
            return null;
        }
        JsonObject obj = new JsonObject();
        obj.put("name", param.getName());
        obj.put("type", param.getType().toJsonString());
        Value defVal = param.getDefault();
        if (defVal != null) {
            obj.put("default", defVal);
        }
        if ((type = param.getEditorType()) != null) {
            obj.put("editor", type.toJsonString());
        }
        if ((description = param.getDescription()) != null) {
            obj.put("description", description);
        }
        if ((placeHolder = param.getPlaceHolder()) != null) {
            obj.put("placeholder", placeHolder);
        }
        return obj;
    }
}

