/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node.actions;

import org.dsa.iot.dslink.methods.StreamState;
import org.dsa.iot.dslink.node.Node;
import org.dsa.iot.dslink.node.actions.table.Table;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.node.value.ValueUtils;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.JsonObject;

public class ActionResult {
    private final Node node;
    private final JsonObject jsonIn;
    private Table table;
    private StreamState state = StreamState.CLOSED;
    private Handler<Void> closeHandler;

    public ActionResult(Node node, JsonObject in) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (in == null) {
            throw new NullPointerException("in");
        }
        this.node = node;
        this.jsonIn = in;
    }

    public Node getNode() {
        return this.node;
    }

    public Value getParameter(String name) {
        return this.getParameter(name, (Value)null);
    }

    public Value getParameter(String name, ValueType type) {
        Value ret = this.getParameter(name);
        if (ret == null) {
            throw new RuntimeException("Missing parameter: " + name);
        }
        ValueUtils.checkType(name, type, ret);
        return ret;
    }

    public Value getParameter(String name, Value def) {
        JsonObject params = (JsonObject)this.jsonIn.get("params");
        if (params == null) {
            return def;
        }
        Object obj = params.get(name);
        if (obj == null) {
            return def;
        }
        Value ret = ValueUtils.toValue(obj);
        if (def != null) {
            ValueUtils.checkType(name, def.getType(), ret);
        }
        return ret;
    }

    public Table getTable() {
        if (this.table == null) {
            this.table = new Table();
            return this.table;
        }
        return this.table;
    }

    public void setTable(Table table) {
        if (table == null) {
            throw new NullPointerException("table");
        }
        this.table = table;
    }

    public StreamState getStreamState() {
        return this.state;
    }

    public void setStreamState(StreamState state) {
        if (state == null) {
            throw new NullPointerException("state");
        }
        this.state = state;
    }

    public void setCloseHandler(Handler<Void> handler) {
        this.closeHandler = handler;
    }

    public Handler<Void> getCloseHandler() {
        return this.closeHandler;
    }
}

