/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node.actions;

import org.dsa.iot.dslink.node.actions.EditorType;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.util.json.JsonObject;

public class Parameter {
    private final String name;
    private ValueType type;
    private Value defVal;
    private EditorType editorType;
    private String description;
    private String placeHolder;
    private JsonObject meta;

    public Parameter(String name, ValueType type) {
        this(name, type, null);
    }

    public Parameter(String name, ValueType type, Value def) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.name = name;
        this.type = type;
        this.defVal = def;
    }

    public Parameter setValueType(ValueType type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
        return this;
    }

    public Parameter setDefaultValue(Value def) {
        this.defVal = def;
        return this;
    }

    public Parameter setEditorType(EditorType type) {
        if (type == null) {
            this.editorType = null;
            return this;
        }
        if (!this.type.compare(ValueType.STRING)) {
            throw new RuntimeException("Parameter must be of type string");
        }
        this.editorType = type;
        return this;
    }

    public EditorType getEditorType() {
        return this.editorType;
    }

    public Parameter setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Parameter setPlaceHolder(String placeHolder) {
        this.placeHolder = placeHolder;
        return this;
    }

    public Parameter setMetaData(JsonObject meta) {
        this.meta = meta;
        return this;
    }

    public JsonObject getMetaData() {
        return this.meta;
    }

    public String getPlaceHolder() {
        return this.placeHolder;
    }

    public String getName() {
        return this.name;
    }

    public ValueType getType() {
        return this.type;
    }

    public Value getDefault() {
        return this.defVal;
    }
}

