/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node.actions.table;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.dsa.iot.dslink.connection.DataHandler;
import org.dsa.iot.dslink.link.Responder;
import org.dsa.iot.dslink.methods.StreamState;
import org.dsa.iot.dslink.node.actions.Parameter;
import org.dsa.iot.dslink.node.actions.table.BatchRow;
import org.dsa.iot.dslink.node.actions.table.Row;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.util.handler.Handler;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;

public class Table {
    private List<Parameter> columns;
    private List<Row> rows;
    private Mode mode;
    private JsonObject meta;
    private boolean ready;
    private int rid;
    private DataHandler writer;
    private Responder responder;
    private Handler<Void> closeHandler;

    public synchronized void addColumn(Parameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter");
        }
        if (this.columns == null) {
            this.columns = new LinkedList<Parameter>();
        }
        this.columns.add(parameter);
    }

    public synchronized void setTableMeta(JsonObject meta) {
        this.meta = meta;
    }

    public void addBatchRows(BatchRow batch) {
        this.addBatchRows(null, batch);
    }

    public synchronized void addBatchRows(List<Parameter> cols, BatchRow batch) {
        DataHandler writer = this.writer;
        if (batch == null) {
            throw new NullPointerException("batch");
        }
        if (this.rows == null && writer == null) {
            this.rows = new LinkedList<Row>();
        }
        if (writer == null) {
            this.setColumns(cols);
            this.rows.addAll(batch.getRows());
        } else {
            JsonArray updates = new JsonArray();
            for (Row r : batch.getRows()) {
                updates.add(this.processRow(r));
            }
            BatchRow.Modifier m = batch.getModifier();
            JsonObject meta = null;
            if (m != null) {
                meta = new JsonObject();
                meta.put("modify", batch.getModifier().get());
            }
            this.write(writer, cols, updates, meta);
        }
    }

    public void addRow(Row row) {
        this.addRow(null, row);
    }

    public synchronized void addRow(List<Parameter> cols, Row row) {
        DataHandler writer = this.writer;
        if (row == null) {
            throw new NullPointerException("row");
        }
        if (this.rows == null && writer == null) {
            this.rows = new LinkedList<Row>();
        }
        if (writer == null) {
            this.setColumns(cols);
            this.rows.add(row);
        } else {
            JsonArray updates = new JsonArray();
            updates.add(this.processRow(row));
            this.write(writer, cols, updates, null);
        }
    }

    public synchronized void setMode(Mode mode) {
        DataHandler writer = this.writer;
        if (mode == null) {
            throw new NullPointerException("mode");
        }
        if (writer == null) {
            this.mode = mode;
        } else {
            JsonObject meta = new JsonObject();
            meta.put("mode", mode.getName());
            this.write(writer, null, null, meta);
        }
    }

    public synchronized Mode getMode() {
        return this.mode;
    }

    public synchronized void setStreaming(int rid, DataHandler writer, Responder responder, Handler<Void> closeHandler) {
        this.rid = rid;
        this.writer = writer;
        this.responder = responder;
        this.closeHandler = closeHandler;
        if (this.ready) {
            this.sendReady();
        }
        this.rows = null;
        this.columns = null;
        this.mode = null;
    }

    public synchronized void close() {
        DataHandler writer = this.writer;
        if (writer != null) {
            JsonObject obj = new JsonObject();
            obj.put("rid", this.rid);
            obj.put("stream", StreamState.CLOSED.getJsonName());
            writer.writeResponse(obj);
            this.writer = null;
            Handler<Void> closeHandler = this.closeHandler;
            if (closeHandler != null) {
                this.closeHandler = null;
                closeHandler.handle(null);
            }
        }
        this.setClosed();
    }

    public synchronized void setClosed() {
        if (this.responder != null) {
            this.responder.removeResponse(this.rid);
        }
        this.writer = null;
        this.columns = null;
        this.rows = null;
        this.mode = null;
        this.closeHandler = null;
        this.meta = null;
        this.responder = null;
    }

    public synchronized JsonObject getTableMeta() {
        return this.meta;
    }

    public synchronized List<Parameter> getColumns() {
        return this.columns != null ? Collections.unmodifiableList(this.columns) : null;
    }

    public List<Row> getRows() {
        return this.getRows(false);
    }

    public synchronized List<Row> getRows(boolean copy) {
        if (copy) {
            return this.rows != null ? new LinkedList<Row>(this.rows) : null;
        }
        return this.rows != null ? Collections.unmodifiableList(this.rows) : null;
    }

    public synchronized void sendReady() {
        if (this.writer == null) {
            this.ready = true;
            return;
        }
        this.ready = false;
        JsonObject obj = new JsonObject();
        obj.put("rid", this.rid);
        obj.put("stream", StreamState.OPEN.getJsonName());
        this.writer.writeResponse(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setColumns(List<Parameter> cols) {
        if (cols == null) {
            return;
        }
        Table table = this;
        synchronized (table) {
            if (this.columns == null) {
                this.columns = new LinkedList<Parameter>(cols);
            } else {
                this.columns.addAll(cols);
            }
        }
    }

    private void write(DataHandler writer, List<Parameter> cols, JsonArray updates, JsonObject meta) {
        JsonArray array;
        JsonObject obj = new JsonObject();
        obj.put("rid", this.rid);
        if (this.ready) {
            this.ready = false;
            obj.put("stream", StreamState.OPEN.getJsonName());
        }
        if (meta != null) {
            obj.put("meta", meta);
        }
        if (cols != null && (array = this.processColumns(cols)) != null) {
            obj.put("columns", array);
        }
        if (updates != null) {
            obj.put("updates", updates);
        }
        writer.writeResponse(obj);
    }

    private JsonArray processRow(Row row) {
        JsonArray rowArray = new JsonArray();
        List<Value> values = row.getValues();
        if (values != null) {
            for (Value v : values) {
                rowArray.add(v);
            }
        }
        return rowArray;
    }

    private JsonArray processColumns(List<Parameter> cols) {
        if (cols == null || cols.isEmpty()) {
            return null;
        }
        JsonArray array = new JsonArray();
        for (Parameter p : cols) {
            JsonObject o = new JsonObject();
            o.put("name", p.getName());
            o.put("type", p.getType().toJsonString());
            JsonObject meta = p.getMetaData();
            if (meta != null) {
                o.put("meta", meta);
            }
            array.add(o);
        }
        return array;
    }

    public static enum Mode {
        REFRESH("refresh"),
        APPEND("append"),
        STREAM("stream");

        private final String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        public String getName() {
            return this.mode;
        }
    }
}

