/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node.storage;

import io.netty.util.CharsetUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.dsa.iot.dslink.node.SubscriptionManager;
import org.dsa.iot.dslink.node.storage.StorageDriver;
import org.dsa.iot.dslink.node.value.Value;
import org.dsa.iot.dslink.node.value.ValueUtils;
import org.dsa.iot.dslink.util.FileUtils;
import org.dsa.iot.dslink.util.StringUtils;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDriver
implements StorageDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDriver.class);
    private final File storageDir = new File("storage");
    private final Map<String, Queue<Value>> updatesCache = new HashMap<String, Queue<Value>>();
    private final Map<String, Value> updateCache = new HashMap<String, Value>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(Map<String, SubscriptionManager.Subscription> map) {
        if (!this.storageDir.isDirectory()) {
            return;
        }
        File[] files = this.storageDir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            try {
                JsonArray jsonQueue;
                if (f == null || !f.getName().startsWith("%2F")) continue;
                String s = new String(FileUtils.readAllBytes(f), CharsetUtil.UTF_8);
                JsonObject obj = new JsonObject(s);
                int qos = (Integer)obj.get("qos");
                String path = StringUtils.decodeName(f.getName());
                SubscriptionManager.Subscription sub = new SubscriptionManager.Subscription(path, -1, qos);
                map.put(path, sub);
                if (qos == 2) {
                    String ts = (String)obj.get("ts");
                    Value val = ValueUtils.toValue(obj.get("value"), ts);
                    this.store(sub, val);
                    this.updateCache.put(path, val);
                    continue;
                }
                if (qos != 3 || (jsonQueue = (JsonArray)obj.get("queue")) == null) continue;
                Queue<Value> queue = this.updatesCache.get(path);
                if (queue == null) {
                    FileDriver fileDriver = this;
                    synchronized (fileDriver) {
                        queue = this.updatesCache.get(sub.path());
                        if (queue == null) {
                            queue = new LinkedBlockingQueue<Value>();
                            this.updatesCache.put(sub.path(), queue);
                        }
                    }
                }
                for (Object o : jsonQueue) {
                    JsonArray array = (JsonArray)o;
                    String ts = (String)array.get(1);
                    Value v = ValueUtils.toValue(array.get(0), ts);
                    queue.add(v);
                }
            }
            catch (Exception e) {
                String path = f.getName();
                String err = "Failed to handle QoS subscription data: {}\n{}";
                LOGGER.warn(err, (Object)path, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(SubscriptionManager.Subscription sub, Value value) {
        JsonObject obj = null;
        if (sub.qos() == 2) {
            this.updateCache.put(sub.path(), value);
            obj = new JsonObject();
            obj.put("qos", 2);
            if (value != null) {
                obj.put("value", value);
                obj.put("ts", value.getTimeStamp());
            }
        } else if (sub.qos() == 3) {
            if (value == null) {
                return;
            }
            Queue<Value> cache = this.updatesCache.get(sub.path());
            if (cache == null) {
                FileDriver fileDriver = this;
                synchronized (fileDriver) {
                    cache = this.updatesCache.get(sub.path());
                    if (cache == null) {
                        cache = new LinkedBlockingQueue<Value>();
                        this.updatesCache.put(sub.path(), cache);
                    }
                }
            }
            cache.add(value);
            if (cache.size() > 1000) {
                cache.remove();
            }
            obj = new JsonObject();
            JsonArray queue = new JsonArray();
            obj.put("queue", queue);
            obj.put("qos", 3);
            for (Value v : cache) {
                if (v == null) {
                    queue.add(null);
                    continue;
                }
                JsonArray array = new JsonArray();
                array.add(v);
                array.add(v.getTimeStamp());
                queue.add(array);
            }
        }
        if (obj != null) {
            if (!this.storageDir.exists() && !this.storageDir.mkdir()) {
                String full = this.storageDir.getAbsolutePath();
                LOGGER.info("Failed to create storage directory at {}", (Object)full);
            }
            File f = new File(this.storageDir, StringUtils.encodeName(sub.path()));
            try {
                byte[] bytes = obj.encode();
                FileUtils.write(f, bytes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public JsonArray getUpdates(SubscriptionManager.Subscription sub) {
        Value val;
        Queue<Value> cache = this.updatesCache.remove(sub.path());
        Value tmp = this.updateCache.remove(sub.path());
        if (tmp != null) {
            return sub.generateUpdate(tmp);
        }
        if (cache == null || cache.isEmpty()) {
            return null;
        }
        JsonArray updates = new JsonArray();
        while ((val = cache.poll()) != null) {
            JsonArray update = sub.generateUpdate(val);
            updates.add(update);
        }
        File f = new File(this.storageDir, sub.path());
        if (f.exists() && !f.delete()) {
            LOGGER.warn("Failed to delete QoS data at {}", (Object)sub.path());
        }
        return updates;
    }
}

