/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node.value;

import java.util.Arrays;
import org.dsa.iot.dslink.node.value.ValueType;
import org.dsa.iot.dslink.util.TimeUtils;
import org.dsa.iot.dslink.util.UrlBase64;
import org.dsa.iot.dslink.util.json.JsonArray;
import org.dsa.iot.dslink.util.json.JsonObject;

public class Value {
    private ValueType type;
    private boolean immutable;
    private boolean serializable = true;
    private long tsDate = -1L;
    private String tsFormatted;
    private Number number;
    private Boolean bool;
    private String string;
    private JsonObject map;
    private JsonArray array;
    private byte[] binary;

    public Value(byte[] b) {
        this.set(b);
    }

    public Value(byte[] b, String time) {
        this.set(b, time);
    }

    public Value(Number n) {
        this.set(n);
    }

    public Value(Number n, String time) {
        this.set(n, time);
    }

    public Value(Boolean b) {
        this.set(b);
    }

    public Value(Boolean b, String time) {
        this.set(b, time);
    }

    public Value(String s) {
        this.set(s);
    }

    public Value(String s, String time) {
        this.set(s, time);
    }

    public Value(JsonObject o) {
        this.set(o);
    }

    public Value(JsonObject o, String time) {
        this.set(o, time);
    }

    public Value(JsonArray a) {
        this.set(a);
    }

    public Value(JsonArray a, String time) {
        this.set(a, time);
    }

    public void set(byte[] b) {
        this.set(b, null);
    }

    public void set(byte[] b, String time) {
        this.set(ValueType.BINARY, b, null, null, null, null, null, time);
    }

    public void set(Number n) {
        this.set(n, null);
    }

    public void set(Number n, String time) {
        this.set(ValueType.NUMBER, null, n, null, null, null, null, time);
    }

    public void set(Boolean b) {
        this.set(b, null);
    }

    public void set(Boolean b, String time) {
        this.set(ValueType.BOOL, null, null, b, null, null, null, time);
    }

    public void set(String s) {
        this.set(s, null);
    }

    public void set(String s, String time) {
        String start;
        if (s != null && s.startsWith(start = "\u001bbytes:")) {
            s = s.substring(start.length(), s.length());
            byte[] bytes = UrlBase64.decode(s);
            this.set(bytes, time);
            return;
        }
        this.set(ValueType.STRING, null, null, null, s, null, null, time);
    }

    public void set(JsonObject object) {
        this.set(object, null);
    }

    public void set(JsonObject object, String time) {
        this.set(ValueType.MAP, null, null, null, null, null, object, time);
    }

    public void set(JsonArray array) {
        this.set(array, null);
    }

    public void set(JsonArray array, String time) {
        this.set(ValueType.ARRAY, null, null, null, null, array, null, time);
    }

    private void set(ValueType type, byte[] binary, Number n, Boolean b, String s, JsonArray a, JsonObject o, String time) {
        this.checkImmutable();
        this.type = type;
        if (time == null) {
            this.setTime(System.currentTimeMillis());
        } else {
            this.tsFormatted = time;
        }
        this.binary = binary == null ? null : (byte[])binary.clone();
        this.number = n;
        this.bool = b;
        this.string = s;
        this.array = a;
        this.map = o;
    }

    public void setTime(long ms) {
        this.checkImmutable();
        this.tsDate = ms;
        this.tsFormatted = null;
    }

    public void setSerializable(boolean serializable) {
        this.checkImmutable();
        this.serializable = serializable;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public ValueType getType() {
        return this.type;
    }

    public String getTimeStamp() {
        if (this.tsFormatted == null) {
            this.tsFormatted = TimeUtils.format(this.getTime());
        }
        return this.tsFormatted;
    }

    public long getTime() {
        if (this.tsDate == -1L) {
            this.tsDate = TimeUtils.parseTz(this.tsFormatted).getTime();
        }
        return this.tsDate;
    }

    public byte[] getBinary() {
        return this.binary == null ? null : (byte[])this.binary.clone();
    }

    public Number getNumber() {
        return this.number;
    }

    public Boolean getBool() {
        return this.bool;
    }

    public String getString() {
        return this.string;
    }

    public JsonObject getMap() {
        return this.map;
    }

    public JsonArray getArray() {
        return this.array;
    }

    public void setImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkImmutable() {
        if (this.isImmutable()) {
            String err = "Attempting to modify immutable value";
            throw new IllegalStateException(err);
        }
    }

    public String toString() {
        switch (this.type.toJsonString()) {
            case "number": {
                return this.number.toString();
            }
            case "bool": {
                return this.bool.toString();
            }
            case "string": {
                return this.string;
            }
            case "map": {
                return this.map.toString();
            }
            case "array": {
                return this.array.toString();
            }
            case "binary": {
                return Arrays.toString(this.binary);
            }
        }
        throw new RuntimeException("Unhandled type: " + this.type);
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof Value) {
            Value value = (Value)o;
            String compare = this.getType().toJsonString();
            if (value.getType().toJsonString().equals(compare)) {
                switch (compare) {
                    case "number": {
                        equal = this.objectEquals(this.number, value.number);
                        break;
                    }
                    case "time": 
                    case "string": {
                        equal = this.objectEquals(this.string, value.string);
                        break;
                    }
                    case "bool": {
                        equal = this.objectEquals(this.bool, value.bool);
                        break;
                    }
                    case "map": {
                        equal = this.objectEquals(this.map, value.map);
                        break;
                    }
                    case "array": {
                        equal = this.objectEquals(this.array, value.array);
                        break;
                    }
                    default: {
                        String err = "Bad type: " + this.getType();
                        throw new RuntimeException(err);
                    }
                }
            }
        }
        return equal;
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + (this.getNumber() != null ? this.getNumber().hashCode() : 0);
        result = 31 * result + (this.getBool() != null ? this.getBool().hashCode() : 0);
        result = 31 * result + (this.getString() != null ? this.getString().hashCode() : 0);
        result = 31 * result + (this.getMap() != null ? this.getMap().hashCode() : 0);
        result = 31 * result + (this.getArray() != null ? this.getArray().hashCode() : 0);
        return result;
    }

    private boolean objectEquals(Object a, Object b) {
        return a == null && b == null || a != null && a.equals(b);
    }
}

