/*
 * Decompiled with CFR 0.152.
 */
package org.dsa.iot.dslink.node.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.dsa.iot.dslink.util.StringUtils;

public final class ValueType {
    public static final String JSON_NUMBER = "number";
    public static final String JSON_STRING = "string";
    public static final String JSON_BOOL = "bool";
    public static final String JSON_MAP = "map";
    public static final String JSON_ARRAY = "array";
    public static final String JSON_TIME = "time";
    public static final String JSON_ENUM = "enum";
    public static final String JSON_BINARY = "binary";
    public static final String JSON_DYNAMIC = "dynamic";
    public static final ValueType NUMBER = new ValueType("number");
    public static final ValueType STRING = new ValueType("string");
    public static final ValueType BOOL = new ValueType("bool");
    public static final ValueType MAP = new ValueType("map");
    public static final ValueType ARRAY = new ValueType("array");
    public static final ValueType TIME = new ValueType("time");
    public static final ValueType DYNAMIC = new ValueType("dynamic");
    public static final ValueType ENUM = new ValueType("enum");
    public static final ValueType BINARY = new ValueType("binary");
    private final String rawName;
    private final String builtName;
    private final Collection<String> enums;

    private ValueType(String jsonName) {
        this(jsonName, jsonName);
    }

    private ValueType(String rawName, String builtName) {
        this(rawName, builtName, null);
    }

    private ValueType(String rawName, String builtName, Collection<String> enums) {
        this.rawName = rawName;
        this.builtName = builtName;
        this.enums = enums;
    }

    private ValueType(Collection<String> enums) {
        this(JSON_ENUM, "enum[" + StringUtils.join(enums, true, ",") + "]", enums);
    }

    public String toJsonString() {
        return this.builtName;
    }

    public String getRawName() {
        return this.rawName;
    }

    public boolean compare(ValueType other) {
        return this == other || this.rawName.equals(other.rawName);
    }

    public Collection<String> getEnums() {
        return this.enums != null ? Collections.unmodifiableCollection(this.enums) : null;
    }

    public static ValueType makeEnum(String ... enums) {
        return ValueType.makeEnum(Arrays.asList(enums));
    }

    public static ValueType makeEnum(Collection<String> enums) {
        return new ValueType(enums);
    }

    public static ValueType makeBool(String true_, String false_) {
        true_ = StringUtils.encodeName(true_);
        false_ = StringUtils.encodeName(false_);
        String contents = false_ + "," + true_;
        return new ValueType(JSON_BOOL, "bool[" + contents + "]", null);
    }

    public static ValueType toValueType(String type) {
        switch (type) {
            case "number": {
                return NUMBER;
            }
            case "string": {
                return STRING;
            }
            case "bool": {
                return BOOL;
            }
            case "map": {
                return MAP;
            }
            case "array": {
                return ARRAY;
            }
            case "time": {
                return TIME;
            }
            case "dynamic": {
                return DYNAMIC;
            }
            case "binary": {
                return BINARY;
            }
            case "enum": {
                return new ValueType(new ArrayList<String>(0));
            }
        }
        if (type.startsWith("bool[") && type.endsWith("]")) {
            return new ValueType(JSON_BOOL, type);
        }
        if (type.startsWith("enum[") && type.endsWith("]")) {
            type = type.substring(JSON_ENUM.length() + 1);
            type = type.substring(0, type.length() - 1);
            String[] split = type.split(",");
            return new ValueType(Arrays.asList(split));
        }
        throw new RuntimeException("Unknown type: " + type);
    }
}

